unit InfoMemo;

{ (C) 1995, ingenieursbureau Office Automation
  All Rights Reserved

  Hereby the right to distribute this work electronically is granted,
  provided such is done for at most a nominal fee. Also the right is
  granted to store this work on a computer system.
  Finally the right is granted to incorporate this work into other
  work provided no fee is asked for this work.
  In all cases of distribution this work must be distributed in full,
  which specifically includes this notice.
  Liability is limited to the amount payed for this work. Legal
  jurisdiction is with the court of Leeuwarden, the Netherlands.

  Roelof Osinga, 5 januari 1996

  PS The price for this work is a toast to my continued good health!

  CompuServe: [100013,262]
  Internet: roelof@iboa.knoware.nl
}
{
  Usage: Drop one on a form and set the Component property to one of
         the listed components. The available properties will be listed
         in the memo with name, value and type. Value can be set to '?'
         so as to indicate a not supported type like TFont, TColor, etc.
         for which special property editors are needed.
}

interface

uses
  Classes, Controls, Forms, Messages, SysUtils, WinProcs, StdCtrls;

type
  TInfoMemo = class(TMemo)
  protected
    FComponent : TComponent;
    procedure SetComponent(Value : TComponent);
  published
    property Component : TComponent read FComponent write SetComponent stored False;
  end;

procedure Register;

implementation

uses
  DsgnIntf, TypInfo, Consts;

{ =====================================================
  TInfoMemo
  ===================================================== }

procedure TInfoMemo.SetComponent(Value : TComponent);
type
  TCardinalSet = set of 0..SizeOf(Cardinal) * 8 - 1;
var
  i, j, Count: Integer;
  k, l : longint;
  x : extended;
  c : Cardinal;
  b, IsDefault : Boolean;
  PropInfo: PPropInfo;
  PropList: PPropList;
  PropType: PTypeInfo;
  TypeData: PTypeData;
  Instance, ObjValue: TObject;
  Method : TMethod;
  Field : ^TComponent;
  str : string;
  pstr : PString;
begin
  FComponent := Value;
  Lines.Clear;
    Instance := Value;
      Count := GetTypeData(Instance.ClassInfo)^.PropCount;
      Lines.Add('nr. of properties = ' + inttostr(Count));
      if Count > 0
      then begin
        GetMem(PropList, Count * SizeOf(Pointer));
        try
          GetPropInfos(Instance.ClassInfo, PropList);
          for j := 0 to Count - 1 do
          begin
            PropInfo := PropList^[j];
            PropType := PPropInfo(PropInfo)^.PropType;
            TypeData := GetTypeData(PropType);
            str := '';
            IsDefault := False;
            case PropType^.Kind of
              tkUnknown : str := 'unknown';
              tkClass : begin
                ObjValue := TObject(GetOrdProp(Instance, PropInfo));
                if ObjValue = nil
                then str := 'nil'
                else
                  if ObjValue is TComponent
                  then str := TComponent(ObjValue).Name
                  else str := '?';
              end;
              tkString : begin
                str := GetStrProp(Instance, PropInfo);
                IsDefault := str = '';
              end;
              tkEnumeration : begin
                k := GetOrdProp(Instance, PropInfo);
                if (k >=TypeData^.MinValue) and (k <=TypeData^.MaxValue)
                then begin
                  if TypeData^.BaseType <> nil
                  then TypeData := GetTypeData(TypeData^.BaseType);
                  pstr := @TypeData^.NameList;
                  while k > 0 do
                  begin
                    pstr := pointer(longint(pstr) + length(pstr^) + 1);
                    dec(k);
                  end;
                  str := str + pstr^;
                  IsDefault := k = PropInfo^.Default;
                end;
              end;
              tkSet : begin
                if TypeData^.CompType^.Kind <> tkEnumeration
                then str := 'set of ' + TypeData^.CompType^.Name
                else begin
                  str := '[';
                  c := GetOrdProp(Instance, PropInfo);
                  b := false;
                  for i := 0 to 15 do
                    if i in TCardinalSet(c)
                    then begin
                      if b
                      then str := str + ','
                      else b := true;
                      str := str + GetEnumName(TypeData^.CompType, i)^;
                    end;
                  str := str + ']';
                end;
              end;
              tkInteger : begin
                k := GetOrdProp(Instance, PropInfo);
                str := IntToStr(k);
                IsDefault := k = PropInfo^.Default;
              end;
              tkChar : begin
                str := Char(GetOrdProp(Instance, PropInfo));
                str := str + ' #' + inttostr(ord(str[1]));
                {IsDefault := str = ''}
              end;
              tkFloat : begin
                x := GetFloatProp(Instance, PropInfo);
                System.Str(x, str);
                IsDefault := x = 0
              end;
              tkMethod : begin
                Method := GetMethodProp(Instance, PropInfo);
                if Method.Code <> nil
                then str := TObject(Method.Data).MethodName(Method.Code)
                else IsDefault := True;
              end;
            end;
            if not IsDefault
            then Lines.Add(PropInfo^.Name + ' = ' + str + ' : ' + PropType^.Name);
          end;
        finally
          FreeMem(PropList, Count * SizeOf(Pointer));
        end;
      end;
end;

{ =====================================================
  Register
  ===================================================== }

procedure Register;
begin
  RegisterComponents('IBOA', [TInfoMemo]);
end;


end.
