unit Iv_bkmrk;

interface

uses
  {$ifdef Win32} Windows, {$else} WinProcs, WinTypes, {$endif} SysUtils,
  Classes, Controls, Forms, StdCtrls, Graphics, ExtCtrls, Buttons;

type
  TBkMarkForm = class(TForm)
    P1: TPanel;
    BtnDelete: TSpeedButton;
    BtnSeperator: TSpeedButton;
    BtnMoveDown: TSpeedButton;
    BtnMoveUp: TSpeedButton;
    BtnOK: TButton;
    BtnCancel: TButton;
    List: TListBox;
    procedure FormDestroy(Sender: TObject);
    procedure ListClick(Sender: TObject);
    procedure BtnDeleteClick(Sender: TObject);
    procedure BtnMoveUpClick(Sender: TObject);
    procedure BtnMoveDownClick(Sender: TObject);
    procedure BtnSeperatorClick(Sender: TObject);
    procedure ListKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ListDrawItem(Control: TWinControl; Index: Integer; R: TRect; State: TOwnerDrawState);
  public
    Mark : TBitmap;
    Modified : Boolean;
  end;

var BkMarkForm: TBkMarkForm;

implementation

{$R *.DFM}

procedure TBkMarkForm.FormDestroy(Sender: TObject);
begin
  Mark.Free;
end;

procedure TBkMarkForm.ListClick(Sender: TObject);
begin
  BtnMoveUp.enabled := true;
  BtnMoveDown.enabled := true;
  If List.ItemIndex = 0 then BtnMoveUp.enabled := false
  else if List.ItemIndex = List.Items.Count -1 then BtnMoveDown.enabled := false;
end;

procedure TBkMarkForm.BtnDeleteClick(Sender: TObject);
begin
  List.Items.Delete(List.ItemIndex);
  if List.Items.Count = 0 then
    begin
      BtnMoveUp.enabled := false;
      BtnMoveDown.enabled := false;
    end else
  BtnMoveUp.enabled := false;
  BtnMoveDown.enabled := false;
  Modified := true;
end;

procedure TBkMarkForm.BtnMoveUpClick(Sender: TObject);
var i : integer;
begin
  i := List.ItemIndex;
  With List do Items.Exchange(ItemIndex, ItemIndex-1);
  Modified := true;
  List.ItemIndex := i-1;
  ListClick(Sender);
end;

procedure TBkMarkForm.BtnMoveDownClick(Sender: TObject);
var i : integer;
begin
  i := List.ItemIndex;
  With List do Items.Exchange(ItemIndex, ItemIndex+1);
  Modified := true;
  List.ItemIndex := i+1;
  ListClick(Sender);
end;

procedure TBkMarkForm.BtnSeperatorClick(Sender: TObject);
var i:integer;
begin
  i := List.ItemIndex;
  List.Items.Insert(i,'-');
  List.ItemIndex :=i;
  Modified := true;
  ListClick(Sender);
end;

procedure TBkMarkForm.ListKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  ListClick(Sender);
end;

procedure TBkMarkForm.ListDrawItem(Control: TWinControl; Index: Integer; R: TRect; State: TOwnerDrawState);
var txt: string;
begin
  txt := List.Items[index];
  with List.Canvas do
  begin
    FillRect(R);
    if txt = '-' then
      begin
        Pen.Color := clBtnShadow;    MoveTo(0, R.top+6); LineTo(R.Right,R.Top+6);
        Pen.Color := clBtnHighLight; MoveTo(0, R.top+7); LineTo(R.Right,R.Top+7);
      end
    else
      begin
        BrushCopy( Rect(2, R.Top, 15, R.Bottom), Mark, Rect(0,0,12,12), clSilver);
        TextOut(16,R.Top,txt);
      end;
  end;
end;

end.
