{***********************************************************}
{*		ImageEdit v1.0.6			   *}
{*							   *}
{*		African Dancer				   *}
{*		Dancer@TieUs.com			   *}
{*                                                         *}
{*  features:                                              *}
{*    v1.0.0:                                              *}
{*      - RGB color balance, Gray scale                    *}
{*      - Flip horizontal/vertical                         *}
{*      - Print image                                      *}
{*      - Free-hand drawing, pick color, line              *}
{*        rectangle, round rec, ellipse                    *}
{*    v1.0.1:                                              *}
{*      - Flip 90 degrees                                  *}
{*      - Resize image                                     *}
{*      - Smear                                            *}
{*    v1.0.5:						   *}
{*      - Text						   *}
{*    v1.0.6:						   *}
{*      - Bug fixes					   *}
{*      - Polygon					   *}
{*							   *}
{*  If you have any great idea on painting or image        *}
{*  processing, or just want to comment on ImageEdit,      *}
{*  send me a e-mail                                       *}
{*                                                         *}
{***********************************************************}

unit Ie_main;

interface

uses
  {$ifdef Win32} Windows, {$else} WinProcs, WinTypes, {$endif} SysUtils,
  Messages, Classes, Graphics, Controls, Forms, StdCtrls, Buttons, Menus,
  Printers, ClipBrd, Dialogs, ExtCtrls, Spin, Gauges, IniFiles, Graphx;

const
  { tool id constant }
  dtFreeForm  = 0;
  dtText      = 2;
  dtLine      = 8;
  dtCurve     = 9;
  dtRectangle = 10;
  dtEllipse   = 11;
  dtRoundRect = 12;
  dtPolygon   = 13;
  dtPick      = 20;
  dtFloodFill = 21;

  { cursor constant }
  crIeDefault = 2;
  crIePenTool = 3;
  crIeFillTool = 4;
  crIeEditTool = 5;
  crIeDropTool = 6;

  { maximum points for a polygon tool }
  cMaxPolyPoints = 200;

type
  TPolyPoint = array[0..cMaxPolyPoints] of TPoint;

  TImageEdit = class(TForm)
    IEScroll: TScrollBox;
    IEImage: TImage;
    StatusBar: TPanel;
    OriginPanel: TPanel;
    CurrentPanel: TPanel;
    MainMenu: TMainMenu;
    mFile: TMenuItem;
    mPrint: TMenuItem;
    mEdit: TMenuItem;
    mCopy: TMenuItem;
    mPaste: TMenuItem;
    N1: TMenuItem;
    mResize: TMenuItem;
    mEffect: TMenuItem;
    mEfGray: TMenuItem;
    mEfBalance: TMenuItem;
    mEfInverse: TMenuItem;
    mEfSmear: TMenuItem;
    mEfSmear2: TMenuItem;
    mEfFlipHor: TMenuItem;
    mEfFlipVer: TMenuItem;
    mEfFlip90: TMenuItem;
    N2: TMenuItem;
    Panel2: TPanel;
    BtnOK: TBitBtn;
    BtnCancel: TBitBtn;
    mView: TMenuItem;
    mToolbar: TMenuItem;
    TToolBar: TPanel;
    mPropertyBar: TMenuItem;
    BtnMarker: TSpeedButton;
    BtnPick: TSpeedButton;
    BtnFill: TSpeedButton;
    BtnTxt: TSpeedButton;
    BtnLine: TSpeedButton;
    BtnCurve: TSpeedButton;
    BtnRect: TSpeedButton;
    BtnRRect: TSpeedButton;
    TColorBar: TPanel;
    Bevel4: TBevel;
    ColorPick: TImage;
    Bevel2: TBevel;
    BtnEllipse: TSpeedButton;
    BtnGrayScale: TSpeedButton;
    BtnInverse: TSpeedButton;
    BtnRGB: TSpeedButton;
    BtnSmear: TSpeedButton;
    BtnSmear2: TSpeedButton;
    BtnFlipHor: TSpeedButton;
    BtnFlipVer: TSpeedButton;
    BtnFlip90: TSpeedButton;
    TPropertyBar: TPanel;
    BtnPolygon: TSpeedButton;
    Bevel5: TBevel;
    Bevel6: TBevel;
    Bevel1: TBevel;
    Bevel3: TBevel;
    TextBound: TShape;
    TTextBar: TPanel;
    Bevel7: TBevel;
    TextEdit: TEdit;
    TPropertyBarPage: TNotebook;
    ComboLineWidth: TComboBox;
    ComboLineStyle: TComboBox;
    FontName: TComboBox;
    FontSize: TComboBox;
    FontBold: TSpeedButton;
    FontItalic: TSpeedButton;
    FontUnderline: TSpeedButton;
    FontStrike: TSpeedButton;
    TextAngle: TSpinEdit;
    Font3D: TSpeedButton;
    bar1: TImage;
    bar2: TImage;
    ComboFillStyle: TComboBox;
    TextAngleBmp: TImage;
    Gauge: TGauge;
    mSaveExist: TMenuItem;
    mQuit: TMenuItem;
    N4: TMenuItem;
    ForeColor: TByGradientSlider;
    BackColor: TByGradientSlider;
    ForeColorLabel: TLabel;
    BackColorLabel: TLabel;
    procedure iFlipHor(Sender: TObject);
    procedure iFlipVer(Sender: TObject);
    procedure iFlip90(Sender: TObject);
    procedure iGrayScale(Sender: TObject);
    procedure iBalance(Sender: TObject);
    procedure iInverse(Sender: TObject);
    procedure iSmear(Sender: TObject);
    procedure iSmear2(Sender: TObject);
    procedure FilePrint(Sender: TObject);
    procedure ImageCopy(Sender: TObject);
    procedure ImagePaste(Sender: TObject);
    procedure SetDrawingTool(Sender: TObject);
    procedure IEImageMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure IEImageMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure IEImageMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ColorPickMouseDown(Sender: TObject; Button: TMouseButton;  Shift: TShiftState; X, Y: Integer);
    procedure ColorPickMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure mResizeClick(Sender: TObject);
    procedure SetLineWidth(Sender: TObject);
    procedure SetFillStyle(Sender: TObject);
    procedure SetLineStyle(Sender: TObject);
    procedure DrawLineWidth(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
    procedure DrawLineStyle(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
    procedure DrawFillStyle(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
    procedure mToolbarClick(Sender: TObject);
    procedure mPropertyBarClick(Sender: TObject);
    procedure DrawFont(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
    procedure DrawText(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TextBoundMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormResize(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure mSaveExistClick(Sender: TObject);
    procedure mQuitClick(Sender: TObject);
    procedure ForeColorChanged(Sender: TObject);
    procedure BackColorChanged(Sender: TObject);
  public
    DrawingTool: Integer;
    Drawing: Boolean;
    Origin, MovePt: TPoint;

{    CurveIndex : Integer;
    CurvePoint : Array [0..3] of TPoint; }

    PolyIndex : Integer;
    PolyPoint : TPolyPoint;

    FontWeight: Integer;
    TempBMP   : TBitmap;
    procedure DrawShape(TopLeft, BottomRight: TPoint; AMode: TPenMode);
    procedure DrawPolyLine;
  end;

var ImageEdit: TImageEdit;

implementation

uses IE_RGB, IE_Size;

{$R *.DFM}
{$ifdef Win32}
  {$R icursor.r32}
{$else}
  {$R icursor.res}
{$endif}

procedure TImageEdit.iFlip90(Sender: TObject);
var
  x,y,w,h:LongInt;
  I:TBitmap;
begin
  w:=IEImage.Width;
  h:=IEImage.Height;

  try
    I:=TBitmap.Create;
    I.Width:=h;
    I.Height:=w;
    dec(w);
    dec(h);

    for x:= 0 to w do
      for y:= 0 to h do
        I.Canvas.Pixels[y,x]:=IEImage.Canvas.Pixels[x,y];
    IEImage.Picture.Bitmap.Width := I.Width;
    IEImage.Picture.Bitmap.Height := I.Height;
    IEImage.Picture.Bitmap.Canvas.Draw(0,0,I);
  finally
    I.Free
  end;
end;

procedure TImageEdit.iFlipHor(Sender: TObject);
var
  x,y,w,h:LongInt;
  I:TBitmap;
begin
  w:=IEImage.Width;
  h:=IEImage.Height;

  try
    I:=TBitmap.Create;
    I.Width:=w;
    I.Height:=h;
    dec(w);
    dec(h);

    for x:= 0 to w do
      for y:= 0 to h do
        I.Canvas.Pixels[w-x,y]:=IEImage.Canvas.Pixels[x,y];
    IEImage.Canvas.Draw(0,0,I);
  finally
    I.Free
  end;
end;

procedure TImageEdit.iFlipVer(Sender: TObject);
var
  x,y,w,h:LongInt;
  I:TBitmap;
begin
  w:=IEImage.Width;
  h:=IEImage.Height;

  try
    I:=TBitmap.Create;
    I.Width:=w;
    I.Height:=h;
    dec(w);
    dec(h);

    for x:= 0 to w do
      for y:= 0 to h do
        I.Canvas.Pixels[x,h-y]:=IEImage.Canvas.Pixels[x,y];
    IEImage.Picture.Bitmap.Canvas.Draw(0,0,I);
  finally
    I.Free;
  end
end;


procedure TImageEdit.iBalance(Sender: TObject);
begin
  with TIERGBDlg.Create(nil) do
  try
    Test.Picture :=IEImage.Picture;
    Img.Height := Test.Picture.Bitmap.Height;
    Img.Width := Test.Picture.Bitmap.Width;
    Img.Canvas.Draw(0,0,Test.Picture.Bitmap);
    tmp.Width:=img.width;
    tmp.height:=img.height;

    if ShowModal = mrOK then
       IEImage.Picture.Bitmap:=Test.Picture.Bitmap;
  finally
    free;
  end;
end;


procedure TImageEdit.iInverse(Sender: TObject);
var
  C   : TRGBColor;
  x,y : LongInt;
  I   : TBitmap;

  function IConvert(const g: byte):Byte;
  begin
  if g >= 255
    then result:=0
    else if g<=0 then result:=255
    else result:=264 - g
  end;

begin
  Gauge.progress := 0;
  Gauge.visible := true;

  try
    I:=TBitmap.Create;
    I.Width:=IEImage.Width;
    I.Height:=IEImage.Height;
    I.Canvas.Draw(0,0,IEImage.Picture.Bitmap);

    for x:= 0 to IEImage.Width -1 do
    begin
      for y:= 0 to IEImage.Height-1 do
      begin
        c.color :=I.Canvas.Pixels[x,y];
        I.Canvas.Pixels[x,y]:= RGB( IConvert(C.r), IConvert(C.g), IConvert(C.b) )
      end;
      Gauge.Progress := x * 200 div I.Width;
    end;
    IEImage.Picture.Bitmap.Canvas.Draw(0,0,I);
  finally
    I.Free
  end;

  Gauge.visible := false;
end;

procedure TImageEdit.iGrayScale(Sender: TObject);
var
  x,y       :LongInt;
  I         :TBitmap;

  function gProcess(c: LongInt):TRGBColor;
  var average: integer;
  begin
    Result.color := c;
    average:= ( Result.r*30 + Result.g*59 + Result.b*11) div 100;
    Result.r := average;
    Result.g := average;
    Result.b := average;
  end;

begin
  Gauge.progress := 0;
  Gauge.visible := true;

  try
    I:=TBitmap.Create;
    I.Width:=IEImage.Width;
    I.Height:=IEImage.Height;
    I.Canvas.Draw(0,0,IEImage.Picture.Bitmap);

    for x:= 0 to IEImage.Width -1 do
    begin
      for y:= 0 to IEImage.Height-1 do
        I.Canvas.Pixels[x,y]:= gProcess(I.Canvas.Pixels[x,y]).color;

      Gauge.Progress := x * 200 div I.Width;
    end;
    IEImage.Picture.Bitmap.Canvas.Draw(0,0,I);
    Gauge.visible := false; 
  finally
    I.Free
  end
end;

procedure TImageEdit.iSmear(Sender: TObject);
{ ******************** }
{      -------------   }
{      | 1 | 1 | 1 |   }
{ 1    -------------   }
{ - *  | 1 | 1 | 1 |   }
{ 9    -------------   }
{      | 1 | 1 | 1 |   }
{      -------------   }
{ ******************** }
var
  Bmp : TBitmap;
  W,H : Integer;
  x,y : Integer;
  C1, C2, C3, C4, C5, C6, C7, C8, C9 : TColor;
begin
  try
    Bmp:=TBitmap.Create;
    Bmp.Width:=IEImage.Width;
    Bmp.Height:=IEImage.Height;
    W := Bmp.Width - 1;
    H := Bmp.Height -1;

    for x:= 0 to W do
      for y:= 0 to H do
      begin
        { row 1}
        C1 := IEImage.Picture.Bitmap.Canvas.Pixels[x-1,y-1];
        C2 := IEImage.Picture.Bitmap.Canvas.Pixels[ x, y-1];
        C3 := IEImage.Picture.Bitmap.Canvas.Pixels[x+1,y-1];

        { row 2}
        C4 := IEImage.Picture.Bitmap.Canvas.Pixels[x-1,y];
        C5 := IEImage.Picture.Bitmap.Canvas.Pixels[ x, y];
        C6 := IEImage.Picture.Bitmap.Canvas.Pixels[x+1,y];

        { row 3 }
        C7 := IEImage.Picture.Bitmap.Canvas.Pixels[x-1,y+1];
        C8 := IEImage.Picture.Bitmap.Canvas.Pixels[ x, y+1];
        C9 := IEImage.Picture.Bitmap.Canvas.Pixels[x+1,y+1];

        Bmp.Canvas.Pixels[x,y]:=
          RGB( ( GetRValue(C1)+GetRValue(C2)+GetRValue(C3)+
                 GetRValue(C4)+GetRValue(C5)+GetRValue(C6)+
                 GetRValue(C7)+GetRValue(C8)+GetRValue(C9) ) div 9,
               ( GetGValue(C1)+GetGValue(C2)+GetGValue(C3)+
                 GetGValue(C4)+GetGValue(C5)+GetGValue(C6)+
                 GetGValue(C7)+GetGValue(C8)+GetGValue(C9) ) div 9,
               ( GetBValue(C1)+GetBValue(C2)+GetBValue(C3)+
                 GetBValue(C4)+GetBValue(C5)+GetBValue(C6)+
                 GetBValue(C7)+GetBValue(C8)+GetBValue(C9) ) div 9 )
      end;
    IEImage.Picture.Bitmap.Canvas.Draw(0,0,Bmp);
  finally
    Bmp.Free
  end;

end;

procedure TImageEdit.iSmear2(Sender: TObject);
{ ******************** }
{      -------------   }
{      |   | 1 |   |   }
{ 1    -------------   }
{ - *  | 1 | 2 | 1 |   }
{ 6    -------------   }
{      |   | 1 |   |   }
{      -------------   }
{ ******************** }
var
  Bmp : TBitmap;
  W,H : Integer;
  x,y : Integer;
  C1, C2, C3, C4 : TColor;
  C: TColor;
begin
  try
    Bmp:=TBitmap.Create;
    Bmp.Width:=IEImage.Width;
    Bmp.Height:=IEImage.Height;
    W := Bmp.Width - 1;
    H := Bmp.Height -1;

    for x:= 0 to W do
      for y:= 0 to H do
      begin
        C := IEImage.Picture.Bitmap.Canvas.Pixels[x,y];
        C1 := IEImage.Picture.Bitmap.Canvas.Pixels[x-1,y];
        C2 := IEImage.Picture.Bitmap.Canvas.Pixels[x,y-1];
        C3 := IEImage.Picture.Bitmap.Canvas.Pixels[x+1,y];
        C4 := IEImage.Picture.Bitmap.Canvas.Pixels[x,y+1];
        Bmp.Canvas.Pixels[x,y]:=
          RGB( ( 2*GetRValue(C)+GetRValue(C1)+GetRValue(C2)+GetRValue(C3)+GetRValue(C4) ) div 6,
               ( 2*GetGValue(C)+GetGValue(C1)+GetGValue(C2)+GetGValue(C3)+GetGValue(C4) ) div 6,
               ( 2*GetBValue(C)+GetBValue(C1)+GetBValue(C2)+GetBValue(C3)+GetBValue(C4) ) div 6 );
      end;
    IEImage.Picture.Bitmap.Canvas.Draw(0,0,Bmp);
  finally
    Bmp.Free
  end;
end;

procedure TImageEdit.FilePrint(Sender: TObject);
begin
  with Printer do
  begin
    BeginDoc;
    Canvas.Draw(0, 0, IEImage.Picture.Graphic);
    EndDoc;
  end;
end;

procedure TImageEdit.ImageCopy(Sender: TObject);
begin
  Clipboard.Assign(IEImage.Picture);
end;

procedure TImageEdit.ImagePaste(Sender: TObject);
var Bitmap: TBitmap;
begin
  if Clipboard.HasFormat(CF_BITMAP) then
  begin
    Bitmap := TBitmap.Create;
    try
      Bitmap.Assign(Clipboard);
      if (IEImage.Width < Bitmap.Width) or (IEImage.Height < Bitmap.Height)
	then if WinProcs.MessageBox
              (Handle,'The image on the clipboard is larger then the picture,'#10#13'resize the picture before pasting?',
              '',MB_YESNO)=IDYES then
	  begin
	    if IEImage.Width < Bitmap.Width then IEImage.Picture.Bitmap.Width:=Bitmap.Width;
	    if IEImage.Height < Bitmap.Height then IEImage.Picture.Bitmap.Height:=Bitmap.Height
	  end;
      IEImage.Canvas.Draw(0, 0, Bitmap);
    finally
      Bitmap.Free;
    end;
  end;
end;

procedure TImageEdit.SetDrawingTool(Sender: TObject);
begin
{  CurveIndex := 0;}

  if (DrawingTool = dtPolygon) and (PolyIndex > 0) then
    DrawShape( Point(0,0), PolyPoint[0], pmCopy);
  PolyIndex := 0;

  Drawing := false;

  if DrawingTool = dtText then
  begin
    TextBound.Visible := false;
    TextEdit.Enabled := false;
    TextEdit.Color := clBtnFace;
  end;

  DrawingTool := (Sender as TComponent).Tag;

  if DrawingTool = dtText
    then
      begin
	TTextBar.Visible := true;
	TPropertyBarPage.PageIndex := 1
      end
    else
      begin
	TTextBar.Visible := false;
	TPropertyBarPage.PageIndex := 0
      end;

  case DrawingTool of
	dtFreeForm : IEImage.Cursor := crIEPenTool;
	dtText     : IEImage.Cursor := crIEEditTool;
	dtFloodFill: IEImage.Cursor := crIEFillTool;
        dtPick     : IEImage.Cursor := crIEDropTool;
	else IEImage.Cursor := crIEDefault;
   end;
end;

procedure TImageEdit.DrawPolyLine;
var
  i: integer;
  p: TPoint;
begin
  With IEImage.Canvas do
  begin
    MoveTo(Origin.x, Origin.y);
    for i := 1 to PolyIndex -1 do
    begin
      P := PolyPoint[i];
      LineTo(p.x, p.y)
    end;
    LineTo(MovePt.x, MovePt.y);
  end;
end;


procedure TImageEdit.DrawShape(TopLeft, BottomRight: TPoint; AMode: TPenMode);
begin
  with IEImage.Canvas do
  begin
    Pen.Mode := AMode;
    case DrawingTool of
      dtLine: begin
                MoveTo(TopLeft.X, TopLeft.Y);
                LineTo(BottomRight.X, BottomRight.Y);
              end;
      dtRectangle: Rectangle(TopLeft.X, TopLeft.Y, BottomRight.X, BottomRight.Y);
      dtEllipse: Ellipse(TopLeft.X, TopLeft.Y, BottomRight.X, BottomRight.Y);
      dtRoundRect: RoundRect(TopLeft.X, TopLeft.Y, BottomRight.X, BottomRight.Y,
         (TopLeft.X - BottomRight.X) div 2, (TopLeft.Y - BottomRight.Y) div 2);
      dtPolygon:
           begin
              if PolyIndex = 200 then
              begin
                PolyPoint[200] := BottomRight;
                PolyIndex := 200
              end;

              if (MovePt.x = PolyPoint[PolyIndex-1].x) and (MovePt.y = PolyPoint[PolyIndex-1].y)
                      and (PolyIndex > 1)
                      and (MovePt.x = Origin.x) and (MovePt.y = Origin.y) then
              begin
                PolyGon(PolyPoint);
                PolyIndex := 0;
                Drawing := false;
                OriginPanel.Caption := '';
              end else
                DrawPolyLine;
           end;
    end;
  end;
end;

procedure TImageEdit.IEImageMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var C, Tmp: longInt;
begin
  Case DrawingTool of
    dtPick:
	  begin
	    c := IEImage.Canvas.Pixels[x,y];
	    if ssLeft in Shift then
	      begin
		IEImage.Canvas.Pen.Color := c;
		ForeColor.GradientColor := c;
                ForeColor.ArrowPosition := 0;
	      end else
	      begin
		IEImage.Canvas.Brush.Color := c;
		BackColor.GradientColor := c;
                BackColor.ArrowPosition := 0;
	      end;
         end;
    dtFloodFill:
         if ssLeft in Shift
         then
           begin
             Tmp:= IEImage.Canvas.Brush.Color;
             IEImage.Canvas.Brush.Color := IEImage.Canvas.Pen.Color;
             IEImage.Canvas.FloodFill(x, y, IEImage.Canvas.Pixels[x,y], fsSurface);
             IEImage.Canvas.Brush.Color := Tmp;
           end
         else
           IEImage.Canvas.FloodFill(x, y, c, fsSurface);
{    dtCurve: if CurveIndex = 0 then
         begin
           Drawing := True;
           CurvePoint[0] := Point(x,y);
           CurveIndex := 1;
           MoveTo(X, Y);
           Origin := Point(X, Y);
           MovePt := Origin;
           OriginPanel.Caption := Format('(%d, %d)', [X, Y]);
         end;}
    dtPolygon:
       if PolyIndex = 0 then
         begin
           Drawing := True;
           Origin := Point(X, Y);
           for Tmp := 0 to cMaxPolyPoints do
             PolyPoint[Tmp] := Origin;
           PolyIndex := 1;

           MovePt := Origin;
           OriginPanel.Caption := Format('(%d, %d)', [X, Y]);
         end else
        begin
          PolyPoint[PolyIndex] := Point(x,y);
          inc(PolyIndex);
          DrawShape(Origin, Point(x, y), pmNotXor);
        end
    else With IEImage.Canvas do
         begin
           Drawing := True;
           MoveTo(X, Y);
           Origin := Point(X, Y);
           MovePt := Origin;
           OriginPanel.Caption := Format('(%d, %d)', [X, Y]);

           if DrawingTool = dtText then
           begin
             TextEdit.enabled := true;
             TextEdit.Color := clWindow;
           end;
         end;
   end
end;

procedure TImageEdit.IEImageMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  if Drawing then
    if DrawingTool = dtFreeForm then
      IEImage.Canvas.LineTo(x,y) else
        begin
          DrawShape(Origin, MovePt, pmNotXor);
          MovePt := Point(X, Y);
          DrawShape(Origin, MovePt, pmNotXor);
        end;
  CurrentPanel.Caption := Format('(%d, %d)', [X, Y]);
end;

procedure TImageEdit.IEImageMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Drawing then
    if DrawingTool = dtPolygon then else
    if DrawingTool = dtText then
      begin
        if TempBMP <> nil then TempBmp.Free;
        TempBmp := TBitmap.Create;
        TempBmp.Assign(IEImage.Picture.Bitmap);
        TextBound.Left := x;
        TextBound.Height := IEImage.Canvas.TextHeight('W');
        TextBound.Top := y;
        TextBound.Width := 10;
        TextBound.Visible := True;
        TextEdit.SetFocus;
      end else
      begin
        DrawShape(Origin, Point(X, Y), pmCopy);
        Drawing := False;
        OriginPanel.Caption := '';
      end;
end;

procedure TImageEdit.ColorPickMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  ColorPickMouseMove(Sender, Shift, x, y);
end;

procedure TImageEdit.ColorPickMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  if ssLeft in Shift then
    begin
      ForeColor.GradientColor := ColorPick.Canvas.Pixels[x,y];
      IEImage.Canvas.Pen.Color := ForeColor.ColorValue;
    end else
  if ssRight in Shift then
    begin
      BackColor.GradientColor := ColorPick.Canvas.Pixels[x,y];
      IEImage.Canvas.Brush.Color := BackColor.ColorValue;
    end;
  if DrawingTool = dtText then DrawText(nil);
end;

procedure TImageEdit.FormCreate(Sender: TObject);
var Ini: TIniFile;
begin
  try
    Ini := TIniFile.Create('ImageVue.ini');

    { Load stored setting }
    Top := Ini.ReadInteger('ImageEdit','Top',Top);
    Left := Ini.ReadInteger('ImageEdit','Left',Left);
    Width := Ini.ReadInteger('ImageEdit','Width',Width);
    Height := Ini.ReadInteger('ImageEdit','Height',Height);
    if Ini.ReadBool('ImageEdit','Maximized',False) then
       WindowState := wsMaximized;

    if not Ini.ReadBool('ImageEdit','Toolbar',True) then mToolbarClick(Self);
    if not Ini.ReadBool('ImageEdit','PropertyBar',True) then mPropertyBarClick(Self);

  finally
    Ini.Free;
  end;

  Screen.Cursors[crIeDefault] := LoadCursor(HInstance, 'CRIE_DEFAULT_TOOL');
  Screen.Cursors[crIePenTool] := LoadCursor(HInstance, 'CRIE_PEN_TOOL');
  Screen.Cursors[crIeFillTool] := LoadCursor(HInstance, 'CRIE_FILL_TOOL');
  Screen.Cursors[crIeEditTool] := LoadCursor(HInstance, 'CRIE_EDIT_TOOL');
  Screen.Cursors[crIeDropTool] := LoadCursor(HInstance, 'CRIE_DROPPER_TOOL');
  IEImage.Cursor := crIePenTool;

  DrawingTool := dtFreeForm;
  Drawing := false;

{  CurveIndex := 0;}

  PolyIndex := 0;
  ComboLineWidth.ItemIndex := 0;
  ComboLineStyle.ItemIndex := 0;
  ComboFillStyle.ItemIndex := 0;
  FontName.Items := Screen.Fonts;
  FontName.ItemIndex := FontName.Items.IndexOf('MS Sans Serif');
end;

procedure TImageEdit.mResizeClick(Sender: TObject);
var I: TBitmap;
begin
  with TIEResize.Create(nil) do
  try
    IWidth.Value := IEImage.Width;
    IHeight.Value := IEImage.Height;
    if ShowModal = mrOk then
      if not ScaleImage.Checked then
        begin
          IEImage.Picture.Bitmap.Width := IWidth.Value;
          IEImage.Picture.Bitmap.Height := IHeight.Value;
        end else
        try
          I := TBitmap.Create;
          I.Assign(IEImage.Picture.Bitmap);

          IEImage.Picture.Bitmap.Width := IWidth.Value;
          IEImage.Picture.Bitmap.Height := IHeight.Value;

          IEImage.Picture.Bitmap.Canvas.StretchDraw(
               Rect(0, 0, IWidth.Value, IHeight.Value), I);
        finally
          I.Free;
        end;
  finally
    free;
  end;
end;

procedure TImageEdit.SetLineWidth(Sender: TObject);
begin
  IEImage.Canvas.Pen.Width := ComboLineWidth.ItemIndex+1;
end;

procedure TImageEdit.SetFillStyle(Sender: TObject);
begin
  with IEImage.Canvas.Brush do
  case ComboFillStyle.ItemIndex of
    0: Style := bsSolid;
    1: Style := bsClear;
  end;
  if DrawingTool = dtText then DrawText(Sender);
end;

procedure TImageEdit.SetLineStyle(Sender: TObject);
begin
 with IEImage.Canvas.Pen do
 Case ComboLineStyle.ItemIndex of
    0: Style := psSolid;
    1: Style := psClear;
    2: Style := psDash;
    3: Style := psDot;
    4: Style := psDashDot;
    5: Style := psDashDotDot;
  end
end;

procedure TImageEdit.DrawLineWidth(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
var y: integer;
begin
  with ComboLineWidth.Canvas do
  begin
    FillRect(Rect);
    Pen.Width := Index+1;
    y := Rect.Top + (7 - Index);
    MoveTo(Rect.Left + 3 + Index,y);
    LineTo(Rect.Right - 3 - Index, y);
  end;
end;

procedure TImageEdit.DrawLineStyle(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  with ComboLineStyle.Canvas do
  begin
    FillRect(Rect);
    with Pen do
    case Index of
      0: Style := psSolid;
      1: Style := psClear;
      2: Style := psDash;
      3: Style := psDot;
      4: Style := psDashDot;
      5: Style := psDashDotDot;
    end;
    MoveTo(Rect.Left + 3, Rect.Top + 7);
    LineTo(Rect.Right - 3, Rect.Top + 7);
  end;
end;

procedure TImageEdit.DrawFillStyle(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  with ComboFillStyle.Canvas do
  begin
    FillRect(Rect);

    Brush.Color := clBlack;
    with Brush do
      case Index of
       0: Style := bsSolid;
       1: Style := bsClear;
      end;
    Rectangle(Rect.Left + 2, Rect.Top+2, Rect.Left + 15, Rect.Bottom-2);

    Brush.Style := bsClear;
    TextOut(Rect.Left + 19, Rect.Top, ComboFillStyle.Items[Index]);
  end;
end;

procedure TImageEdit.mToolbarClick(Sender: TObject);
begin
  mToolbar.Checked := not mToolBar.Checked;
  TToolBar.Visible := mToolBar.Checked;
  TToolBar.Top := 2;
end;

procedure TImageEdit.mPropertyBarClick(Sender: TObject);
begin
  mPropertyBar.Checked := not mPropertyBar.Checked;
  TPropertyBar.Visible := mPropertyBar.Checked;
  TPropertyBar.Top := 31;
end;

procedure TImageEdit.DrawFont(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  FontName.Canvas.FillRect(Rect);
  FontName.Canvas.Font.Name := FontName.Items[Index];
  FontName.Canvas.TextOut(Rect.Left + 2,
                Rect.Top + (16 - FontName.Canvas.TextHeight('X')) div 2,
                FontName.Canvas.Font.Name);
end;

procedure TImageEdit.DrawText(Sender: TObject);
var
  Font    : hFont;
  LogFont : TLogFont;
  F       : TFont;
begin
  if DrawingTool = dtText then
  begin
    FillChar(LogFont, SizeOf(LogFont), 0);

    With LogFont do
    Begin

     lfEscapement  := TextAngle.Value * 10;
     lfOrientation := lfEscapement;

     if FontBold.Down
       then lfWeight := 700
       else lfWeight := 0;
     if FontItalic.Down
       then lfItalic := 1
       else lfItalic := 0;
     if FontUnderline.Down
       then lfUnderline := 1
       else lfUnderline := 0;
     if FontStrike.Down
       then lfStrikeOut := 1
       else lfStrikeOut := 0;

     lfOutPrecision := OUT_TT_PRECIS;
     lfQuality	    := PROOF_QUALITY; { Use the best quality }

     StrPCopy(lfFaceName, FontName.Items[FontName.ItemIndex]);
    End;

    Font := CreateFontIndirect(LogFont);
    F := TFont.Create;
    F.Handle := Font;

    if FontSize.ItemIndex > -1 then
      F.Size := FontSize.ItemIndex * 2 + 6;

    IEImage.Canvas.Font := F;

    IEImage.Canvas.Draw(0,0, TempBmp);

    if Font3D.Down then
    begin
      IEImage.Canvas.Font.Color := clBtnShadow;
      IEImage.Canvas.TextOut(Origin.x+1, Origin.y+1, TextEdit.Text);
      IEImage.Canvas.Font.Color := IEImage.Canvas.Pen.Color;
      IEImage.Canvas.TextOut(Origin.x, Origin.y, TextEdit.Text);
    end else
    begin
      IEImage.Canvas.Font.Color := IEImage.Canvas.Pen.Color;
      IEImage.Canvas.TextOut(Origin.x, Origin.y, TextEdit.Text);
    end;

    if TextEdit.Text <> ''
      then TextBound.Width := IEImage.Canvas.TextWidth(TextEdit.Text)
      else TextBound.Width := 10;
    TextBound.Height := IEImage.Canvas.TextHeight(TextEdit.Text);

    F. Free;
    DeleteObject(Font);
  end;
end;

procedure TImageEdit.FormDestroy(Sender: TObject);
begin
  if TempBmp <> nil then TempBmp.Free;
end;

procedure TImageEdit.TextBoundMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SendMessage(TextEdit.Handle,WM_LBUTTONDOWN,MK_RBUTTON,MakeLong(x,y));
end;

procedure TImageEdit.FormResize(Sender: TObject);
begin
  TextEdit.Width := ClientWidth - (50);
end;

procedure TImageEdit.FormKeyPress(Sender: TObject; var Key: Char);
var p: TPolyPoint;
begin
  if (ord(Key) = VK_ESCAPE) and Drawing and (DrawingTool = dtPolygon) then
  with IEImage.Canvas do
  begin
    pen.mode := pmCopy;
    PolyGon(PolyPoint);
    PolyIndex := 0;
    Drawing := false;
    Key := ' ';
    OriginPanel.Caption := '';
  end;
end;

procedure TImageEdit.FormClose(Sender: TObject; var Action: TCloseAction);
var ini : TIniFile;
begin
  try
    { Save setting }
    ini := TIniFile.Create('ImageVue.ini');
    Ini.WriteBool('ImageEdit','Maiximized', WindowState = wsMaximized);
    Ini.WriteBool('ImageEdit','Toolbar', TToolbar.Visible);
    Ini.WriteBool('ImageEdit','PropertyBar', TPropertyBar.Visible);
    WindowState := wsNormal;
    Ini.WriteInteger('ImageEdit','Top',Top);
    Ini.WriteInteger('ImageEdit','Left',Left);
    Ini.WriteInteger('ImageEdit','Width',Width);
    Ini.WriteInteger('ImageEdit','Height',Height);
  finally
    ini.free;
  end;
end;

procedure TImageEdit.mSaveExistClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TImageEdit.mQuitClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TImageEdit.ForeColorChanged(Sender: TObject);
begin
  IEImage.Canvas.Pen.Color := ForeColor.ColorValue;
end;

procedure TImageEdit.BackColorChanged(Sender: TObject);
begin
  IEImage.Canvas.Brush.Color := BackColor.ColorValue;
end;

end.
