unit Ie_rgb;

interface

uses
  {$ifdef Win32} Windows, {$else} WinProcs, WinTypes, {$endif}
  SysUtils, Messages, Classes, Graphics, Controls, Forms, Dialogs, ExtCtrls,
  StdCtrls, Gauges, Graphx;

type
  TIERGBDlg = class(TForm)
    l1: TLabel;
    l2: TLabel;
    l3: TLabel;
    btnOK: TButton;
    btnCancel: TButton;
    TestPanel: TPanel;
    r: TLabel;
    g: TLabel;
    b: TLabel;
    ScrollBox1: TScrollBox;
    Test: TImage;
    Gauge: TGauge;
    Red: TByGradientSlider;
    Green: TByGradientSlider;
    Blue: TByGradientSlider;
    procedure RedScroll(Sender: TObject);
    procedure GreenScroll(Sender: TObject);
    procedure BlueScroll(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Redraw(Sender: TObject);
  public
    Img,Tmp : TBitmap;
  end;

var IERGBDlg: TIERGBDlg;

implementation

{$R *.DFM}

procedure TIERGBDlg.ReDraw(Sender: TObject);
var
  x,y     : Integer;
  rc,gc,bc: Real;
  C       : TRGBColor;
  ActiveC : TWinControl;
begin
  Gauge.Visible := true;

  ActiveC := ActiveControl;
  Enabled := false;

  rc:=1 + (Red.ArrowPosition/100);
  gc:=1 + (Green.ArrowPosition/100);
  bc:=1 + (Blue.ArrowPosition/100);
  for x:=0 to Img.Width-1 do
  begin
    for y:= 0 to Img.Height-1 do
      begin
        c.color:=Img.Canvas.Pixels[x,y];
        tmp.Canvas.pixels[x,y]:= RGB( round(c.r*rc), round(c.g*gc), round(c.b*bc));
      end;
    Gauge.Progress := x * 100 div Img.Width;
  end;
  Test.Picture.Bitmap.Canvas.Draw(0,0,Tmp);

  Enabled := true;
  ActiveControl := ActiveC;

  Gauge.Visible := false;
end;

procedure TIERGBDlg.RedScroll(Sender: TObject);
begin
  r.caption:=inttoStr(Red.ArrowPosition);
end;

procedure TIERGBDlg.GreenScroll(Sender: TObject);
begin
  g.caption:=inttoStr(Green.ArrowPosition);
end;

procedure TIERGBDlg.BlueScroll(Sender: TObject);
begin
  b.caption:=inttoStr(Blue.ArrowPosition);
end;

procedure TIERGBDlg.FormCreate(Sender: TObject);
begin
  Test.Picture.Bitmap:=TBitmap.Create;
  tmp:=TBitMap.Create;
  Img:=TBitMap.Create;
end;

end.
