{*****************************************************************}
{*                                                               *}
{*  Dancer's ImageVue v1.0.6					 *}
{*    A Bitmap property editor by African Dancer                 *}
{*                                                               *}
{*  African Dancer: dancer@tieus.com                             *}
{*  Mar. 08, 1998, Vancouver					 *}
{*                                                               *}
{*****************************************************************}

unit Iv_main;

interface

uses
  {$ifdef Win32} Windows, {$else} WinProcs, WinTypes, {$endif} Classes,
  Graphics, Forms, Controls, StdCtrls, ExtCtrls, FileCtrl, Buttons, Spin,
  Tabs, TabNotBk, Menus, Dialogs, IniFiles, Messages;

type
  TImageForm = class(TForm)
    BtnOk: TBitBtn;
    BtnCancel: TBitBtn;
    DirList: TDirectoryListBox;
    FileList: TFileListBox;
    DriveTabSet: TTabSet;
    Bevel1: TBevel;
    ViewTab: TTabbedNotebook;
    Bevel2: TBevel;
    Image: TImage;
    GlyphTestBtn1: TBitBtn;
    GlyphTestBtn2: TBitBtn;
    GlyphTestSpeed1: TSpeedButton;
    GlyphTestSpeed2: TSpeedButton;
    GlyphLabel: TLabel;
    GlyphNo: TSpinEdit;
    Bevel3: TBevel;
    GoLeft: TSpeedButton;
    GoRight: TSpeedButton;
    TemplateTab: TTabSet;
    TemplateNote: TNotebook;
    SaveDlg: TSaveDialog;
    DriveCombo: TDriveComboBox;
    Bevel4: TBevel;
    Bevel5: TBevel;
    BtnSave: TSpeedButton;
    BtnClear: TSpeedButton;
    BtnEdit: TSpeedButton;
    BarLocation: TPanel;
    BMCombo: TComboBox;
    BMButton: TSpeedButton;
    BMLocation: TLabel;
    Logo: TPaintBox;
    LogoTime: TTimer;
    LogoBevel: TBevel;
    TempOffice: TScrollBox;
    tw01: TSpeedButton;
    tw02: TSpeedButton;
    tw03: TSpeedButton;
    tw04: TSpeedButton;
    tw09: TSpeedButton;
    tw10: TSpeedButton;
    tw17: TSpeedButton;
    tw23: TSpeedButton;
    tw24: TSpeedButton;
    tw25: TSpeedButton;
    tw26: TSpeedButton;
    tw29: TSpeedButton;
    tw32: TSpeedButton;
    tw33: TSpeedButton;
    tw36: TSpeedButton;
    tw37: TSpeedButton;
    tw38: TSpeedButton;
    tw39: TSpeedButton;
    tw40: TSpeedButton;
    tw46: TSpeedButton;
    tw47: TSpeedButton;
    tw48: TSpeedButton;
    tw49: TSpeedButton;
    tw50: TSpeedButton;
    tw51: TSpeedButton;
    tw53: TSpeedButton;
    tw54: TSpeedButton;
    tw55: TSpeedButton;
    tw56: TSpeedButton;
    tw61: TSpeedButton;
    tw62: TSpeedButton;
    tw64: TSpeedButton;
    tw65: TSpeedButton;
    tw66: TSpeedButton;
    SpeedButton6: TSpeedButton;
    tw68: TSpeedButton;
    tw67: TSpeedButton;
    tw69: TSpeedButton;
    SpeedButton5: TSpeedButton;
    tw70: TSpeedButton;
    tw75: TSpeedButton;
    tw86: TSpeedButton;
    tw87: TSpeedButton;
    tw88: TSpeedButton;
    tw89: TSpeedButton;
    tw95: TSpeedButton;
    tw96: TSpeedButton;
    tw97: TSpeedButton;
    tw98: TSpeedButton;
    tw99: TSpeedButton;
    tw100: TSpeedButton;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton7: TSpeedButton;
    TempInternet: TScrollBox;
    ti01: TSpeedButton;
    ti02: TSpeedButton;
    ti03: TSpeedButton;
    ti04: TSpeedButton;
    ti05: TSpeedButton;
    ti06: TSpeedButton;
    ti07: TSpeedButton;
    ti08: TSpeedButton;
    ti09: TSpeedButton;
    ti10: TSpeedButton;
    TempCorel: TScrollBox;
    cr5: TSpeedButton;
    cr10: TSpeedButton;
    cr15: TSpeedButton;
    cr20: TSpeedButton;
    cr21: TSpeedButton;
    cr22: TSpeedButton;
    cr31: TSpeedButton;
    cr32: TSpeedButton;
    cr33: TSpeedButton;
    cr100: TSpeedButton;
    TempMore: TScrollBox;
    tm01: TSpeedButton;
    tm02: TSpeedButton;
    tm03: TSpeedButton;
    tm05: TSpeedButton;
    tm06: TSpeedButton;
    tm07: TSpeedButton;
    tm08: TSpeedButton;
    tm41: TSpeedButton;
    tm51: TSpeedButton;
    tm61: TSpeedButton;
    AboutMe: TMemo;
    AboutVersion: TLabel;
    AboutAddress: TLabel;
    BMImage: TImage;
    BMHistory: TComboBox;
    BMAddress: TEdit;
    BMHiPopup: TPopupMenu;
    mClearHistory: TMenuItem;
    Label1: TLabel;
    IVIcon: TImage;
    StretchCheck: TCheckBox;
    BtnView: TSpeedButton;
    Bar1: TImage;
    Bar2: TImage;
    procedure DriveTabSetClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FileListClick(Sender: TObject);
    procedure GlyphNoChange(Sender: TObject);
    procedure BtnViewClick(Sender: TObject);
    procedure DoStretch(Sender: TObject);
    procedure LoadButton(Sender: TObject);
    procedure SetGlyph;
    procedure TemplateTabClick(Sender: TObject);
    procedure GoRightClick(Sender: TObject);
    procedure GoLeftClick(Sender: TObject);
    procedure BtnSaveClick(Sender: TObject);
    procedure BtnClearClick(Sender: TObject);
    procedure BtnEditClick(Sender: TObject);
    procedure BMButtonClick(Sender: TObject);
    procedure BMAddDir(Sender: TObject);
    procedure BMSelectFolder(Sender: TObject);
    procedure BMDrawItem(Control: TWinControl; Index: Integer; R: TRect; State: TOwnerDrawState);
    procedure LogoTimeTimer(Sender: TObject);
    procedure BMMeasureItem(Control: TWinControl; Index: Integer; var Height: Integer);
    procedure DirListChange(Sender: TObject);
    procedure BMAddressKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure BMHistoryChange(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
    procedure ClearHistory(Sender: TObject);
    procedure AutoCompleteHistory(Sender: TObject);
  public
    BkModified: Boolean;  { Specify if Bookmarks have been updated }
    HiModified: Boolean;  { Specify if History has been updated    }
    LogoBmp: TBitmap;     { Animated logo }
    LogoIdx: integer;     { Frame index of the logo }
    BMBmp : TBitmap;      { Bookmark icon }
    LastKey: Word;        { Identify the last key entered to BMAddress }
    Procedure AddHistory;
  end;

const IniFile = 'ImageVue.ini';
               
var
  ImageForm: TImageForm;

implementation

uses SysUtils, Iv_Full, Iv_BkMrk, Ie_Main;

{$R *.DFM}

{$ifdef Win32}
  {$R IV_Main.r32}
{$else}
 {$R IV_Main.RES}
{$endif}

procedure TImageForm.AddHistory;
begin
  if BMHistory.Items.IndexOf(DirList.Directory) = -1 then
  begin
    BMHistory.Items.Insert(0,DirList.Directory);
    if BMHistory.Items.Count = 21 then BMHistory.Items.Delete(20);
    HiModified := True
  end;
end;

procedure TImageForm.DriveTabSetClick(Sender: TObject);
begin
  { Set the current drive }
  DirList.Drive:=DriveTabSet.Tabs[DriveTabSet.TabIndex][1]
end;

procedure TImageForm.FormCreate(Sender: TObject);
var
  Ini   : TIniFile;
  Index : Integer;
  Str : String;
begin
  { Add a list of drives to DriveTabSet }
  DriveTabSet.Tabs := DriveCombo.Items;
  DriveTabSet.TabIndex := DriveCombo.ItemIndex;
  DriveCombo.Free;

  { When the first items is added, DriveTabSet will call OnClick event handler.
    To avoid the annoying error message, 'Drive not ready' (if drive A is not
    ready), set DriveTabSetClick as DriveTabSet's OnClick event handler after
    items are added and the current drive is set. }
  DriveTabSet.OnClick := DriveTabSetClick;

  { Load the animated logo from resource }
  LogoBmp := TBitmap.Create;
  LogoBmp.Handle := LoadBitmap(HInstance,'LOGOBMP');

  { Start animation }
  Logo.Canvas.CopyMode := cmSrcCopy;
  LogoIdx := 0;
  LogoTime.enabled := true;

  BMBmp := TBitmap.Create;
  BMBmp.Handle := LoadBitmap(HInstance,'BMBMP');

  { Load the bookmarks }
  BMCombo.Items.Add('-');
  try
    Ini:=TIniFile.Create(IniFile);

    DirList.Directory := Ini.ReadString('ImageVue', 'Directory',DirList.Directory);
    Index := Ini.ReadInteger('ImageVue', 'ViewTab',0);
    if (Index >=0) and (Index < 3) then ViewTab.PageIndex := Index;

    Index := 0;
    for Index := 0 to 19 do
    begin
      Str := Ini.ReadString('Histories', 'His' + IntToStr(Index), '');
      if Str <> '' then BMHistory.Items.Add(Str) else break
    end;
    BMHistory.OnChange := BMHistoryChange;

    for Index := 0 to 24 do
    begin
      Str := Ini.ReadString('Bookmarks', 'Folder' + IntToStr(Index), '');
      if Str <> '' then BMCombo.Items.Add(Str) else break
    end;

  finally
    Ini.Free;
  end;

  BMCombo.Canvas.Brush.Color := clMenu;
  BMCombo.DropDownCount := Index + 4;
  BMAddress.Text := DirList.Directory;
end;

procedure TImageForm.FormDestroy(Sender: TObject);
var
  Ini: TIniFile;
  Index: Integer;
begin
  LogoBmp.Free;
  BMBmp.Free;
  try
    Ini:=TIniFile.Create(IniFile);

    Ini.WriteString('ImageVue', 'Directory', DirList.Directory);
    Ini.WriteInteger('ImageVue', 'ViewTab', ViewTab.PageIndex);

    if HiModified then
    begin
      Ini.EraseSection('Histories');
      For Index := 0 to (BMHistory.Items.Count -1) do
        Ini.WriteString('Histories', 'His' + IntToStr(Index),
                         BMHistory.Items[Index]);
    end;

    if BkModified then
    begin
      Ini.EraseSection('Bookmarks');
      For Index := 3 to (BMCombo.Items.Count -1) do
        Ini.WriteString('Bookmarks', 'Folder' + IntToStr(Index-3),
                         BMCombo.Items[Index]);
    end;
  finally
    Ini.Free;
  end;
end;

procedure TImageForm.FileListClick(Sender: TObject);
var
  FileExt: string[4];
  TempIcon: TIcon;
  TempWMF: TMetaFile;
begin
  if not Image.Visible then
    Image.Visible := true;

  if FileList.ItemIndex < 0
    then BtnOk.Enabled := False
    else begin
      try
        Screen.Cursor := crHourGlass;
        BtnOk.Enabled := True;
        try
          FileExt := UpperCase(ExtractFileExt(FileList.Filename));
          if (FileExt = '.BMP') then
            Image.Picture.LoadFromFile(FileList.Filename) else
          if FileExt = '.ICO' then
            try
              { Since an icon has transparent background, when painting it,   }
              { Windows will not completely clear the previous image. We have }
              { to make sure the first image is erased completely. }
              { Thank Heiko (http://privat.schlund.de/heikowebers) for pointing this out. }
              Image.Picture.Bitmap.Canvas.Brush.Color := clBtnFace;
              Image.Picture.Bitmap.Canvas.FillRect
                    (Rect(0, 0, Image.Picture.Bitmap.Width,
                    Image.Picture.Bitmap.Height));

              { Convert icon into bitmap graphic }
              TempIcon := TIcon.Create;
              TempIcon.LoadFromFile(FileList.FileName);
              Image.Picture.Bitmap.Width := TempIcon.Width;
              Image.Picture.Bitmap.Height := TempIcon.Height;
              Image.Picture.Bitmap.Canvas.Draw(0,0,TempIcon);
            finally
              TempIcon.Free;
            end else
          if FileExt = '.WMF' then
            try
              { Convert metafile graphic into bitmap graphic }
              TempWMF := TMetaFile.Create;
              TempWMF.LoadFromFile(FileList.FileName);
              Image.Picture.Bitmap.Width := TempWMF.Width;
              Image.Picture.Bitmap.Height := TempWMF.Height;
              Image.Picture.Bitmap.Canvas.Draw(0,0,TempWMF);
            finally
              TempWMF.Free;
            end;

          { Set caption to "width x height" }
          Caption := 'ImageVue - ' + Format(' %d x %d',
		  [Image.Picture.Bitmap.Width, Image.Picture.Bitmap.Height]) +
		  ' picture';
          SetGlyph; { Set test buttons' glyph images }
        except
          Image.Picture.Free
        end
      finally
        Screen.Cursor := crDefault;
      end
    end
end;

procedure TImageForm.SetGlyph;
begin
   GlyphTestSpeed1.Glyph := Image.Picture.Bitmap;
   GlyphTestSpeed2.Glyph := Image.Picture.Bitmap;
   GlyphNo.Value := GlyphTestSpeed1.NumGlyphs;
   GlyphTestBtn1.Glyph := Image.Picture.Bitmap;
   GlyphTestBtn2.Glyph := Image.Picture.Bitmap;

  if not BtnClear.Enabled then
  begin
    BtnClear.Enabled := true;
    BtnSave.Enabled := true;
    BtnEdit.Enabled := true;
  end;
end;

procedure TImageForm.BtnViewClick(Sender: TObject);
begin
   with TIvFullScreen.Create(nil) do    { Create a full-screen-view form }
    try
      Image1.Picture := Image.Picture;  { Set the full-screen image }
      ShowModal;                        { Make the form visible }
    finally
      Free                              { Remember to free the memory resource }
    end
end;

procedure TImageForm.GlyphNoChange(Sender: TObject);
begin
  { Change number of glyphs in test speedbuttons }
  GlyphTestSpeed1.NumGlyphs := GlyphNo.Value;
  GlyphTestSpeed2.NumGlyphs := GlyphNo.Value;
end;

procedure TImageForm.DoStretch(Sender: TObject);
begin
  if StretchCheck.Checked and not Image.Picture.Bitmap.Empty then
  begin
    with Image.Picture.Bitmap do
    if Width > Height
      then Image.Height := Trunc(Height / Width * 173)
      else Image.Width := Trunc(Width / Height * 173);
    Image.Stretch := true;
  end else
  begin
    Image.Stretch := false;
    Image.Height := 173;
    Image.Width := 173;
  end;
end;

procedure TImageForm.LoadButton(Sender: TObject);
begin
  Image.Visible := true;

  Caption := 'ImageVue - ' + Format(' %d x %d',
        [Image.Picture.Bitmap.Width, Image.Picture.Bitmap.Height])
	+ ' picture';

  Image.Picture.Bitmap := (Sender as TSpeedButton).Glyph;
  DoStretch(Sender);
  SetGlyph; { Reset test buttons' images }
end;

procedure TImageForm.TemplateTabClick(Sender: TObject);
begin
  if TemplateNote.PageIndex <> TemplateTab.TabIndex then
  begin
    TemplateNote.PageIndex := TemplateTab.TabIndex;
    GoRight.enabled := true;
    GoLeft.enabled := true;
    Case TemplateTab.TabIndex of
    0: TempOffice.HorzScrollBar.Position:=0;
    1: TempInternet.HorzScrollBar.Position:=0;
    2: TempCorel.HorzScrollBar.Position:=0;
    3: TempMore.HorzScrollBar.Position:=0;
    else
      begin
        GoRight.enabled := false;
        GoLeft.enabled := false;
      end;
    end;
  end;
end;

procedure TImageForm.GoRightClick(Sender: TObject);
begin
  Case TemplateTab.TabIndex of
    0: with TempOffice.HorzScrollBar do
         if Position < Range
            then Position := Position + 164
            else Position := Range;
    1: with TempInternet.HorzScrollBar do
         if Position < Range
            then Position := Position + 164
            else Position := Range;
    2: with TempCorel.HorzScrollBar do
         if Position < Range
            then Position := Position + 164
            else Position := Range;
    3: with TempMore.HorzScrollBar do
         if Position < Range
            then Position := Position + 164
            else Position := Range;
  end { case..of }
end;

procedure TImageForm.GoLeftClick(Sender: TObject);
begin
  Case TemplateTab.TabIndex of
    0: with TempOffice.HorzScrollBar do
         if Position > 0
           then Position := Position - 164
           else Position := 0;
    1: with TempInternet.HorzScrollBar do
         if Position > 0
           then Position := Position - 164
           else Position := 0;
    2: with TempCorel.HorzScrollBar do
         if Position > 0
           then Position := Position - 164
           else Position := 0;
    3: with TempMore.HorzScrollBar do
         if Position > 0
            then Position := Position - 157
            else Position := 0;
  end { case...of }
end;

procedure TImageForm.BtnSaveClick(Sender: TObject);
begin
  if Image.Visible and not Image.Picture.Bitmap.Empty then
    if SaveDlg.Execute then
      Image.Picture.SaveToFile(SaveDlg.filename);
end;

procedure TImageForm.BtnClearClick(Sender: TObject);
begin
  Image.Visible := false;

   GlyphTestSpeed1.Glyph.Assign(nil);
   GlyphTestSpeed2.Glyph := GlyphTestSpeed1.Glyph;
   GlyphTestBtn1.Glyph := GlyphTestSpeed1.Glyph;
   GlyphTestBtn2.Glyph := GlyphTestSpeed1.Glyph;

  Caption := 'ImageVue';
  BtnSave.Enabled := false;
  BtnClear.Enabled := false;
  BtnEdit.Enabled := false;
end;

procedure TImageForm.BtnEditClick(Sender: TObject);
begin

  if Image.Visible and not Image.Picture.Bitmap.Empty then
  begin
    LogoTime.Enabled := false;
    Visible := False;

    with TImageEdit.Create(nil) do
    try
      IEImage.Picture.Assign(Image.Picture);
      if ShowModal = mrOk then
      begin
	Image.Picture.Assign(IEImage.Picture);
	FileList.ItemIndex := 0;
        SetGlyph;
	ImageForm.Caption := Caption + ' (Modified)';
      end;

    finally
      free;
    end;

    Visible := true;
    LogoTime.Enabled := true;
  end;
end;

procedure TImageForm.BMButtonClick(Sender: TObject);
begin
  SendMessage(BMCombo.Handle,WM_LBUTTONDOWN,MK_LBUTTON,0);
end;

procedure TImageForm.BMAddDir(Sender: TObject);
begin
  If (BMCombo.Items.IndexOf(DirList.Directory) = -1) and
     (BMCombo.Items.Count < 27) then
  begin
    BMCombo.Items.Add(DirList.Directory);
    BkModified := true;
  end;
end;

procedure TImageForm.BMSelectFolder(Sender: TObject);
var
  i: integer;
begin
  case BMCombo.ItemIndex of
    0 : BMAddDir(Sender);                 { "Add to Bookmark" }
    1 :
      begin
        LogoTime.Enabled := false;
        Visible := false;
        with TBkMarkForm.Create(nil) do   { "Edit Bookmarks" }
        try
	  Mark := TBitmap.Create;
	  Mark.Assign(BMBmp);
	  List.Items.AddStrings(BMCombo.Items);
	  List.Items.Delete(2);
	  List.Items.Delete(1);
	  List.Items.Delete(0);
	  if List.Items.Count > 0 then
	  begin
	    List.ItemIndex := 0;
{            BtnMoveUp.enabled :=false; }
	    if List.Items.Count > 1 then
	      BtnMoveDown.enabled := true;
	    BtnDelete.enabled := true;
	  end;
	  If (ShowModal = mrOk) and Modified then
	  begin
	    BMCombo.Items.Clear;
	    BMCombo.Items.Add('Add to bookmark');
	    BMCombo.Items.Add('Edit bookmarks');
	    BMCombo.Items.Add('-');
	    BMCombo.Items.AddStrings(List.Items);
	    BkModified := true;
	  end;
	finally
	  Free
	end;
	Visible := true;
	LogoTime.Enabled := true;
      end;
    else if BMCombo.Items[BMCombo.ItemIndex] <> '-' then
        begin
          DirList.Directory := BMCombo.Items[BMCombo.ItemIndex];

          if DirList.Directory <> BMCombo.Items[BMCombo.ItemIndex] then
          begin
            BMCombo.Items.Delete(BMCombo.ItemIndex);
            BKModified := true;
          end;

          for i := 0 to DriveTabSet.Tabs.Count - 1 do
            if DriveTabSet.Tabs[i][1] = DirList.Drive
              then break;
          DriveTabSet.TabIndex := i;
        end;
  end; { case...of }
  BMCombo.ItemIndex := -1;
end;

procedure TImageForm.BMDrawItem(Control: TWinControl; Index: Integer; R: TRect; State: TOwnerDrawState);
var
  y : integer;
  txt: string;
begin
  txt := BMCombo.Items[index];
  with BMCombo.Canvas do
  begin
    if txt = '-' then
      begin
        FillRect(R);
        Pen.Color := clBtnShadow;    MoveTo(2, R.top+7); LineTo(R.Right-2,R.Top+7);
        Pen.Color := clBtnHighLight; MoveTo(2, R.top+8); LineTo(R.Right-2,R.Top+8);
      end
    else
      begin
{        if (odFocused in State) or (odSelected in State) then
        begin
          Brush.Color := clHighLight;
          Brush.Style := bsClear;
          Pen.Color := clHighLightText;
        end else
          Pen.Color := clMenuText;}
        FillRect(R);
        if Index > 2
          then BrushCopy( Rect(2, R.Top, 15, R.Bottom), BMBmp,
                         Rect(0,0,12,12), Brush.Color);

        TextOut(16,R.Top,txt);
      end;
  end;
end;

procedure TImageForm.BMMeasureItem(Control: TWinControl; Index: Integer; var Height: Integer);
begin
  if BMCombo.Items[index] = '-' then Height := 4 else Height := 18;
end;

procedure TImageForm.LogoTimeTimer(Sender: TObject);
var x: integer;
begin
  x := LogoIdx * 32;
  if LogoIdx = 31 then LogoIdx := 0;
  with Logo.Canvas do
      CopyRect(Rect(0,0,31,31),LogoBmp.Canvas,Rect(x,0,x+31,31));
  Inc(LogoIdx);
end;

procedure TImageForm.DirListChange(Sender: TObject);
begin
  BMAddress.Text := DirList.Directory;
end;

procedure TImageForm.BMAddressKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
{ Automatically complete the directory: }
begin
  With BMAddress do
    if Key = VK_RETURN then
    begin
      DirList.Directory := Text;
      AddHistory;
      Key := 0
    end else
    if (Key = VK_DOWN) and (ssCtrl in Shift) then
    begin
      SendMessage(BMHistory.Handle,WM_LBUTTONDOWN,MK_LBUTTON,0);
      Key := 0
    end;
  LastKey := Key;
end;

procedure TImageForm.BMHistoryChange(Sender: TObject);
var i: integer;
begin
  if BMHistory.ItemIndex > -1 then
      DirList.Directory := BMHistory.Items[BMHistory.ItemIndex];

  for i := 0 to DriveTabSet.Tabs.Count - 1 do
    if DriveTabSet.Tabs[i][1] = DirList.Drive
       then break;
  DriveTabSet.TabIndex := i;
end;

procedure TImageForm.BtnOkClick(Sender: TObject);
var i: integer;
begin
  if Image.Visible then
    AddHistory;
  ModalResult := mrOk;
end;

procedure TImageForm.ClearHistory(Sender: TObject);
begin
  BMHistory.Items.Clear;
  HiModified := True;
end;

procedure TImageForm.AutoCompleteHistory(Sender: TObject);
var
  SearchRec:TSearchRec;
  Tmp : String;
  L,I: Word;
  DosErr: Integer;
begin
  with BMAddress do
  if (Text <> '') and (LastKey <> VK_Back) and (LastKey <> 0) then
  begin
    Tmp := BMAddress.Text;
    L := Length(Tmp);

    if (L = 1) or ( (L = 2) and (Tmp[2] = ':') ) then
    begin
      if L=1
	then Tmp := Tmp + ':\'
	else Tmp := Tmp + '\';
      if GetDriveType( Ord(UpCase(Tmp[1]))-64 ) <> 0
	then Text:=Tmp;
      SelStart:=L;
      SelLength:=3-L;
    end else
    if Tmp[L] <> '\' then
    begin
      if (Tmp[2]=':') and ( Tmp[3] = '\')
	then DosErr := FindFirst(Tmp + '*.*', faDirectory, SearchRec)
	else DosErr := FindFirst(DirList.Directory + '\' + Tmp + '*.*', faDirectory, SearchRec);

      while DosErr = 0 do
	if SearchRec.Attr and faDirectory = faDirectory
	  then break
	  else DosErr := FindNext(SearchRec);

      if DosErr = 0 then
      begin
	for I := L-1 downto 0 do
	  if Tmp[I] = '\' then break;

	Text:= Tmp + Copy(LowerCase(Searchrec.Name), L - I + 1, 12);
	SelStart := L;
	SelLength := Length(Text) - L;
      end;
      FindClose(SearchRec);
    end;
  end;
  LastKey := 0;
end;

end.
