unit Iv_reg;
interface

uses DsgnIntf;

Type
  TPEImageView = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

{ IconVue is removed due to its serious bugs }
{  TPEIconView = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end; }

  procedure Register;

implementation

uses SysUtils, Controls, Graphics, TypInfo, Iv_Main;


  function TPEImageView.GetAttributes: TPropertyAttributes;
  begin
    Result := [paDialog]
  end {GetAttributes};


  procedure TPEImageView.Edit;
  begin
    inherited Edit;

    with TImageForm.Create(nil) do
      try
        { Paste the current bitmap (or glyph) to the preview image }
        Image.Picture := TPicture(GetOrdValue);
        Caption := 'ImageVue - ' + Format(' %d x %d',
		[Image.Picture.Bitmap.Width, Image.Picture.Bitmap.Height]) +
		' picture';

        { then set the test TBitBtns and TSpeedButton's glyphs }
        SetGlyph;

        if Image.Picture.Bitmap = nil then
        begin
          BtnClear.Enabled := false;
          BtnSave.Enabled := false;
          BtnEdit.Enabled := false;
        end;

        if ShowModal = mrOk
        then
          if Image.Visible
            then
              begin
                if (GetPropType^.Name = 'TPicture') then
                  SetOrdValue(LongInt(Image.Picture))
                else { Bitmap }
                  SetOrdValue(LongInt(Image.Picture.Bitmap))
              end
            else SetOrdValue(LongInt(nil))
       finally
         Free
       end { Create form }
  end {Edit};

{  function TPEIconView.GetAttributes: TPropertyAttributes;
  begin
    Result := [paDialog]
  end;

  procedure TPEIconView.Edit;
  var i: integer;
  begin
   inherited Edit;
   with TIconForm.Create(nil) do
     try
       IconList.Items.AddObject('', TIcon(GetOrdValue));
       if ShowModal = mrOk then
         with IconList do
           if not (Items.Count = 0) and (ItemIndex > -1) then
             SetOrdValue(LongInt (TIcon(Items.Objects[ItemIndex])) );

       with IconList.Items do
       begin
         for i := 0 to Count-1 do
         Objects[i].Free;
         Clear;
       end;

     finally
       Free
    end
  end;}

  procedure Register;
  begin
    RegisterPropertyEditor(TypeInfo(TPicture), nil, '', TPEImageView);
    RegisterPropertyEditor(TypeInfo(TBitmap), nil,  '', TPEImageView);
{    RegisterPropertyEditor(TypeInfo(TIcon), nil,  '', TPEIconView)}
  end;
end.