unit Iconview;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FileCtrl, StdCtrls, ExtCtrls, Buttons ;

type
  TIconViewForm = class(TForm)
    CurrentPath: TLabel;
    IconList: TListBox;
    DrivePicker: TDriveComboBox;
    DirectoryPicker: TDirectoryListBox;
    HiddenFileBox: TFileListBox;
    Panel1: TPanel;
    GlyphBtn: TSpeedButton;
    QuitBtn: TBitBtn;
    PrevBtn: TSpeedButton;
    NextBtn: TSpeedButton;
    GlyphName: TLabel;
    GlyphBtn2: TSpeedButton;
    procedure DrivePickerChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure UpdateDisplay(Sender: TObject);
    procedure IconListDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure QuitBtnClick(Sender: TObject);
    procedure IconListDblClick(Sender: TObject);
    procedure IconListClick(Sender: TObject);
    procedure PrevBtnClick(Sender: TObject);
    procedure NextBtnClick(Sender: TObject);

  private
    { Private declarations }
    Function LoadGlyphFile(GName : String ) : Boolean ;
    Function WinExecAndWait(Path : Pchar; Visibility : Word) : Word;
  public
    { Public declarations }
  end;

var	IconViewForm: TIconViewForm;

implementation

{$R *.DFM}

Function TIconViewForm.LoadGlyphFile(GName : String) : Boolean;

Var Extension,Icon : String ;

Begin
  Extension	:= ExtractFileExt(GName) ;
  If  (Extension = '.bmp') or (Extension = '.BMP')	then
  try
    GlyphName.Caption := GName;
  	GlyphBtn.Glyph.LoadFromFile(GName);
    GlyphBtn2.Glyph.LoadFromFile(GName);
    Result := TRUE;
  except
    MessageDlg( 'Error! - Unable to load ' + GName + ' into button',
                 mtError, [mbOK], 0 );
    Result := FALSE;
  end
  else
  try
    GlyphName.Caption := 'IT''S AN ICON' ;
    Icon := ExtractFilePath(Application.ExeName) + 'icon.bmp' ;
   	GlyphBtn.Glyph.LoadFromFile(Icon) ;
  	GlyphBtn2.Glyph.LoadFromFile(Icon);
  except
    MessageDlg( 'Error! - Unable to load icon.bmp into button',
                 mtError, [mbOK], 0 );
    Result := FALSE;
  end ;
end;

Function TIconViewForm.WinExecAndWait(Path : Pchar; Visibility : Word) : Word;

var	InstanceID 	: THandle ;
    Msg 				: TMSg ;

begin
  InstanceID := WinExec(Path,Visibility) ;
  If InstanceID < 32
  	then	WinExecAndWait := InstanceID { Indicates an Exec error }
    else	Repeat
            While PeekMessage(Msg,0,0,0,PM_REMOVE) do
            Begin
        			If Msg.Message = WM_QUIT
              	then	Halt(Msg.wParam);
        			TranslateMessage(Msg);
        			DispatchMessage(Msg);
      			End ;
    			Until GetModuleUsage(InstanceID) = 0;
end;

procedure TIconViewForm.DrivePickerChange(Sender: TObject);
begin
  { Point DirectoryPicker at wanted drive letter }
  DirectoryPicker.Drive   := DrivePicker.Drive ;
  { Update Caption of CurrentPath to reflect drive change }
  CurrentPath.Caption     := DirectoryPicker.GetItemPath(DirectoryPicker.ItemIndex) ;
  HiddenFileBox.Directory := DirectoryPicker.Directory;
end;

procedure TIconViewForm.FormCreate(Sender: TObject);

Var	P : String ;
    I : Integer ;

begin
  { Set up initial drive for DrivePicker }
  P := ExtractFilePath(Application.ExeName) ;
  DrivePicker.Drive       := P[1] ;
  { Set initial CurrentPath caption }
  CurrentPath.Caption     := DirectoryPicker.GetItemPath(DirectoryPicker.ItemIndex) ;
  HiddenFileBox.Directory := DirectoryPicker.Directory;
  { Set cell height for IconList }
	IconList.ItemHeight     := GetSystemMetrics(sm_cyIcon) + 10 ;
end;

procedure TIconViewForm.UpdateDisplay(Sender: TObject);

Var I   : Integer ;
    S,D : String ;
    p   : TPicture ;

begin
  { Set initial CurrentPath caption }
  CurrentPath.Caption     := DirectoryPicker.GetItemPath(DirectoryPicker.ItemIndex) ;
  HiddenFileBox.Directory := DirectoryPicker.Directory;
  { Clear the contents of the icon list }
  For I := 0 to IconList.Items.Count - 1 do
  	TPicture(IconList.Items.Objects[I]).Free ;
  IconList.Items.Clear ;
  { Now refill with new stuff }
  try
  	For I := 0 to HiddenFileBox.Items.Count - 1 do
  	Begin
    	S := CurrentPath.Caption ;
    	If S[Length(S)] <> '\'
      	then S := S + '\' ;
    	S := S + HiddenFileBox.Items[I] ;
    	{ Create a TPicture and load from file }
    	P := TPicture.Create ;
    	P.LoadFromFile(S) ;
   		IconList.Items.AddObject(HiddenFileBox.Items[I],P) ;
  	End ;
  finally
  	If IconList.Items.Count > 0
  		then	Begin
     					IconList.ItemIndex := 0 ;
        	    S	:= IconList.Items[IconList.ItemIndex] ;
							LoadGlyphFile(S) ;
     				End ;
  End ;
end;

procedure TIconViewForm.IconListDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);

Var S : String ;
    x,y : Integer ;
    Pic : TPicture ;

begin
  IconList.Canvas.FillRect(Rect) ;
  { First draw the icon }
  Pic := TPicture(IconList.Items.Objects[Index]) ;
  IconList.Canvas.Draw(Rect.Left + 2,Rect.Top + 5,Pic.Graphic) ;
  { Then draw the string }
  S := IconList.Items[Index] ;
  x := Rect.Left + GetSystemMetrics(sm_cxIcon) + 7 ;
  y := Rect.Top + (IconList.ItemHeight - abs(Font.Height)) div 2 ;
  IconList.Canvas.TextOut(x,y,S) ;
end;

procedure TIconViewForm.QuitBtnClick(Sender: TObject);
var I : Integer ;
begin
	{ Clear the contents of the icon list }
  For I := 0 to IconList.Items.Count - 1 do
  	TPicture(IconList.Items.Objects[I]).Free ;
  IconList.Items.Clear ;
  { Bye }
  Close ;
end;

procedure TIconViewForm.IconListDblClick(Sender: TObject);

var PgmP 							: ARRAY [0..79] of Char ;
    PgmS,S,Extension 	: String ;

begin
  PgmS := 'D:\DELPHI\BIN\IMAGEDIT.EXE ';
  S    := TListBox(Sender).Items[TListBox(Sender).ItemIndex] ;
	Extension	:= ExtractFileExt(S) ;
  If  (Extension = '.ico') or (Extension = '.ICO')	then
  Begin
  	IconViewForm.Hide ;
  	PgmS := PgmS + S ;
  	StrPCopy(PgmP,PgmS);
  	WinexecAndWait(PgmP,SW_SHOWNORMAL) ;
		IconViewForm.Show ;
  End else
    MessageDlg( 'Error! - ' + S + ' is not an ICON file',
                 mtError, [mbOK], 0 );
end;

procedure TIconViewForm.IconListClick(Sender: TObject);

Var	FName	: String ;

Begin
  FName := TListBox(Sender).Items[TListBox(Sender).ItemIndex] ;
	LoadGlyphFile(FName) ;
end;

procedure TIconViewForm.PrevBtnClick(Sender: TObject);
begin
  If	(IconList.Items.Count > 0) and
      (IconList.ItemIndex > 0) then
  Begin
  	IconList.ItemIndex := IconList.ItemIndex - 1 ;
		LoadGlyphFile(IconList.Items[IconList.ItemIndex]) ;
  End ;
end;

procedure TIconViewForm.NextBtnClick(Sender: TObject);
begin
	If	(IconList.Items.Count > 0) and
      (IconList.ItemIndex < IconList.Items.Count) then
  Begin
  	IconList.ItemIndex := IconList.ItemIndex + 1 ;
		LoadGlyphFile(IconList.Items[IconList.ItemIndex]) ;
  End ;
end;

end.
