{********************************************************************}
{                                                                    }
{  THTMLcolorDialog                                                  }
{                                                                    }
{  A simple decendant of TColorDialog with one new property:         }
{   HTMLcolor - The color converted to a hexadecimal RGB value       }
{  Example:                                                          }
{                                                                    }
{  if HTMLcolorDialog1.Execute then                                  }
{     Edit1.Text := HTMLcolorDialog1.HTMLcolor;                      }
{                                                                    }
{  If HTMLcolorDialog1.Color is clRed, the HTMLcolor will result in  }
{  the string '#FF000000'.					     }
{								     }
{  You can still use this as a normal ColorDialog.                   }
{                                                                    }
{  This source is of course free to use.                             }
{  Copyright  1998 NoComply                                         }
{                                                                    }
{********************************************************************}

unit HTMLcdlg;

interface

uses Messages, SysUtils, Classes, Controls, Forms, Graphics,
     Dialogs, Windows;

type
  THTMLcolorDialog = class(TColorDialog)
    private
        procedure AutoInitialize;
        procedure AutoDestroy;
    protected
        procedure Loaded; override;
    public
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        function HTMLcolor: String;
  end;

procedure Register;

implementation

procedure Register;
begin
     RegisterComponents('Dialogs', [THTMLcolorDialog]);
end;

procedure THTMLcolorDialog.AutoInitialize;
begin
end;

procedure THTMLcolorDialog.AutoDestroy;
begin
end;
constructor THTMLcolorDialog.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;
end;

destructor THTMLcolorDialog.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure THTMLcolorDialog.Loaded;
begin
     inherited Loaded;
end;

function THTMLcolorDialog.HTMLcolor: String;
var
     Temp : Integer;
     Temp2: String;
begin
     temp := ColorToRGB(Color);
     Temp2 := IntToHex(temp,6);
     //The result will be BBGGRR but I want it RRGGBB
     Result := '#'+Copy(Temp2,5,2)+Copy(Temp2,3,2)+Copy(Temp2,1,2);
end;


end.
