unit Siclmtst;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Sleeper, Sicl;

type
  TFormSICLTest = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Sleeper1: TSleeper;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  FormSICLTest: TFormSICLTest;

implementation

{$R *.DFM}

procedure TFormSICLTest.FormCreate(Sender: TObject);
var
  ret : integer;
  Str_hpib: string;
  PChar_hpib: array[0..19] of char;
begin
  new(actual);
  new(reason);

  Str_hpib := Edit3.Text;
  StrPCopy(PChar_hpib, Str_hpib);

  hpibid := IOPEN(PChar_hpib);

  if hpibid <= 0 then begin
    ret := IGETERRNO;
    Button1.Enabled := false;
    Edit2.Text := IntToStr(ret) + ': ' + StrPas(IGETERRSTR(ret));
    exit;
  end;
  Sleeper1.SleepFor(200);
  if ITIMEOUT(hpibid, 1000) <> 0 then messagebeep(0);

  if ICLEAR(hpibid) <> 0 then begin
    ret := IGETERRNO;
    Edit2.Text := IntToStr(ret) + ': ' + StrPas(IGETERRSTR(ret));
  end;

  Sleeper1.SleepFor(1000);
end;

procedure TFormSICLTest.FormClose(Sender: TObject; var Action: TCloseAction);
var
  ret : integer;
begin
  dispose(reason);
  dispose(actual);

  ret := ICLOSE(hpibid);
  _SICLCLEANUP;
end;

procedure TFormSICLTest.Button1Click(Sender: TObject);
var
  ret : integer;
  hpibAnswer: array[0..2048] of char;
  hpibCommand: array[0..127] of char;
begin
  Button1.Enabled := False;

  Edit2.Text := '';
  actual^ := 1;
  reason^ := 1;

  StrPCopy(hpibAnswer, '');
  if ((length(Edit1.Text) > 2) and (length(Edit1.Text) < 126)) then begin
    StrPCopy(hpibCommand, Edit1.Text);
    ret := IWRITE(hpibid, hpibCommand, (StrLen(hpibCommand)+1), 1, 0);

    { timeout in ms }
    Sleeper1.SleepFor(50);
    if ret <> 0 then
      Edit2.Text := IntToStr(ret) + ': ' + StrPas(IGETERRSTR(ret));

    if StrScan(hpibCommand, '?') <> nil then begin { begin von iread }
      ret := IREAD(hpibid, hpibAnswer, 512, reason, actual);
      Edit2.Text := Copy(StrPas(hpibAnswer), 1, (actual^-1));
      if ret <> 0 then
        Edit2.Text := IntToStr(ret) + ': ' + StrPas(IGETERRSTR(ret));
    end; { end von iread }
  end;
  Button1.Enabled := True;
end;

end.
