unit Sicl;

{ UNIT SICL.PAS for Delphi 1.0 (used with HP82341B)                            }
{ "translated" by Martin M. Welzel, April 1996, (email M.Welzel@tu-bs.de)      }
{                                                                              }
{ This unit is not the equivalent of SICL.BAS, it is not completely translated }
{ It is no problem to add missing functions. Have a look to the samples.       }
{ Enhancements are welcome, please use my email.                               }
{                                                                              }

interface

type
  pointerlongint = ^longint;
  pointerint = ^integer;

var
  actual: pointerlongint;
  reason: pointerint;
  hpibid: integer;

Const
{  Support levels: }
  I_SICL_REVISION = 39;       {  HP SICL Revision 3.9 }
  I_SICL_LEVEL = 3;           {  Support Level }

{  Byte Ordering constants }
  I_ORDER_LE = True;
  I_ORDER_BE = False;

{  Session types }
  I_SESS_INTF = 1;
  I_SESS_DEV = 2;
  I_SESS_CMDR = 3;

{  Interface Types }
  I_INTF_NONE = 0;
  I_INTF_GPIB = 1;
  I_INTF_VXI = 2;
  I_INTF_RS232 = 3;
{  5 is reserved -- don't use }
  I_INTF_USRDEF = 6;
{  7 is reserved -- don't use }
  I_INTF_LAN = 9;

{  iread termination conditions }
  I_TERM_MAXCNT = 1;
  I_TERM_CHR = 2;
  I_TERM_END = 4;
  I_TERM_NON_BLOCKED = 8;

{  ixtrig which values. not correct translated  (VB: &H1&)  }
{  I_TRIG_STD = $1;
  I_TRIG_ALL = $FFFFFFFF;
  I_TRIG_TTL0 = $1000;
  I_TRIG_TTL1 = $2000;
  I_TRIG_TTL2 = $4000;
  I_TRIG_TTL3 = $8000;
  I_TRIG_TTL4 = $10000;
  I_TRIG_TTL5 = $20000;
  I_TRIG_TTL6 = $40000;
  I_TRIG_TTL7 = $80000;
  I_TRIG_ECL0 = $100000;
  I_TRIG_ECL1 = $200000;
  I_TRIG_ECL2 = $400000;
  I_TRIG_ECL3 = $800000;
  I_TRIG_EXT0 = $1000000;
  I_TRIG_EXT1 = $2000000;
  I_TRIG_EXT2 = $4000000;
  I_TRIG_EXT3 = $8000000;
  I_TRIG_CLK0 = $10000000;
  I_TRIG_CLK1 = $20000000;
  I_TRIG_CLK2 = $40000000;
  I_TRIG_CLK10 = $80000000;
  I_TRIG_CLK100 = $800;
  I_TRIG_SERIAL_DTR = $400;
  I_TRIG_SERIAL_RTS = $200; }

{  ihint values }
  I_HINT_DONTCARE = 0;
  I_HINT_USEDMA = 1;
  I_HINT_USEPOLL = 2;
  I_HINT_USEINTR = 3;
  I_HINT_SYSTEM = 4;
  I_HINT_IO = 5;

{  isetintr values.  1-15 are interface independant. }
  I_INTR_OFF = 0;
  I_INTR_INTFACT = 1;
  I_INTR_INTFDEACT = 2;
  I_INTR_TRIG = 3;
  I_INTR_STB = 4;
  I_INTR_DEVCLR = 5;

{  VXI Interrupts }
  I_INTR_VXI_SIGNAL = 16;
  I_INTR_VXI_SYSRESET = 17;
  I_INTR_VXI_VME = 18;
  I_INTR_VXI_LLOCK = 19;
  I_INTR_VXI_UKNSIG = 20;

{  GP-IB Interrupts }
  I_INTR_GPIB_IFC = 16;
  I_INTR_GPIB_PPOLLCONFIG = 17;
  I_INTR_GPIB_REMLOC = 18;
  I_INTR_GPIB_GET = 20;
  I_INTR_GPIB_TLAC = 21;

{  RS-232 Interrupts }
  I_INTR_SERIAL_DAV = 16;
  I_INTR_SERIAL_MSL = 17;
  I_INTR_SERIAL_BREAK = 18;
  I_INTR_SERIAL_ERROR = 19;
  I_INTR_SERIAL_TEMT = 20;
  I_INTR_SERIAL_MCL = 21;

{  32 maximum isetintr values }
  I_INTR_MAX = 32;

{  ivxibusstatus values }
  I_VXI_BUS_TRIGGER = 0;
  I_VXI_BUS_LADDR = 1;
  I_VXI_BUS_SERVANT_AREA = 2;
  I_VXI_BUS_NORMOP = 3;
  I_VXI_BUS_CMDR_LADDR = 4;
  I_VXI_BUS_MAN_ID = 5;
  I_VXI_BUS_MODEL_ID = 6;
  I_VXI_BUS_PROTOCOL = 7;
  I_VXI_BUS_XPROT = 8;
  I_VXI_BUS_SHM_SIZE = 9;
  I_VXI_BUS_SHM_ADDR_SPACE = 10;
  I_VXI_SHM_PAGE = 11;
  I_VXI_BUS_VXIMXI = 12;
  I_VXI_BUS_TRIGSUPP = 13;

{  igpibbusstatus values }
  I_GPIB_BUS_REM = 1;
  I_GPIB_BUS_SRQ = 2;
  I_GPIB_BUS_NDAC = 3;
  I_GPIB_BUS_SYSCTLR = 4;
  I_GPIB_BUS_ACTCTLR = 5;
  I_GPIB_BUS_TALKER = 6;
  I_GPIB_BUS_LISTENER = 7;
  I_GPIB_BUS_ADDR = 8;
  I_GPIB_BUS_LINES = 9;

{  max and min GPIB t1 delay values for igpibsett1delay }
  I_GPIB_T1DELAY_MIN = 350;
  I_GPIB_T1DELAY_MAX = 2400;

{  RS-232 values }
  I_SERIAL_BAUD = 1;
  I_SERIAL_PARITY = 2;
  I_SERIAL_STOP = 3;
  I_SERIAL_WIDTH = 4;
  I_SERIAL_FLOW_CTRL = 5;
  I_SERIAL_MSL = 6;
  I_SERIAL_STAT = 7;
  I_SERIAL_RESET = 9;
  I_SERIAL_READ_EOI = 10;
  I_SERIAL_WRITE_EOI = 11;
  I_SERIAL_DUPLEX = 12;
  I_SERIAL_READ_BUFSZ = 13;
  I_SERIAL_READ_DAV = 14;

{  RS-232 duplex modes }
  I_SERIAL_DUPLEX_HALF = 1;
  I_SERIAL_DUPLEX_FULL = 2;

{  RS-232 UART status }
  I_SERIAL_DAV = $1;
  I_SERIAL_OVERFLOW = $2;
  I_SERIAL_PARERR = $4;
  I_SERIAL_FRAMING = $8;
  I_SERIAL_BREAK = $10;
  I_SERIAL_TEMT = $20;

{  RS-232 flow control }
  I_SERIAL_FLOW_NONE = 0;
  I_SERIAL_FLOW_XON = 1;
  I_SERIAL_FLOW_RTS_CTS = 2;
  I_SERIAL_FLOW_DTR_DSR = 3;

{  RS-232 modem status lines }
  I_SERIAL_DCD = $1;
  I_SERIAL_DSR = $2;
  I_SERIAL_CTS = $4;
  I_SERIAL_RI = $8;
  I_SERIAL_D_DCD = $10;
  I_SERIAL_D_DSR = $20;
  I_SERIAL_D_CTS = $40;
  I_SERIAL_D_TERI = $80;

{  RS-232 modem control lines }
  I_SERIAL_RTS = $1000;
  I_SERIAL_DTR = $2000;

{  RS-232 parity values }
  I_SERIAL_PAR_NONE = 0;
  I_SERIAL_PAR_EVEN = 1;
  I_SERIAL_PAR_ODD = 2;
  I_SERIAL_PAR_MARK = 3;
  I_SERIAL_PAR_SPACE = 4;
  I_SERIAL_PAR_IGNORE = 5;

{  RS-232 stop-bit values }
  I_SERIAL_STOP_1 = 1;
  I_SERIAL_STOP_2 = 2;

{  RS-232 character width }
  I_SERIAL_CHAR_5 = 5;
  I_SERIAL_CHAR_6 = 6;
  I_SERIAL_CHAR_7 = 7;
  I_SERIAL_CHAR_8 = 8;

{  EOI support (used with the I_SERIAL_*_EOI command) }
  I_SERIAL_EOI_CHR = $100;
  I_SERIAL_EOI_NONE = $200;
  I_SERIAL_EOI_BIT8 = $400;

{  imap mapspace values }
  I_MAP_A16 = $0;
  I_MAP_A24 = $1;
  I_MAP_A32 = $2;
  I_MAP_VXIDEV = $3;
  I_MAP_EXTEND = $4;
  I_MAP_INTFREG = $5;
  I_MAP_SHARED = $6;

{  Error Codes                              }
{  NOTE that User Error Codes 32501-32630 are reserved }
{  for HP SICL. }
  SICL_ERR_BASE = 32501;
  I_ERR_NOERROR = 0;
  I_ERR_SYNTAX = SICL_ERR_BASE;
  I_ERR_SYMNAME = 1 + SICL_ERR_BASE;
  I_ERR_BADADDR = 2 + SICL_ERR_BASE;
  I_ERR_BADID = 3 + SICL_ERR_BASE;
  I_ERR_PARAM = 4 + SICL_ERR_BASE;
  I_ERR_NOCONN = 5 + SICL_ERR_BASE;
  I_ERR_NOPERM = 6 + SICL_ERR_BASE;
  I_ERR_NOTSUPP = 7 + SICL_ERR_BASE;
  I_ERR_NORSRC = 8 + SICL_ERR_BASE;
  I_ERR_NOINTF = 9 + SICL_ERR_BASE;
  I_ERR_LOCKED = 10 + SICL_ERR_BASE;
  I_ERR_NOLOCK = 11 + SICL_ERR_BASE;
  I_ERR_BADFMT = 12 + SICL_ERR_BASE;
  I_ERR_DATA = 13 + SICL_ERR_BASE;
  I_ERR_TIMEOUT = 14 + SICL_ERR_BASE;
  I_ERR_OVERFLOW = 15 + SICL_ERR_BASE;
  I_ERR_IO = 16 + SICL_ERR_BASE;
  I_ERR_OS = 17 + SICL_ERR_BASE;
  I_ERR_BADMAP = 18 + SICL_ERR_BASE;
  I_ERR_NODEV = 19 + SICL_ERR_BASE;
  I_ERR_INVLADDR = 20 + SICL_ERR_BASE;
  I_ERR_NOTIMPL = 21 + SICL_ERR_BASE;
  I_ERR_ABORTED = 22 + SICL_ERR_BASE;
  I_ERR_BADCONFIG = 23 + SICL_ERR_BASE;
  I_ERR_NOCMDR = 24 + SICL_ERR_BASE;
  I_ERR_VERSION = 25 + SICL_ERR_BASE;
  I_ERR_NESTEDIO = 26 + SICL_ERR_BASE;
  I_ERR_BUSY = 27 + SICL_ERR_BASE;
  I_ERR_INTERNAL = 127 + SICL_ERR_BASE;
  I_ERR_INTERRUPT = 128 + SICL_ERR_BASE;
  I_ERR_UNKNOWNERR = 129 + SICL_ERR_BASE;
  SICL_ERR_LAST = I_ERR_UNKNOWNERR;

{  Default buffer sizes for formatted I/O }
  I_READ_BUF_SZ = 4096;
  I_WRITE_BUF_SZ = 128;

{  iflush mask values }
  I_BUF_READ = $1;
  I_BUF_WRITE = $2;
  I_BUF_DISCARD_READ = $4;
  I_BUF_DISCARD_WRITE = $8;
  I_BUF_WRITE_END = $10;

{  Define Word Serial commands for ivxiws  }
  WS_BNO_TOP_LVL = $100;

{  Word Serial Commands }
  WS_CMD_ANO = $C8FF;
  WS_MASK_ANO = $FFFF;
  WS_CMD_AHL = $A900;
  WS_MASK_AHL = $FF00;
  WS_CMD_AIL = $AA00;
  WS_MASK_AIL = $FF00;
  WS_CMD_AMC = $A800;
  WS_MASK_AMC = $FF00;
  WS_CMD_BNO = $FCFF;
  WS_MASK_BNO = $FEFF;
  WS_CMD_BA = $BC00;
  WS_CMD_BA_END = $BD00;
  WS_MASK_BA = $FE00;
  WS_CMD_BR = $DEFF;
  WS_MASK_BR = $FFFF;
  WS_CMD_CLR = $FFFF;
  WS_MASK_CLR = $FFFF;
  WS_CMD_CL = $EFFF;
  WS_MASK_CL = $FFFF;
  WS_CMD_CE = $AF00;
  WS_MASK_CE = $FF00;
  WS_CMD_ENO = $C9FF;
  WS_MASK_ENO = $FFFF;
  WS_CMD_RPE = $CDFF;
  WS_MASK_RPE = $FFFF;
  WS_CMD_GD = $BF00;
  WS_MASK_GD = $FF00;
  WS_CMD_IC = $BE00;
  WS_MASK_IC = $FF00;
  WS_CMD_RHL = $8C00;
  WS_MASK_RHL = $FF00;
  WS_CMD_RH = $C7FF;
  WS_MASK_RH = $FFFF;
  WS_CMD_RIL = $8D00;
  WS_MASK_RIL = $FF00;
  WS_CMD_RI = $CAFF;
  WS_MASK_RI = $FFFF;
  WS_CMD_RMOD = $CCFF;
  WS_MASK_RMOD = $FFFF;
  WS_CMD_RP = $DFFF;
  WS_MASK_RP = $FFFF;
  WS_CMD_RSTB = $CFFF;
  WS_MASK_RSTB = $FFFF;
  WS_CMD_RSA = $CEFF;
  WS_MASK_RSA = $FFFF;
  WS_CMD_RD = $8E00;
  WS_MASK_RD = $FF00;
  WS_CMD_CR = $8F00;
  WS_MASK_CR = $FF00;
  WS_CMD_SL = $EEFF;
  WS_MASK_SL = $FFFF;
  WS_CMD_SLMOD = $AE00;
  WS_MASK_SLMOD = $FF00;
  WS_CMD_SUMOD = $AD00;
  WS_MASK_SUMOD = $FF00;
  WS_CMD_TRIG = $EDFF;
  WS_MASK_TRIG = $FFFF;
  WS_CMD_USER = $0;
  WS_MASK_USER = $8000;

{ vxiinfo structure values }
  I_VXI_DEVCLASS_MEMORY = $0;
  I_VXI_DEVCLASS_EXTENDED = $4000;
  I_VXI_DEVCLASS_MSGBASED = $8000;
  I_VXI_DEVCLASS_REGBASED = $C000;

{ definition of functions and procedures, please add
  these one from SICL16.DLL, you want to use additionaly }

function IOPEN(Cmd: PChar): integer; far;
function ICLEAR(id: integer): integer; far;
function IGETINTFSESS(id: integer): integer; far;
function ITIMEOUT(id: integer; tval: longint): integer; far;
{iwrite is not translated correctly , but it works fine, e.g.
 ret := IWRITE(TDS540, TDSCmd, (StrLen(TDSCmd)+1), 1, 0); }
function IWRITE(id: integer; cmd: pchar; datalen: longint; endi: integer;
                wactual: longint): integer; far;
function IREAD(id: integer; answ: pchar; datalen: longint; rreason: pointerint;
               ractual: pointerlongint): integer; far;
function IGETERRNO: integer; far;
function IGETERRSTR(errint: integer): pchar; far;
function ICLOSE(id: integer): integer; far;
procedure _SICLCLEANUP; far;


implementation

{ functions/procedures defined in SICL16.DLL (c:\windows) }
function IOPEN;           external 'SICL16';
function ICLEAR;          external 'SICL16';
function IGETINTFSESS;    external 'SICL16';
function ITIMEOUT;        external 'SICL16';
function IWRITE;          external 'SICL16';
function IREAD;           external 'SICL16';
function IGETERRNO;       external 'SICL16';
function IGETERRSTR;      external 'SICL16';
function ICLOSE;          external 'SICL16';
procedure _SICLCLEANUP;   external 'SICL16';


end.
