unit Unit2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure LoadFormHints(aForm: TForm);
var
  i: Integer;
  h: THandle;
  resID: Longint;
  resStr: array [0..255] of Char;
begin
  h := LoadLibrary('hintdll.dll');
  for i := 0 to aForm.ComponentCount - 1 do begin
    {Check for > 0 since some components may not have hints}
    resID := aForm.Components[i].Tag;
    if resID  > 0  then begin
      LoadString(h, resID, resStr, SizeOf(resStr));
      TControl(aForm.Components[i]).Hint := StrPas(resStr);
    end;
  end;
  FreeLibrary(h);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  LoadFormHints(Self);
end;

end.


