unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Hexmap, StdCtrls, Menus, ExtCtrls, Spin, Buttons;

type
  TForm1 = class(TForm)
    ColorDialog1: TColorDialog;
    GroupBox1: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    GroupBox2: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    XorRow_lbl: TLabel;
    YorCol_lbl: TLabel;
    FontDialog1: TFontDialog;
    Button4: TButton;
    BitBtn1: TBitBtn;
    Button5: TButton;
    Panel1: TPanel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    OpenDialog1: TOpenDialog;
    ScrollBox1: TScrollBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    GroupBox5: TGroupBox;
    Label1: TLabel;
    HexMap1: THexMap;
    Button6: TButton;
    Button7: TButton;
    SaveDialog1: TSaveDialog;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure HexMap1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure HexMap1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button7Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  index: integer;
implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
 If colordialog1.execute then
   Hexmap1.backcolor := colordialog1.color;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  If colordialog1.execute then
   Hexmap1.Hexcolor := colordialog1.color;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  If colordialog1.execute then
   Hexmap1.linecolor := colordialog1.color;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  case checkbox2.state of
   cbChecked:hexmap1.hexshowlabels := true;
   cbUnchecked:hexmap1.hexshowlabels := false;
  end;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  case checkbox1.state of
   cbChecked:hexmap1.hex3d := true;
   cbUnchecked:hexmap1.hex3d := false;
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
If fontdialog1.execute then
hexmap1.font := fontdialog1.font;

end;

procedure TForm1.Button5Click(Sender: TObject);
begin
If Opendialog1.execute then
hexmap1.mapimagename := Opendialog1.filename;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
  case checkbox3.state of
   cbChecked:hexmap1.mapgridon := true;
   cbUnchecked:hexmap1.mapgridon := false;
  end;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
  case checkbox4.state of
   cbChecked:
    begin
     button1.enabled := false;
     button2.enabled := false;
     button5.enabled := true;
     If Opendialog1.execute then
      hexmap1.mapimagename := Opendialog1.filename;
     hexmap1.NoMapImage := false;
     SpinEdit1.Value:=hexmap1.HexColumns;
     SpinEdit2.Value:=hexmap1.HexRows;
    end;
   cbUnchecked:
    begin
     hexmap1.NoMapImage := true;
     button1.enabled := true;
     button2.enabled := true;
     button5.enabled := false;
    end;
  end;
end;

procedure TForm1.HexMap1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  position:tpoint;
begin
  if radiobutton1.checked = true then
    begin
    position := hexmap1.convertcoords(point(x,y),ptXY);
    label1.enabled:=true;
    XorRow_lbl.caption := 'Col: '+inttostr(position.x);
    YorCol_lbl.caption := 'Row: '+inttostr(position.y);
    end;

  if radiobutton2.checked = true then
    begin
    label1.caption:='Not Used';
    label1.enabled:=false;
    XorRow_lbl.caption := 'X: '+inttostr(x);
    YorCol_lbl.caption := 'Y: '+inttostr(y);

    end;
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
 hexmap1.HexColumns := SpinEdit1.Value;
end;

procedure TForm1.SpinEdit2Change(Sender: TObject);
begin
 hexmap1.HexRows := SpinEdit2.Value;
end;

procedure TForm1.HexMap1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
 ColorYouWant:TColor;
 position, eposition:TPoint;
 dist:integer;
begin
 position := hexmap1.convertcoords(point(x,y),ptXY);
 if (HexMap1.NoMapImage = True) and (position.x <> 0)
   and (position.y <> 0) then
  begin
   If colordialog1.execute then
     ColorYouWant := colordialog1.color;
   Hexmap1.PaintAHex(ColorYouWant, bsSolid, position);
  end;
 eposition.x := 1;
 eposition.y := 1;
 dist := hexmap1.RangeInHexes(position, eposition);
 if (position.x = 0) or (position.y = 0)
  then
   label1.caption:='Out of Range'
  else
   label1.caption:=inttostr(dist);
end;

procedure TForm1.Button7Click(Sender: TObject);
var
 MapFileName:String;
 DidWeDoIt:Boolean;
begin
 MapFileName := '';
 if OpenDialog1.execute then
   begin
    DidWeDoIt:=False;
    MapFileName := OpenDialog1.filename;
    DidWeDoIt:=hexmap1.loadhexmap(MapFileName);
    if DidWeDoIt = True then
     begin
      button1.enabled:=false;
      button2.enabled:=false;
      button3.enabled:=false;
      button4.enabled:=false;
      button5.enabled:=false;
      button7.enabled:=false;
      CheckBox1.enabled:=false;
      CheckBox2.enabled:=false;
      CheckBox3.enabled:=false;
      CheckBox4.enabled:=false;
      spinedit1.enabled:=false;
      spinedit2.enabled:=false;
      groupbox3.enabled:=false;
      groupbox4.enabled:=false;
     end;
   end;
end;

procedure TForm1.Button6Click(Sender: TObject);
var
 MapFileName:String;
begin
 MapFileName := '';
 if SaveDialog1.execute then
   begin
    MapFileName := SaveDialog1.filename;
    hexmap1.savehexmap(MapFileName);
   end;

 end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Label1.caption:='Click on a Hex!';
end;

end.
