unit Headunit;
(*This is a demonstration of how to read the Windows Executable Format to get
to the "Non Resident Name Table".

I was puzzled as to how Windows control panel listed the screen saver
descriptions into its list box. They did not seem to correspond to any .INI
file entries, or other configuration files, and I was able to deduce that the
descriptions were buried in the EXE's. From BP and Delphi programming experience,
I knew about the $D directive and that it embedded a text string in a compiled
program. The problem was that they were in a different location for each file.
Clearly there was some Microsoft "Secret" stuff going on. On calling $$ Borland
Tech Support, no one could answer the question as to how the $D text could be
retrieved, once compiled. But when I posted the question on CIS, one kind soul
was able to point me to the correct reference.

Within the table are:
1. The Module Description
2. Non-resident exported procedure name strings.

Both Exe's and DLL's have the same format.

Delphi has a compiler directive, {$D}  that tells the compiler to insert the
text folowing the directive into the Non-Resident Name Table.

To demonstrate, just compile this project and select an EXE, DLL, or SCR file.
If the file conforms to the correct format, and it has a description, it should
show up in the edit box.

For more info, go to the Microsoft Knowledge Base on CIS and download the
technical document Q65122, dated 02-Aug-1995.

Don Pearsall, CIS 76656,347
*)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Buttons, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    OpenDialog1: TOpenDialog;
    Edit1: TEdit;
    Label2: TLabel;
    SpeedButton1: TSpeedButton;
    Label4: TLabel;
    Panel1: TPanel;
    Label3: TLabel;
    BitBtn1: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Function GetFileDescription(ExeFileName:String):String;
Var
  ByteVal    : Byte;
  LongVal    : LongInt;
  StrBuffer  : Array[0..255] of Char;
  ExeHandle  : Integer;
Begin
    Result := '';
    If Length(ExeFileName) = 0 then Exit;
    Try
        {Open the file}
      ExeHandle := FileOpen(ExeFileName,fmOpenRead);
      If ExeHandle > 0 then
      Try
          {Null out Buffer}
        StrBuffer[0] := #0;
        FileRead(ExeHandle,StrBuffer,2);
          {Verify valid Microsoft file as 'MZ'}
        If StrLIComp(StrBuffer,'MZ',2) <> 0 then
        Begin
          FileClose(ExeHandle);
          Result := 'Invalid Header format';
          Exit;
        End;
          {Position at $3C to get the offset to the Non Resident header}
        FileSeek(ExeHandle,$3C,0);
         {Read the LongInt offset to the Non resident Header}
        FileRead(ExeHandle,LongVal,SizeOf(LongInt));
          {Seek to the NRH from Beginning of File}
        FileSeek(ExeHandle,LongVal,0);
        FileRead(ExeHandle,StrBuffer,2);
        If StrLIComp(StrBuffer,'NE',2) <> 0 then
        Begin
          Result := 'Invalid Header Signature';
          Exit;
        End;
          {Re-Position to Beginning of Header}
        FileSeek(ExeHandle,LongVal,0);
         {Seek $2C to get the offset of the Name table}
        FileSeek(ExeHandle,$2C,1);
           {Get the offset}
        FileRead(ExeHandle,LongVal,SizeOf(LongInt));
           {Seek to the Table from BOF}
        FileSeek(ExeHandle,LongVal,0);
           {Now at Name table, get length of Description}
        FileRead(ExeHandle,ByteVal,1);
           {Read the Description}
        FileRead(ExeHandle,StrBuffer,ByteVal);
           {Null Terminate it}
        StrBuffer[ByteVal] := #0;
           {Convert the string into the function result}
        Result := StrPas(StrBuffer)
      Except on EInOutError do
        Result := 'File IO error reading '+ExeFileName;
      End Else
        ShowMessage('Could not open '+ExeFileName);
    Finally
      FileClose(ExeHandle);
    End;
  End;

procedure TForm1.FormCreate(Sender: TObject);
Var
  DirStr    : String;
  SearchRec : TSearchRec;
begin
    {Do some fancy Char Array manipulation to avoid using PChars required by API
     Functions}
  DirStr[0] := Char(GetWindowsDirectory(@DirStr[1],SizeOf(DirStr)-1));
    {Append a backslash}
  If DirStr[Length(DirStr)] <> '\' then DirStr := DirStr+'\';
  Try
      {Find the first occurrence of a screen saver and use it as the default}
    If FindFirst(DirStr+'*.SCR',faAnyFile,SearchRec)= 0 then
    Begin
      Edit1.Text := DirStr+SearchRec.Name;
      Label3.Caption := GetFileDescription(Edit1.Text);
    End Else Label3.Caption := 'Type in, or use file dialog to select a file';
   Finally
    FindClose(SearchRec);
   End;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  If OpenDialog1.Execute then
  Begin
    Edit1.Text := OpenDialog1.FileName;
    Label3.Caption := GetFileDescription(Edit1.Text);
  End;
end;

end.
