unit Rptdemo;

{ Demo for GridReport Component
  Written By Godfrey Ko -
  email: godfreyk@gil.com.au

  All rights reserved
}


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, DB, DBTables, Grids, DBGrids, ExtCtrls,
  StdCtrls, Printers, Tabs, Gridrpt1;

type
  TFM_Grid = class(TForm)
    Panel1: TPanel;
    PA_Header: TPanel;
    Panel3: TPanel;
    DataSource1: TDataSource;
    BT_Print: TSpeedButton;
    BT_Save: TSpeedButton;
    ED_Header: TEdit;
    Panel4: TPanel;
    GroupBox1: TGroupBox;
    BT_TitleFont: TButton;
    BT_LineFont: TButton;
    BT_HeaderFont: TButton;
    GroupBox3: TGroupBox;
    CHK_ROW: TCheckBox;
    CHK_COL: TCheckBox;
    FontDialog1: TFontDialog;
    GroupBox2: TGroupBox;
    Portrait: TRadioButton;
    LandScape: TRadioButton;
    TimeStamp: TCheckBox;
    DBGrid1: TDBGrid;
    BT_Close: TBitBtn;
    SaveDialog1: TSaveDialog;
    TB_Source: TTable;
    BT_Export: TSpeedButton;
    PageNumber: TCheckBox;
    RecCount: TCheckBox;
    GridRpt1: TGridRpt;
    procedure BT_HeaderFontClick(Sender: TObject);
    procedure BT_PrintClick(Sender: TObject);
    procedure BT_TitleFontClick(Sender: TObject);
    procedure BT_LineFontClick(Sender: TObject);
    procedure CHK_COLClick(Sender: TObject);
    procedure CHK_ROWClick(Sender: TObject);
    procedure BT_ExportClick(Sender: TObject);
    procedure BT_CloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
      { Private declarations }
  public
    { Public declarations }
  end;

var
  FM_Grid: TFM_Grid;

implementation
{$R *.DFM}

{----------------------------------------------------------------------}

procedure TFM_Grid.BT_HeaderFontClick(Sender: TObject);
begin
FontDialog1.Font:=ED_Header.Font;
if FontDialog1.Execute then
   ED_Header.Font:=FontDialog1.Font;
PA_Header.Height:=ED_Header.Height + 10;
end;

{-------------------------------------------------------------}

procedure TFM_Grid.BT_PrintClick(Sender: TObject);
begin
if Portrait.Checked then
  Printer.Orientation := poPortrait
     else
      Printer.Orientation := poLandscape;


with GridRpt1 do
begin
ColLines:=CHK_Col.Checked;
RowLines:=CHK_Row.Checked;
Header:=ED_Header.Text;
DateLabel:='';

if TimeStamp.Checked then
  DateLabel:=DateLabel+FormatDateTime(' dd/mm/yyyy hh:mm',now);

if PageNumber.Checked then
      PageNumberPos:=pnBotLeft
        else
         PageNumberPos:=pnNone;

if RecCount.Checked then
      RecCountPos:=pnBotRight
         else
           ReccountPos:=pnNone;

  {Set Fonts}
  HeaderFont:=ED_Header.Font;
  TitleFont:=DBGrid1.TitleFont;
  Linesfont:=DBGRid1.Font;

GridRpt1.Print;
end;
end;

procedure TFM_Grid.BT_TitleFontClick(Sender: TObject);
begin
FontDialog1.Font:=DBGrid1.TitleFont;
if FontDialog1.Execute then
   DBGrid1.TitleFont:=FontDialog1.Font;
end;

procedure TFM_Grid.BT_LineFontClick(Sender: TObject);
begin
FontDialog1.Font:=DBGrid1.Font;
if FontDialog1.Execute then
   DBGrid1.Font:=FontDialog1.Font;
end;

procedure TFM_Grid.CHK_COLClick(Sender: TObject);
begin
if CHK_Col.Checked then
DBGrid1.Options:=DBGrid1.Options + [dgColLines]
  else
    DBGrid1.Options:=DBGrid1.Options - [dgColLines]
end;

procedure TFM_Grid.CHK_ROWClick(Sender: TObject);
begin
if CHK_Row.Checked then
DBGrid1.Options:=DBGrid1.Options + [dgRowLines]
  else
    DBGrid1.Options:=DBGrid1.Options - [dgRowLines]
end;

procedure TFM_Grid.BT_ExportClick(Sender: TObject);
begin
SaveDialog1.Filter := 'Text files|*.TXT';
if SaveDialog1.Execute then
begin
     GridRpt1.PrintFileName:=SaveDialog1.FileName;
     GridRpt1.PrintToFile:=True;
     GridRpt1.Print;
     GridRpt1.PrintToFile:=False;
end;
end;



procedure TFM_Grid.BT_CloseClick(Sender: TObject);
begin
Close;
end;

procedure TFM_Grid.FormCreate(Sender: TObject);
begin
TB_Source.Open;
TB_Source.SetRange([1023495],[1024034]);
end;

end.
