Somebody pointed out an annoying problem with TOutline - it would not draw
correctly if resized under certain circumstances. Note: this should fix
any related problem for descendants of TCustomGrid, because the bug is in
there.

The bug shows up both at designtime and runtime.

Bug description (try it!):

- Create a new project
- Drop an TOutline on the form
- Set the Outline's properties:
    Align: Client (just to make it easy)
    ScrollBars: ssHorizontal (or ssBoth)
    Lines: Enter LOOOONG line (one is really enough)
           Making the line long will let the horizontal SB show up

You should see now an outline with (at least) one single line sitting on
your form. Now:

- Resize the form horizontally so that the horizontal scrollbar shows
  up (your line does not fit into the scroll bar)
- Move the thumb to the end of the scrollbar (any other position
  different from the beginning of the scrollbar will do as well)
- Increase the form's width (resize it horizontally)

See what I mean???
If you entered a line like "abcdefg" and saw only "cdefg" before resizing
then you now will see something like "cdefg ab" after resizing it. Do not
worry, the fix is only a couple of lines away ;-)

The problem is somewhere in the code called by the resize routines as you
may have suspected already. What Borland did or rather DID NOT was to
update some graphics offset after having changed the scrollbars position
_programmatically_.

At the end of this message you will find extracts from the VCL source
"grids.pas" (WARNING: Version 1.01 sources !!!!) which should enable you
to find the parts of the code I fixed.

Before using the new file

       MAKE A BACKUP COPY OF YOUR OLD GRIDS.DCU.

Copy the appropriate file to your DELPHI\LIB directory and rebuild the
component library. There _will not_ be any version mismatches since
nothing has changed in the interface section...

IF YOU NOTICE ANY PROBLEMS WITH THIS BUGFIX, please send me an email
and post it to this newsgroup.
I DO NOT ACCEPT ANY LIABILITIES, OF COURSE!
*** USE AT YOUR OWN RISK *** (I will ;-)))  )


Stefan

Stefan.Hoffmeister@Uni-Passau.de
[alternative: w4hoff01@kakadu.rz.uni-passau.de]


**************************************************************


This is a snippet from:

{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright (c) 1995 Borland International        }
{                                                       }
{*******************************************************}

......

implementation

uses WinProcs, Consts;

{$IFDEF FixHorzScrollbarBug}
const
  Unit_GlobalBool_PatchFocus : boolean = false;
{$ENDIF}




procedure TCustomGrid.ModifyScrollBar(ScrollBar, ScrollCode, Pos: Word);

  { LOCAL PROCEDURE CUT OUT }

begin
  if CanFocus and TabStop and not (csDesigning in ComponentState)
     {$IFDEF FixHorzScrollbarBug} and not Unit_GlobalBool_PatchFocus {$ENDIF} then
    SetFocus;

  {$IFDEF FixHorzScrollbarBug}
    Unit_GlobalBool_PatchFocus := false;
  {$ENDIF}

  if (ScrollBar = SB_HORZ) and (ColCount = 1) then
  begin
    ModifyPixelScrollBar(ScrollCode, Pos);
    Exit;
  end;

  .........
end;




procedure TCustomGrid.UpdateScrollPos;
var
  DrawInfo: TGridDrawInfo;
  MaxTopLeft: TGridCoord;

  procedure SetScroll(Code: Word; Value: Integer);
  var
    NewOffset,
    OldOffset : integer;
    R: TGridRect;
  begin
    if GetScrollPos(Handle, Code) <> Value then
    begin
      SetScrollPos(Handle, Code, Value, True);

      {$IFDEF FixHorzScrollbarBug}
        if IsWindowVisible(Handle) then
        begin
          if Value < 0 then
            Value := 0;

          Unit_GlobalBool_PatchFocus := true;
          {

            this global variable is needed to prevent "SetFocus" from being
            called in the course of "ModifyScrollBar", see above

            It is initalized const := false and only set here to true.

            As soon as the "Unit_GlobalBool_PatchFocus" has been queried and "SetFocus"
            has been passed it is immediately set back to := false

            It would have been MUCH nicer if, instead of using "Unit_GlobalBool_PatchFocus",
            one had used a private class variable, e.g. FPatchFocus (which would actually
            have worked as well), but then the object would have changed in the INTERFACE
            part and thus all dependant units would have to be recompiled.

            Thus in favour of a plug-and-play replacement solution the rather unelegant way
            was chosen.

            If you don't like it - just move the global variable to the private section,
            it automatically gets initialized with the correct value (=false)

          }

          ModifyScrollBar(Code, SB_THUMBPOSITION, Value);
        end;
      {$ENDIF}



