unit Grid3d;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, DBGrids;

type
  TDB3DGrid = class(TDBGrid)
  private
    { Private declarations }
    FGrid3D : boolean;
    procedure SetGrid3D(Value : boolean);
  protected
    { Protected declarations }
    procedure DrawCell(ACol, ARow: Longint;ARect: TRect; AState: TGridDrawState); override;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
  published
    { Published declarations }
    property Grid3D : boolean read FGrid3D write SetGrid3D;
  end;

procedure Register;

implementation

constructor TDB3DGrid.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  Color:=clSilver;
end;

procedure TDB3DGrid.DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState);
begin
  inherited DrawCell(ACol, ARow,ARect,AState);
  if (FGrid3D=true) and ([dgRowLines, dgColLines] * Options =
      [dgRowLines, dgColLines]) then
      with ARect do
      begin
        Canvas.Pen.Color := clHighLightText;
        Canvas.PolyLine([Point(Left, Bottom - 1), Point(Left, Top), Point(Right, Top)]);
      end;
end;

procedure TDB3DGrid.SetGrid3D(Value : Boolean);
begin
  if FGrid3D<>Value then
  begin
    FGrid3D:=Value;
    Invalidate;
  end;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TDB3DGrid]);
end;

end.
