unit Main;

interface

uses
  GridUtil,
  IniFiles,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Grids, DBGrids, DB,
  DBTables;

type
  TMainForm = class(TForm)
    DataSource1: TDataSource;
    Table1: TTable;
    PanelButtons: TPanel;
    ButtonQuit: TBitBtn;
    ButtonColumns: TBitBtn;
    PanelClient: TPanel;
    Grid: TDBGrid;
    ButtonDefault: TBitBtn;
    procedure ButtonColumnsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ButtonDefaultClick(Sender: TObject);
    procedure ButtonQuitClick(Sender: TObject);
  private
    Ini : TIniFile;           (* used to store grid layout *)
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

(*
  These constants are used in the calls to read and write
  the grid layout. Because the INI string ID values in read
  and write must match perfectly it is better to use
  constants in this way, instead of typing the text
  between quotes in the procedure call.
  That way youhave to type it twice (once for read,
  once for write) and that leads to the possibillity
  of misspellings.
*)
const
  DEFAULTLAYOUTSECTION  = 'Default grid layouts';
  CUSTOMLAYOUTSECTION   = 'Custom grid layouts';
  MAINGRIDLAYOUTID      = 'Main grid';

(*
   This code launches the actual grid column
   visibility editor dialog when the 'columns'
   button is clicked.
*)

procedure TMainForm.ButtonColumnsClick(Sender: TObject);
var
  ct : integer;
begin
  (* Start by clearing the editor dialog. The
     dialog may be re-used by several different
     grids (although in this app we only
     have one grid) so it must be re-initialized
     before every use *)

  DlgColumnVisible.Clear;

  (* Set the number of checkbox columns that will
     appear in the editor dialog. Also set the
     width of the checkbox columns *)

  DlgColumnVisible.Cols      := 2;
  DlgColumnVisible.ItemWidth := 150;

  (* Now loop around through the fields of the grid
     and add checkkoxes to the editor dialog.
     The first argument to AddCheck is the description
     of the column. The second argument is the fieldname *)
  with Table1 do begin
   for ct := 0 to FieldCount-1 do begin
     DlgColumnVisible.AddCheck( Fields[ ct].DisplayLabel, Fields[ ct].FieldName);
   end;
  end;

  (* The dialog has now been setup properly. Run it *)
  DlgColumnVisible.Run( DataSource1);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  (* Make sure the table is open *)
  Table1.Active := True;

  (* Create a TIniFile object for reading and writing
     the grid layout. The file is called TGRIDUTI.INI
     and resides in the current directory *)
  Ini           := TIniFile.Create( '.\TGRIDUTI.INI');

  (* At this point, the grid layout is still exactly
     as designed in the forms designer.
     It is a good idea to store this default layout,
     so the user can revert to it in case the display
     is messed up beyond recognition. *)

  WriteGridLayout( DataSource1, glAll, Ini, DEFAULTLAYOUTSECTION, MAINGRIDLAYOUTID);

  (* Retrieve the non-default grid layout that was
     stored at the end of the previous session. If this
     is the first time that the program is run,
     the layout will remain in it's default state *)

  ReadGridLayout( DataSource1, glAll, Ini, CUSTOMLAYOUTSECTION, MAINGRIDLAYOUTID);
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  (* Store the (possibly customized by user) grid layout
     for retrieval at the start of the next session. *)
  WriteGridLayout( DataSource1, glAll, Ini, CUSTOMLAYOUTSECTION, MAINGRIDLAYOUTID);

  (* And clean up the TIniFile object, not reaaly necessary
     as we are exiting anyway, but let's make this a cleaner
     world, shall we? *)

  Ini.Free;
end;

procedure TMainForm.ButtonDefaultClick(Sender: TObject);
begin
  (* Revert to default: retrieve the default grid layout
     that was stored during form creation *)

  ReadGridLayout( DataSource1, glAll, Ini, DEFAULTLAYOUTSECTION, MAINGRIDLAYOUTID);
end;

procedure TMainForm.ButtonQuitClick(Sender: TObject);
begin
  Close;
end;

end.
