unit StrTools;

interface

uses
  Classes,
  SysUtils;

const
  whitespaces: set of char = [#8, #10, #12, #13, ' '];

function  StrLTrim( var s: string): string;
function  StrRTrim( var s: string): string;
function  StrTrim(  var s: string): string;
procedure StrMerge( list : TStrings; var s: string; sep : char);
procedure StrParse( var list : TStrings; s: string; sep : char);

implementation

(*
 *  StrLTrim, StrRTrim, StrTrim
 *
 *  These procedures will trim leading whitespaces, trailing
 *  whitespaces, or both.
 *)

function StrLTrim( var s: string): string;
begin
  while( length( s) > 0) and
         ( s[1] in whitespaces) do delete( s, 1, 1);
  Result := s;
end;

function StrRTrim( var s: string): string;
begin
  while( length( s) > 0) and
         ( s[ length( s)] in whitespaces) do
            delete( s, length( s), 1);
  Result := s;
end;

function StrTrim( var s: string): string;
begin
  strLTrim( s);
  strRTrim( s);
  Result := s;
end;


(*
 *  StrParse
 *
 *  This procedure parses the given string s and stores it as
 *  separate strings in the given TStrings object. Each new
 *  string is inserted at it's sequential position.
 *  The input string is assumed to be made up out of sequences
 *  of any characters, separated by the char given in 'sep'.
 *  A 'sep' char following the last substring is optional.
 *  Whitespace is stripped before adding the list element
 *  to the list.
 *)

procedure StrParse( var list : TStrings; s: string; sep : char);
var
  ct        : integer;
  oldct     : integer;
  len       : integer;
  seq       : integer;
  t         : string;
begin
  if list <> nil then begin

    ct    := 1;
    seq   := 0;
    while ct <= Length( s) do begin
      oldct  := ct;
      len    := 0;
      while ( s[ ct] <> sep) and
            (ct <= Length( s)) do begin
        ct  := ct  + 1;
        len := len + 1;
      end;
      ct := ct + 1;
      try
        t:= Copy( s, oldct, len);
        list.Insert( seq, StrTrim( t));
      finally
        seq := seq + 1;
      end;
    end;
  end;
end;


(*
 *  StrMerge
 *
 *  StrMerge will take all strings in the list and place these
 *  in a single string, separated by the 'sep' character.
 *  There is no 'sep' char after the last string element.
 *)

procedure StrMerge( list : TStrings; var s: string; sep : char);
var
  len       : integer;
  seq       : integer;
begin
  if (list <> nil) and (list.Count > 0) then begin

    len   := Length( list[ 0]) + 1;
    seq   := 1;
    s     := list[ 0];

    while (len < 250) and (seq < list.Count) do begin
      s   := s   + sep + list[ seq];
      seq := seq + 1;
      if seq > list.Count-1 then begin
        break;
      end;
      len := len + Length( list[ seq]) + 1;
    end;
  end;
end;

end.
