unit Main;

interface

uses
  Constant,
  GridLay,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, IniFiles, DBTables, DB,
  Grids, DBGrids, Menus;

type
  TDlgMain = class(TForm)
    PanelClient: TPanel;
    TblEmp: TTable;
    DSEmp: TDataSource;
    MainGrid: TDBGrid;
    TblEmpEmpNo: TIntegerField;
    TblEmpLastName: TStringField;
    TblEmpFirstName: TStringField;
    TblEmpPhoneExt: TStringField;
    TblEmpHireDate: TDateTimeField;
    TblEmpSalary: TFloatField;
    PopMenu: TPopupMenu;
    PopupStandard: TMenuItem;
    PopColEmpNo: TMenuItem;
    PopColLastName: TMenuItem;
    PopColFirstName: TMenuItem;
    PopColPhoneExt: TMenuItem;
    PopColHireDate: TMenuItem;
    PopColSalary: TMenuItem;
    N1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PopColClick(Sender: TObject);
    procedure PopupStandardClick(Sender: TObject);
  private
    { Private declarations }
    procedure PopColCheck;
  public
    { Public declarations }
  end;

var
  DlgMain: TDlgMain;
  AppIni : TIniFile;

implementation

{$R *.DFM}

procedure TDlgMain.FormCreate(Sender: TObject);
var
  path : string;
begin

  (* Programmatically set tags for some of the popup menu items,
     this will ensure they will have the correct tag values and
     make life easier further down in this source  *)

  PopColEmpNo.Tag     := TAGEMPNO;
  PopColLastName.tag  := TAGLASTNAME;
  PopColFirstName.tag := TAGFIRSTNAME;
  PopColPhoneExt.Tag  := TAGPHONEEXT;
  PopColHireDate.Tag  := TAGHIREDATE;
  PopColSalary.Tag    := TAGSALARY;

  (* Create an INI file object for an INI file in the same
     directory as the application executable.
     On fail, make global variable explicitly nil
     so we won't try to use it elsewhere *)

  path     := ChangeFileExt( Application.ExeName, '.INI');
  try
    AppIni := TIniFile.Create( path);
  except
    AppIni := nil;
  end;

  (* Store the default grid layout so user will always
     be able to revert to default when he's made a mess of it. *)
  WriteGridLayout( TblEmp, glAll, AppIni, LayoutSectionID, MainDefaultID);

  (* Read the current layout from the ini file and transfer visibility
     to popup menu items being checked or not *)
  ReadGridLayout( TblEmp, glAll, AppIni, LayoutSectionID, MainLayoutID);
  PopColCheck;

  (* Finally, open the table *)
  TblEmp.Open;
end;

procedure TDlgMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if AppIni <> nil then begin
    (* Save the current grid layout to ini file,
       then kill the ini file object *)
    WriteGridLayout( TblEmp, glAll, AppIni, LayoutSectionID, MainLayoutID);
    AppIni.Free;
  end;
end;

(*
  PopColCheck sets a checkmark for those items in the popumenu
  that correspond to a visible grid column.
*)
procedure TDlgMain.PopColCheck;
begin
  PopColEmpNo.Checked       := TblEmp.FieldByName( 'EmpNo').Visible;
  PopColLastName.Checked    := TblEmp.FieldByName( 'LastName').Visible;
  PopColFirstName.Checked   := TblEmp.FieldByName( 'FirstName').Visible;
  PopColPhoneExt.Checked    := TblEmp.FieldByName( 'PhoneExt').Visible;
  PopColHireDate.Checked    := TblEmp.FieldByName( 'HireDate').Visible;
  PopColSalary.Checked      := TblEmp.FieldByName( 'Salary').Visible;
end;

(*
  PopColClick toggles the checkmark for the popup menu item
  who called it. In addition, the visibility of the corresponding
  grid column is then set according to the stae of the checkmark.
*)
procedure TDlgMain.PopColClick(Sender: TObject);
begin
  if Sender is TMenuItem then begin
    TMenuItem( Sender).Checked := not TMenuItem( Sender).Checked;
    case TMenuItem( Sender).Tag of
      TAGEMPNO      : TblEmp.FieldByName( 'EmpNo').Visible     := PopColEmpNo.Checked;
      TAGLASTNAME   : TblEmp.FieldByName( 'LastName').Visible  := PopColLastName.Checked;
      TAGFIRSTNAME  : TblEmp.FieldByName( 'FirstName').Visible := PopColFirstName.Checked;
      TAGPHONEEXT   : TblEmp.FieldByName( 'PhoneExt').Visible  := PopColPhoneExt.Checked;
      TAGHIREDATE   : TblEmp.FieldByName( 'HireDate').Visible  := PopColHireDate.Checked;
      TAGSALARY     : TblEmp.FieldByName( 'Salary').Visible    := PopColSalary.Checked;
    end;
  end;
end;

(*
  PopupStandardClick resets the grid column layout to the state
  that has been designed by the programmer.
  It restores the defautl values that were writen during
  form creation, and then sets the check marks for the popup
  items related to the grid columns accordingly by calling
  the PopColCheck procedure
*)

procedure TDlgMain.PopupStandardClick(Sender: TObject);
begin
  if AppIni <> nil then begin
    ReadGridLayout( TblEmp, glAll, AppIni, LayoutSectionID, MainDefaultID);
    PopColCheck;
  end;
end;

end.
