unit Graph;
 {CGraph is a component for doing live time graphing. The graph plots a
 point every time the PointPlot method is called.  Three variables
 can be plotted per graph.}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;


{------------------------------------------------------------------------
}
type       {panel on graph that holds labels}
 TGraphPanel=class (TCustomControl)
 private

 protected

  procedure Paint; override;
 public
  constructor Create(AOwner:TComponent); override;

 end;
{----------------------------------------------------------------}
TPointToPlot=class       {create an object type to add to TList}
 Private
 Y1,Y2,Y3:Integer;
 constructor Create(APoint1,APoint2,APoint3:Integer);
end;
{----------------------------------------------------------------}
type TIntervalTimeType = (None,mSeconds,Seconds,Minutes,Hours);

type
  TGraph = class(TPanel)

  private
    R:TRect;
    Data1,Data2:TList;
    Indexer:Word;
    Panel1:TGraphPanel;
    MoveWin:Boolean;
    OldLeft,OldTop,OldWidth,OldHeight:Word;
    OldAlign:TAlign;
    ClipRgn:HRgn;
    Rect1,Rect2,Rect3,Rect4:TRect;
    FData1Color,FData2Color,FData3Color:TColor;
    FData1Label,FData2Label,FData3Label:String;
    {FNumOfDataPts:Word;}
    FMinRange:Integer;
    FMaxRange:Integer;
    FInterval:Word;
    FBackColor:TColor;
    FTimeType:TIntervalTimeType;
    procedure SetMinRange(AMinRange:Integer);
    procedure SetMaxRange(AMaxRange:Integer);
    procedure SetInterval(AInterval:Word);
    procedure SetBackGrColor(AColor:TColor);
    procedure SetIntervalTimeType(Value:TIntervalTimeType);
    procedure SetData1Color(AColor:TColor);
    procedure SetData2Color(AColor:TColor);
    procedure SetData3Color(AColor:TColor);
    procedure SetData1Label(AString:String);
    procedure SetData2Label(AString:String);
    procedure SetData3Label(AString:String);

  protected
    procedure Paint; override;
    procedure ReSize(var Msg:TMsg);message WM_Size;
    procedure LMouseDown(var Msg:TWMMouse); message WM_LButtonDown;
    procedure LMouseDblClk(var info); message WM_LButtonDblClk;
    procedure LMouseMove(var Msg:TWMMouse);message WM_MouseMove;
    procedure Moved(var info);message WM_Move;
   public
    constructor Create(AOwner:TComponent); override;
    destructor Destroy; override;
    procedure PlotPoints(A,B,C:Integer);Virtual;


  published
    property DataMinRange:Integer read FMinRange Write SetMinRange 
default 0;
    property DataMaxRange:Integer read FMaxRange Write SetMaxRange 
default 100;
    property DataTimeInterval:Word read FInterval Write SetInterval 
default 1;
    property DataBackGround:TColor read FBackColor Write SetBackGrColor 
default clTeal;
    property DataTimeType:TIntervalTimeType read FTimeType Write 
SetIntervalTimeType default
Seconds;
    property Data1Color:TColor read FData1Color Write SetData1Color 
default clAqua;
    property Data2Color:TColor read FData2Color Write SetData2Color 
default clWhite;
    property Data3Color:TColor read FData3Color Write SetData3Color 
default clLime;
    property Data1Label:String read FData1Label Write SetData1Label;
    property Data2Label:String read FData2Label Write SetData2Label;
    property Data3Label:String read FData3Label Write SetData3Label;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TGraph]);
end;
{-----------------------------------------------------------------------}
Constructor TGraphPanel.Create(AOwner:TComponent);
begin
 inherited Create(AOwner);
 end;

procedure TGraphPanel.Paint;
var TextHt,T,L,W,H,k:Word;
begin
 inherited Paint;
 Color:= TGraph(Parent).FBackColor;
 Canvas.Brush.Color:=TGraph(Parent).FBackColor;
 Canvas.Font:=TGraph(Parent).Font;
 TextHt:=TGraph(Parent).Canvas.TextHeight('A');
 T:=TextHt*2;
 L:=Top;
 W:=Canvas.TextWidth(TGraph(Parent).FData1Label+'   '
 +TGraph(Parent).FData2Label+'   '+TGraph(Parent).FData3Label);
 H:=TextHt;
 H:=TextHt;
 If W+L>TGraph(Parent).R.Right then L:=TGraph(Parent).R.Left+2;
 If W+L>TGraph(Parent).R.Right then
  W:=TGraph(Parent).R.Right-TGraph(Parent).R.Left-4;
 SetBounds(L,T,W,H);
 With Canvas Do
  begin
   Font.Color:=TGraph(Parent).FData1Color;
   TextOut(0,0,TGraph(Parent).FData1Label);
   TextOut(PenPos.X,PenPos.Y,'   ');
   Font.Color:=TGraph(Parent).FData2Color;
   TextOut(PenPos.X,PenPos.Y,TGraph(Parent).FData2Label);
   TextOut(PenPos.X,PenPos.Y,'   ');
   TextOut(PenPos.X,PenPos.Y,'fuck off');
   Font.Color:=TGraph(Parent).FData3Color;
   TextOut(PenPos.X,PenPos.Y,TGraph(Parent).FData3Label);
  end;
end;
{------------------------------------------------------------------------
}
Constructor TPointToPlot.Create(APoint1,APoint2,APoint3:Integer);
begin
 Y1:=APoint1;
 Y2:=APoint2;
 Y3:=APoint3;
end;
{-----------------------------------------------------------------}
Constructor TGraph.Create(AOwner:TComponent);
begin
 inherited Create(AOwner);
 top:=200;
 Width:=325;
 Height:=145;
 Align:=alNone;
 Font.Name:='Arial';
 Font.Style:=[];
 Font.Size:=9;
 FMinRange:=0;
 FMaxRange:=100;
 FBackColor:=clTeal;
 FTimeType:=Seconds;
 FInterval:=1;
 FData1Color:=clAqua;
 FData2Color:=clWhite;
 FData3Color:=clLime;
 FData1Label:='Data1';
 FData2Label:='Data2';
 FData3Label:='Data3';
 Data1:=TList.Create;
 Data2:=TList.Create;
 Data1.Add(Data2);
 Panel1:=TGraphPanel.Create(TGraph(Parent));
 With Panel1 do
  begin
   Parent:=Self;
   Setbounds(10,10,1,1)
  end;
 Panel1.Color:=FBackColor;
end;

Destructor TGraph.Destroy;
var I,PtsCount:word;
    LastDataPt,DataPt:TPointToPlot;
begin
 If Data1<>Nil then
  begin
   For I:= Data1.Count-1 downto 0 do {go thru lists & free any objects}
    begin
     DataPt:=TPointToPlot(Data1.Items[I]);
     DataPt.Free;
    end;
   Data1.Free;
  end;
 If Panel1<>Nil then Panel1.Free;
 inherited Destroy;
end;

procedure TGraph.LMouseDown(var Msg:TWMMouse);
var Ht:Word;
    MousePt:TPoint;
    ReSize:Word;
begin
 ReSize:=0;
 MousePt.X:=Msg.XPos;
 MousePt.Y:=Msg.YPos;
 With Canvas do
  begin
   Ht:=TextHeight('A');
   Rect1.Left:=0;Rect1.Top:=0;Rect1.Right:=Ht;Rect1.Bottom:=Ht;
   Rect2.Left:=0;Rect2.Top:=Height-Ht;
   Rect2.Right:=Ht;Rect2.Bottom:=Height;
   Rect3.Left:=Width-Ht;Rect3.Top:=0;
   Rect3.Right:=Width;Rect3.Bottom:=Ht;
   Rect4.Left:=Width-Ht;Rect4.Top:=Height-Ht;
   Rect4.Right:=Width;Rect4.Bottom:=Height;
   DrawFocusRect(Rect1);
   DrawFocusRect(Rect2);
   DrawFocusRect(Rect3);
   DrawFocusRect(Rect4);
  end;
 If PtInRect(Rect1,MousePt) then ReSize:=HTTopLeft
 else If PtInRect(Rect2,MousePt) then ReSize:=HTBottomLeft
 else If PtInRect(Rect3,MousePt) then ReSize:=HTTopRight
 else If PtInRect(Rect4,MousePt) then ReSize:=HTBottomRight
 else ReSize:=HTCaption;
 SendMessage(Handle,WM_NClButtonDown,ReSize,0);
 MoveWin:=True;
end;



procedure TGraph.LMouseMove(var Msg:TWMMouse);
begin
 If MoveWin then
 with Canvas do
  begin
   DrawFocusRect(Rect1);
   DrawFocusRect(Rect2);
   DrawFocusRect(Rect3);
   DrawFocusRect(Rect4);
   MoveWin:=False;
  end;
end;

procedure TGraph.Moved(var info);
begin
 MoveWin:=False;
end;

procedure TGraph.LMouseDblClk(var info);
begin
 If Align=alNone then
  begin
   OldAlign:= Align;
   OldLeft:=Left;
   OldTop:=Top;
   OldWidth:=Width;
   OldHeight:=Height;
   Align:=alClient;
  end
 else
  begin
   Align:=OldAlign;
   SetBounds(OldLeft,OldTop,OldWidth,OldHeight);
  end;
end;
procedure TGraph.ReSize(var Msg:TMsg);
var RangeSize,TextHt,Counter,I:Word;
    DataPt:TPointToPlot;
 begin

 end;

procedure TGraph.Paint;
var TextHt,TextLen,DivisionHt,GraphHt,I,Range,Counter,RangeSize:Word;
    IncAmount,Target:Word;
    GraphText,TimeLabel:String;
    FracNum:Boolean;
    DataPt:TPointToPlot;
 procedure DoRightDivision(Amount,Value:Integer);
  begin
   With Canvas Do
    begin
     MoveTo(R.Right,R.Top+Amount);LineTo(R.Right+3,R.Top+ Amount);
     TextOut(R.Right+3,R.Top+Amount-TextHt,IntToStr(Value));
    end;
  end;
begin {main procedure}
 inherited Paint;
 With Canvas Do  {size graph area according to text length}
 If TextWidth(IntToStr(FMinRange))>TextWidth(IntToStr(FMaxRange))
 Then RangeSize:=TextWidth(IntToStr(FMinRange))
 Else RangeSize:=TextWidth(IntToStr(FMaxRange));
 TextHt:=Canvas.TextHeight('A') Div 2;
 With R Do
  begin
   Left:=TextHt*3 Div 2+BevelWidth;
   Top:=TextHt*3 +BevelWidth;
   Right:=Width-RangeSize-BevelWidth-TextHt;
   Bottom:=Height-TextHt*2-BevelWidth-TextHt;
{expand or contract storage for data as needed to fit drawing area}
   Counter:=Data1.Count;
   If (Right-Left-3)>(Data1.Count) then
   {drawing space has increased in size}
    for I:=Counter To (Right-Left-3) Do
      Try
       DataPt:=TPointToPlot.Create(FMinRange,FMinRange,FMinRange);
       Data1.Add(DataPt);
      Except
       On EListError do
       MessageDlg('Error adding to graph points 
list.',mtInformation,[mbOK],0);
       On EOutOfMemory do
       MessageDlg('Lack of heap momory for creating graph 
points.',mtInformation,[mbOK],0);
      end
    else   {dwg space has decreased in size}
     if (Right-Left-2)<(Data1.Count) then
      begin
       for I:=(Right-Left-2) To Counter-1 Do
        begin
         DataPt:=TPointToPlot(Data1.Items[Data1.Count-1]);
         DataPt.Free;
         Data1.Delete(Data1.Count-1);
        end;
       If Indexer>Data1.Count-1+R.Left
        then Indexer:=Data1.Count-1+R.Left;
      end;
  end;
 With Canvas Do
   begin
    If Data1.Count=0 then Application.Terminate;
    Brush.Color:=FBackColor;
    Pen.Color:=clBlack;
    Rectangle(R.Left,R.Top,R.Right,R.Bottom); {graph area}
    InflateRect(R,-1,-1);
    If Indexer=0 then Indexer:=R.Left;{first pass-set indexer to start 
pt}
    Brush.Color:=Color;
   {draw numbers on Y axis }
    MoveTo(R.Right,R.Top);LineTo(R.Right+2,R.Top);
    TextOut(R.Right+3,R.Top-TextHt,IntToStr(FMaxRange));
    MoveTo(R.Right,R.Bottom-1);LineTo(R.Right+2,R.Bottom-1);
    TextOut(R.Right+3,R.Bottom-TextHt-1,IntToStr(FMinRange));
    {Calculate the # of vertical divisions to write}
    GraphHt:=R.Bottom-R.Top;
    DivisionHt:=GraphHt Div (TextHt*4);
    Range:=FMaxRange-FMinRange;
    Case DivisionHt of
     0:begin
        MoveTo(R.Right,R.Top+GraphHt Div 
2);LineTo(R.Right+2,R.Top+GraphHt Div 2);
       end;
     1:DoRightDivision(GraphHt Div 2,Range Div 2+FMinRange);
     2,3:begin
        DoRightDivision(GraphHt Div 4,Range Div 4*3+FMinRange);
        DoRightDivision(GraphHt Div 2,Range Div 2+FMinRange);
        DoRightDivision(GraphHt Div 4*3,Range Div 4+FMinRange);
       end;
     4:begin
        For I:= 1 To 9 Do
         If Not Odd(I) Then
         DoRightDivision(Round(GraphHt* I/10),Round(Range 
*(10-I)/10)+FMinRange);
       end;
     else For I:= 1 To 9 Do
        DoRightDivision(Round(GraphHt* I/10),Round(Range 
*(10-I)/10)+FMinRange);
    End; {Case}
    {Calculate and draw divisions on the X-Axis}
    {First set the variables}
    I:=R.Left;Counter:=0;TimeLabel:='Sec';
    IncAmount:=10;Target:=30; FracNum:=False;
    Case FTimetype Of
     None:begin TimeLabel:='';GraphHt:=1;end;
     mSeconds:GraphHt:=1000;
     Seconds:Case FInterval of
        1..2:GraphHt:=1;
        Else begin GraphHt:=60;TimeLabel:='Min';end;
       end;
     Minutes:Case FInterval of
        1..2:begin GraphHt:=1;TimeLabel:='Min';end;
        Else begin GraphHt:=60;TimeLabel:='Hr';end;
       end;
     Hours:
       begin Target:=24;IncAmount:=12;
        GraphHt:=24;TimeLabel:='Day';
       end;
    end;
    Range:=Target;
    {Then draw the x axis}
    While I<R.Right Do
     begin
      If Range=Target Then
       begin
        MoveTo(I,R.Bottom); LineTo(I,R.Bottom+4);
        GraphText:=FloatToStr((Counter*(FInterval/GraphHt)));
        TextLen:=TextWidth(GraphText) Div 2;
        If R.Right-I>TextLen+TextWidth(TimeLabel) Then
        TextOut(I-TextLen,R.Bottom+3,GraphText);
        Range:=0;
       end
      else begin
      MoveTo(I,R.Bottom); LineTo(I,R.Bottom+2);
      end;
      Inc(I,IncAmount);Inc(Counter,IncAmount);Inc(Range,IncAmount);
     end;
    {draw the time unit}
     If FTimeType<>None Then
     TextOut(R.Right-TextWidth(TimeLabel)+1,R.Bottom+3,TimeLabel);
    {plot points on graph}
    Range:=FMaxRange-FMinRange;
    GraphHt:=R.Bottom-R.Top-1;
    Counter:=R.Bottom-1;
    {create clipping region}
    ClipRgn:=CreateRectRgn(R.Left,R.Top,R.Right,R.Bottom);
    SelectClipRgn(Canvas.Handle,ClipRgn);
    DeleteObject(ClipRgn);
    {Plot 1st series of data}
    DataPt:=TPointToPlot(Data1.Items[0]);
    Pen.Color:=FData1Color;
    Target:=Trunc(Counter-(DataPt.Y1-FMinRange)/Range*GraphHt);
    MoveTo(R.Left,Target);
    For I:=1 To Data1.Count-1 Do
      begin
       DataPt:=TPointToPlot(Data1.Items[I]);
       Target:=Trunc(Counter-(DataPt.Y1-FMinRange)/Range*GraphHt);
       LineTo(R.Left+I,Target);
      end;
     {Plot 2nd series of data}
     DataPt:=TPointToPlot(Data1.Items[0]);
     Pen.Color:=FData2Color;
     Target:=Trunc(Counter-(DataPt.Y2-FMinRange)/Range*GraphHt);
     MoveTo(R.Left,Target);
     For I:=1 To Data1.Count-1 Do
      begin
       DataPt:=TPointToPlot(Data1.Items[I]);
       Target:=Trunc(Counter-(DataPt.Y2-FMinRange)/Range*GraphHt);
       LineTo(R.Left+I,Target);
      end;
     {Plot 3rd series of data}
     DataPt:=TPointToPlot(Data1.Items[0]);
     Pen.Color:=FData3Color;
     Target:=Trunc(Counter-(DataPt.Y3-FMinRange)/Range*GraphHt);
     MoveTo(R.Left,Target);
     For I:=1 To Data1.Count-1 Do
      begin
       DataPt:=TPointToPlot(Data1.Items[I]);
       Target:=Trunc(Counter-(DataPt.Y3-FMinRange)/Range*GraphHt);
       LineTo(R.Left+I,Target)
     end;
    {draw position line}
  If FBackColor=$FFFFFF then Pen.Color:=$0 else Pen.Color:=$FFFFFF;
  MoveTo(Indexer+1,R.Top);
  LineTo(Indexer+1,R.Bottom);
 end;{with canvas}
end;

procedure TGraph.SetMinRange(AMinRange:Integer);
begin
 If (AMinRange<>FMinRange)And(FMaxRange-AMinRange>9) Then
  begin
   FMinRange:=AMinRange;
   ReFresh;
  end;
end;

procedure TGraph.SetMaxRange(AMaxRange:Integer);
begin
 If (AMaxRange<>FMaxRange)And(AMaxRange-FMinRange>9) Then
  begin
   FMaxRange:=AMaxRange;
   Paint;
  end;
end;

procedure TGraph.SetInterval(AInterval:Word);
begin
  Case FTimeType of
   None:FInterval:=AInterval;
   MSeconds:
    begin
     If AInterval>1000 Then
      begin
       application.MessageBox('Maximum value is 1000 when MSeconds 
selected.','Over
Range.',mb_OK);
       AInterval:=1000;
      end;
     If AInterval<100 Then
     application.MessageBox('Minimum value of 100 when MSeconds selected 
is recommended
for accuracy.','Over Range.',mb_OK);
     FInterval:=AInterval;
    end;
   Seconds:
    begin
     If AInterval>60 Then
      begin
       application.MessageBox('Maximum value is 60 when Seconds 
selected.','Over
Range.',mb_OK);
       AInterval:=60;
      end;
     FInterval:=AInterval;
    end;
   Minutes:
    begin
     If AInterval>60 Then
      begin
       application.MessageBox( 'Maximum value is 60 when Minutes 
selected.','Over
Range.',mb_OK);
       AInterval:=60;
      end;
     FInterval:=AInterval;
    end;
   Hours:
    begin
     If AInterval>24 Then
      begin
       application.MessageBox( 'Maximum value is 24 when Hours 
selected.','Over
Range.',mb_OK);
       AInterval:=24;
      end;
     FInterval:=AInterval;
    end;
   end; {Case}
 Paint;
end;


procedure TGraph.SetIntervalTimeType(Value:TIntervalTimeType);
begin
 If Value<>FTimeType then
  begin
   FTimeType:=Value;
   Case FTimeType of
    mSeconds:If FInterval<100 then SetInterval(100)
             else SetInterval(FInterval);
    Seconds,Minutes:If FInterval>60 then SetInterval(1)
                    else SetInterval(FInterval);
    Hours:If FInterval>24 then SetInterval(1)
          else SetInterval(FInterval);
   end;{case}
  end;
end;

procedure TGraph.SetBackGrColor(AColor:TColor);
begin
 If AColor<>FBackColor then
  begin
   FBackColor:=AColor;
   Paint;
   Panel1.Paint
  end;
end;

procedure TGraph.SetData1Color(AColor:TColor);
begin
 If AColor<>FData1Color then
  begin
   FData1Color:=AColor;
   Paint;
   Panel1.Paint
  end;
end;

procedure TGraph.SetData2Color(AColor:TColor);
begin
 If AColor<>FData2Color then
  begin
   FData2Color:=AColor;
   Paint;
   Panel1.Paint
  end;
end;

procedure TGraph.SetData3Color(AColor:TColor);
begin
 If AColor<>FData3Color then
  begin
   FData3Color:=AColor;
   Paint;
   Panel1.Paint
  end;
end;

procedure TGraph.SetData1Label(AString:String);
begin
 If AString<>FData1Label Then
 begin
  FData1Label:=AString;
  Panel1.Paint;
 end;
end;

procedure TGraph.SetData2Label(AString:String);
begin
 If AString<>FData2Label Then
 begin
  FData2Label:=AString;
  Panel1.Paint;
 end;
end;

procedure TGraph.SetData3Label(AString:String);
begin
 If AString<>FData3Label Then
 begin
  FData3Label:=AString;
  Panel1.Paint;
 end;
end;

procedure TGraph.PlotPoints(A,B,C:Integer);
var Blank,Range,GraphHt,Counter,Target:Word;
    I:Integer;
    LastDataPt,DataPt:TPointToPlot;
 procedure Plot(AColor:TColor;LastValue,NewValue:Integer);
 begin
  With Canvas Do
   begin
    Pen.Color:=AColor;
    Range:=FMaxRange-FMinRange;
    GraphHt:=R.Bottom-R.Top-1;
    If Indexer=R.Left then
     begin
      Target:=Trunc(R.Bottom-1-(LastValue-FMinRange)/Range*GraphHt);
      If (LastValue>=FMinRange)and(LastValue<=FMaxRange) then
Pixels[R.Left,Target]:=AColor;
     end
    else
     begin
     {move to last data point}
      Target:=Trunc(R.Bottom-1-(LastValue-FMinRange)/Range*GraphHt);
      MoveTo(Indexer-1,Target);
      {draw line to new data pt}
      Target:=Trunc(R.Bottom-1-(NewValue-FMinRange)/Range*GraphHt);
      LineTo(Indexer,Target);
     end;
   end;
 end;
begin {main procedure}
  Inc(Indexer);
  Canvas.Pen.Color:=FBackColor; {erase position line}
  Canvas.MoveTo(Indexer,R.Top);
  Canvas.LineTo(Indexer,R.Bottom);
  {Save the data}
   DataPt:=TPointToPlot(Data1.Items[Indexer-R.Left]);
   DataPt.Y1:=A;
   DataPt.Y2:=B;
   DataPt.Y3:=C;
 {Get the last data pt}
  If Indexer=R.Left then
   LastDataPt:=TPointToPlot(Data1.Items[0])
  else
   LastDataPt:=TPointToPlot(Data1.Items[Indexer-R.Left-1]);
   {create clipping region}
   ClipRgn:=CreateRectRgn(R.Left,R.Top,R.Right,R.Bottom);
   SelectClipRgn(Canvas.Handle,ClipRgn);
   DeleteObject(ClipRgn);
  {Plot the data}
  Plot(FData1Color,LastDataPt.Y1,A);
  Plot(FData2Color,LastDataPt.Y2,B);
  Plot(FData3Color,LastDataPt.Y3,C);
  {draw position line indicating next addition pt on graph}
  If FBackColor=clWhite then Canvas.Pen.Color:=$0 else 
Canvas.Pen.Color:=$ffffff;
  If Indexer-R.Left+2>Data1.Count then
   begin
    Indexer:=R.Left-1; Blank:=R.Left;
   end
  else Blank:=Indexer+1;
  Canvas.MoveTo(Blank,R.Top);
  Canvas.LineTo(Blank,R.Bottom);
end;

initialization
RegisterClass(TGraphPanel);
end.


