unit Sample;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grapheur, Util1, Util2, StdCtrls, Menus, Printers;
  {Don't forget to add Util1 and Util2}

type
  TDemo = class(TForm)
    ObjGrapheur1: TObjGrapheur;
    ObjGrapheur2: TObjGrapheur;
    ObjGrapheur3: TObjGrapheur;
    ObjGrapheur4: TObjGrapheur;
    ObjGrapheur5: TObjGrapheur;
    ObjGrapheur6: TObjGrapheur;
    XMarker: TLabel;
    XPoint: TLabel;
    Lab1: TLabel;
    Lab2: TLabel;
    Lab4: TLabel;
    Lab6: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ObjGrapheur1MarkerMove(Sender: TObject;
      mMarker: TObjMarker; mGraphe: TObjGraphe; X, Y, dX, dY, Slop,
      X0, Y0: Double);
    procedure ObjGrapheur2Point(Sender: TObject; mPoint: TObjPoint;
      mGraphe: TObjGraphe; mCourbe: TObjCourbe; Numero: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    Plot1, Plot2: TObjCourbe;
    Graph1, Graph2: TObjGraphe;
  public
    { Public-dclarations }
  end;

var
  Demo: TDemo;

implementation

{$R *.DFM}

procedure TDemo.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  {   ObjGrapheur1 Initialisation    }
  Plot1 := TObjCourbe.Create;
  for i:=2 to 8 do Plot1.AddPoint(i,i/5,0);

  Graph1 := TObjGraphe.Create(Plot1);
  ObjGrapheur1.AddGraphe(Graph1);
  Graph1.Legende.Caption := 'Plot1';
  Graph1.AddMarker(Plot1.NumberPoint);
  Graph1.AddMarker(1);
  Graph1.DisplayInfoMark := Delta;

  {   ObjGrapheur1 Initialisation    }
  Plot1 := TObjCourbe.Create;
  Plot2 := TObjCourbe.Create;
  for i:=2 to 8 do Plot1.AddPoint(i,i/5,0);
  for i:=0 to 10 do Plot2.AddPoint(i,i/5+1.5,0);

  Graph1 := TObjGraphe.Create(Plot1);
  ObjGrapheur2.AddGraphe(Graph1);
  Graph1.Legende.Caption := 'Plot1';
  Graph2 := TObjGraphe.Create(Plot2);
  ObjGrapheur2.AddGraphe(Graph2);
  Graph2.Legende.Caption := 'Plot2';
  Graph2.AddMarker(Plot2.NumberPoint);

  {   ObjGrapheur3 Initialisation    }
  Plot1 := TObjCourbe.Create;
  Plot2 := TObjCourbe.Create;
  Plot1.AddPoint(3, 7, 140);
  Plot1.AddPoint(1, 1, 24);
  Plot1.AddPoint(4, 8, 200);
  Plot1.AddPoint(2, 5, 74);
  Plot1.AddPoint(5, 10, 300);
  Plot1.AddPoint(2.4, 4, 100);
    {the points are sorted automaticaly}
  for i:=0 to 10 do Plot2.AddPoint(i,i/5+1.5,0);

  Graph1 := TObjGraphe.Create(Plot1);
  ObjGrapheur3.AddGraphe(Graph1);
  Graph1.Legende.Caption := 'Plot1';
  Graph2 := TObjGraphe.Create(Plot2);
  ObjGrapheur3.AddGraphe(Graph2);
  Graph2.Legende.Caption := 'Plot2';

  {   ObjGrapheur4 Initialisation    }
  Plot1 := TObjCourbe.Create;
  Plot2 := TObjCourbe.Create;
  Plot1.AddPoint(3, 7, 140);
  Plot1.AddPoint(1, 1, 24);
  Plot1.AddPoint(4, 8, 200);
  Plot1.AddPoint(2, 5, 74);
  Plot1.AddPoint(5, 10, 300);
  Plot1.AddPoint(2, 2, 74);
    {if there are two identicals points, it's the last which is drawn}
  Plot1.AddPoint(2.4, 4, 100);
  for i:=0 to 10 do Plot2.AddPoint(i,i/5+1.5,0);

  Graph1 := TObjGraphe.Create(Plot1);
  ObjGrapheur4.AddGraphe(Graph1);
  Graph1.Legende.Caption := 'Plot1';
  Graph2 := TObjGraphe.Create(Plot2);
  ObjGrapheur4.AddGraphe(Graph2);
  Graph2.Legende.Caption := 'Plot2';
  Graph2.DefineScale(1, 9, 1, 9);
  Graph2.DefineGraphe(clRed, psDash, clRed, ptCircle);

  {   ObjGrapheur5 Initialisation    }
  Plot1 := TObjCourbe.Create;
  Plot1.AddPoint(3, 7, 150);
  Plot1.AddPoint(1, 1, 25);
  Plot1.AddPoint(4, 8, 200);
  Plot1.AddPoint(2, 5, 75);
  Plot1.AddPoint(5, 10, 300);
  Plot1.AddPoint(2, 2, 75);
  Plot1.AddPoint(2.5, 4, 100);

  Graph1 := TObjGraphe.Create(Plot1);
  ObjGrapheur5.AddGraphe(Graph1);
  Graph1.Legende.Caption := 'Plot1';
  Graph1.AddMarker(Plot1.NumberPoint);
  Graph1.DisplayInfoMark := Coordonnees;

  {   ObjGrapheur6 Initialisation    }
  Plot1 := TObjCourbe.Create;
  Plot1.AddPoint(3, 0.7, 50);
  Plot1.AddPoint(1, 0.1, 10);
  Plot1.AddPoint(4, 0.8, 75);
  Plot1.AddPoint(2, 0.6, 25);
  Plot1.AddPoint(5, 1, 125);
  Plot1.AddPoint(2, 0.2, 25);
  Plot1.AddPoint(2.5, 0.4, 35);

  Graph1 := TObjGraphe.Create(Plot1);
  ObjGrapheur6.AddGraphe(Graph1);
  Graph1.Legende.Caption := 'Plot1';
  Graph1.AddMarker(Plot1.NumberPoint-1);
  Graph1.DisplayInfoMark := Coordonnees;

  {   You can use the new method GetGraphe   }
  Graph2 := ObjGrapheur2.GetGraphe(2);
  Graph2.AddMarker(1);
  Graph2.DisplayInfoMark := Pente;
end;

procedure TDemo.ObjGrapheur1MarkerMove(Sender: TObject;
  mMarker: TObjMarker; mGraphe: TObjGraphe; x, y, dx, dy, Slop,
  X0, Y0: Double);
begin
  XMarker.Caption := 'Marker X = '+FloatToStr(X);
end;

procedure TDemo.ObjGrapheur2Point(Sender: TObject; mPoint: TObjPoint;
  mGraphe: TObjGraphe; mCourbe: TObjCourbe; Numero: Integer);
begin
  XPoint.Caption := 'Point X = '+FloatToStr(mPoint.X);
end;

procedure TDemo.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Plot1.Free;
  Plot2.Free;
  Graph1.Free;
  Graph2.Free;
end;

end.
