{ GMSStickyLabel v1.1 July/5/97  by Glenn Shukster & Jacques Scoatarin

  GMS COMPUTING INC.                 Phone         (905)771-6458
  53 COLVIN CRES.                    Fax                   -6819
  THORNHILL, ONT.                    Compuserve:       72734,123
  CANADA  L4J 2N7                    InternetId:Gms@Shaw.wave.ca
                                      http://members.tor.shaw.wave.ca/~gms/

  Jacques Scoatarin                  Phone (357)2-492591
  52 Athalassis Ave, (flat 202)     InternetId:j.scoatarin@cytanet.com.cy
  Nicosia, Cyprus

Purpose:
  TLabel that will attach to any TWinControl Component on the
  form like TEdit, TDBMemo, TButton etc.  There are other
  components out there that make a label part of the edit or
  memo etc. but they tie you too much to that other component.

Features:
  1) All abilities of TLabel still exist
  2) Works with Delphi 1,2,3.
  3) _AlignTo: The position it will align to the TWinControl (left, right, top, bottom)
  4) _AttachTo: The TWincontrol this label will attach to.
  5) _Gap:     The space between the two components
  6) Right Click: Component editor option
           realigns all TGMSStickyLabels on the form(owner) to their _AttachTo components
  7) Drop Label on any TWinControl and it asks to fill in _AttachTo with that component
  8) Move TWinControl: the label will follow the _AttachTo component

Files:
  GMSLabel.pas : This component
  LblEdit.pas  : Component editor for GMSLabel
  GMSLabel.dcr : In the 16 directory for Delphi 1
  GMSLabel.dcr : In the 32 directory for Delphi 2 & 3

Installation:
  Copy the above pas files and the *.dcr file in the (16 Dir Delphi1)
  or (32 Dir Delphi 2 & 3) into one of the dirs in your component lib
  search path.  Then install gmslabel.pas & lbledit.pas.
  Only GMSStickyLabel will appear on your component pallet under GMS.

Copyright:
  This component is free if you keep this comment header.
  Any damage real or imagined caused by this component is
  100% your responsibility not GMS Computing Inc.'s.

Thank You
  This free component is my way of saying thank you to The Delphi Community.
  People have been more than helpful to me in the forums & newsgroups,
  especially team B members, Wayne Niddery, and Jacques Scoatarin.
  As an example of how great a community we have within a day of sending
  this component out Jacques Scoatarin basically added the lower level api
  calls to enable features 7 & 8 which make the component much more robust.
  Enjoy!

  If you like and use this component e-mail to let me know.
  P.S. GMS Computing Inc.(which is me) is always looking for new contracts.
  If you like what you see then contact me.  See my web page for more details.
}

unit GMSLabel;

interface

uses
  Classes,
  StdCtrls,
  Controls,
  Messages,
  Forms,
  Dialogs,
{$IFDEF WIN32}
  Windows
{$ELSE}
  WinProcs, WinTypes
{$ENDIF}
;

type
  TAlignTo = (alLeft, alTop, alBottom,  alRight);
  TGMSStickyLabel = class(TLabel)
  private
    FAttachTo: TWinControl;
    FAlignTo: TAlignTo;
    FGap : Integer;
    FDefAttachedProc: Pointer;
    FAttachedInstance: Pointer;
    FRealigning: Boolean;
    Procedure SetGap(Value: Integer);
    procedure SetAttachTo(Value: TWinControl);
    Procedure SetAlignTo(Value: TAlignTo);
    { New Attached controls WndProc }
    procedure AttachedWndProc(var Message: TMessage);
  protected
    procedure CheckForControl;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    { Override WndProc }
    procedure WndProc(var Message: TMessage); override;
  public
    Procedure _ReAlign;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property _AlignTo: TAlignTo read FAlignTo write SetAlignTo default alLeft;
    property _AttachTo: TWinControl read FAttachTo write SetAttachTo;
    Property _Gap : Integer Read FGap write SetGap Default 5;
  end;

procedure Register;

implementation

constructor TGMSStickyLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FGap := 5;
  FRealigning := False;
  { Make Instance out of method }
  FAttachedInstance := MakeObjectInstance(AttachedWndProc);
end;

destructor TGMSStickyLabel.Destroy;
begin
  { Restore original Attach Control WndProc }
  {   IsWindow check may be uneccessary but doesn't hurt ti be 100% sure }
  if Assigned(FAttachTo) and IsWindow(FAttachTo.Handle) then
    SetWindowLong(FAttachTo.Handle, GWL_WNDPROC, Longint(FDefAttachedProc));
  { Make method Instance }
  FreeObjectInstance(FAttachedInstance);
  inherited Destroy;
end;

procedure TGMSStickyLabel.AttachedWndProc(var Message: TMessage);
begin
  with Message do
  begin
    case Msg of
      { On Move/Size message call _ReAlign to keep us aligned! }
      WM_MOVE, WM_SIZE : _ReAlign;
    end;
    Result := CallWindowProc(FDefAttachedProc, FAttachTo.Handle, Msg, WParam, LParam);
  end;
end;

procedure TGMSStickyLabel.CheckForControl;
var
  I: Integer;
  RCDest: TRect;
begin
  { if - for not checking if already attached ? }
  { if not Assigned(FAttachTo) then }
  with Owner do
  begin
    for I := 1 to ComponentCount do
    if (Components[I - 1] is TWinControl) and (Components[I - 1] <> Self) then
    with Components[I - 1] as TWinControl do
    begin
      IntersectRect(RCDest, Self.BoundsRect, BoundsRect);
      if not IsRectEmpty(RCDest) then
      begin
        if MessageDlg('Attach label to ' + Name, mtConfirmation, [mbYes, mbNo], 0) = mrYes then
        begin
          _AttachTo := Owner.Components[I - 1] as TWinControl;
          FocusControl := Owner.Components[I - 1] as TWinControl;
        end;
        break;
      end;
    end;
  end;
end;

procedure TGMSStickyLabel.Notification(AComponent: TComponent; Operation: TOperation);
begin
  { dont forget to check if indeed it is FAttachTo that is being removed }
  if (Operation = opRemove) and (AComponent = FAttachTo) then
    FAttachTo := Nil;
  inherited Notification(AComponent,Operation);
end;

procedure TGMSStickyLabel.WndProc(var Message: TMessage);
begin
  with Message do
  begin
    case Msg of
      { On change of position check for controls to attach to }
      WM_WINDOWPOSCHANGED:
        if (not FRealigning) and (csDesigning in ComponentState) then
          CheckForControl;
    end;
  end;
  inherited WndProc(Message);
end;

procedure TGMSStickyLabel.SetAttachTo(Value: TWinControl);
begin
  if (FAttachTo <> Value) then
  begin
    { Restore original previously Attach Control WndProc }
    {   IsWindow check may be uneccessary but doesn't hurt to be 100% sure }
    if Assigned(FAttachTo) and IsWindow(FAttachTo.Handle) then
      SetWindowLong(FAttachTo.Handle, GWL_WNDPROC, Longint(FDefAttachedProc));
    FAttachTo := Value;
    if Assigned(FAttachTo) and IsWindow(FAttachTo.Handle) then
    begin
      { Get original Attach Control WndProc }
      FDefAttachedProc := Pointer(GetWindowLong(FAttachTo.Handle, GWL_WNDPROC));
      { Set the new Attach Control WndProc - our own method! }
      SetWindowLong(FAttachTo.Handle, GWL_WNDPROC, Longint(FAttachedInstance));
    end;
    _ReAlign;
  end;
end;

Procedure TGMSStickyLabel.SetAlignTo(Value: TAlignTo);
begin
  If (FAlignTo <> Value) then
    begin
      FAlignTo := Value;
      _ReAlign;
    end;
end;

Procedure TGMSStickyLabel.SetGap(Value: Integer);
begin
  If (FGap <> Value) Then
    begin
      FGap := Value;
      _ReAlign;
    end;
end;

Procedure TGMSStickyLabel._ReAlign;
var
  iNewTop, iNewLeft: Integer;
begin
  FRealigning := True;
  If FAttachTo <> Nil then
  begin
    Case FAlignTo of
       alLeft:
         begin
          iNewTop :=  FAttachTo.Top;
          iNewLeft := FAttachTo.Left - Width - FGap ;
         end ;
       alRight:
         begin
          iNewTop := FAttachTo.Top;
          iNewLeft := FAttachTo.Left + FAttachTo.Width + FGap ;
         end ;
       alTop:
         begin
          iNewTop := FAttachTo.Top - Height - FGap ;
          iNewLeft := FAttachTo.Left ;
         end;
       alBottom:
         begin
          iNewTop := FAttachTo.Top + FAttachTo.Height + FGap ;
          iNewLeft := FAttachTo.Left ;
         end;
    end;
    { Set all propertied in one call to avoid multiple re-drawing & pos changes }
    SetBounds(iNewLeft, iNewTop, Width, Height);
  end;
  FRealigning := False;
end;

procedure Register;
begin
  RegisterComponents('GMS', [TGMSStickyLabel]);
end;

end.