unit Main;

(*******************************************************************)
(* Glyph Viewer - version 1.1 - 01/11/1995                            *)
(*		by Stephane BONNELL     								   *)
(*																   *)
(*	This program is distributed as freeware.					   *)
(*  But if you like it, please send me an email or a postcard.     *)
(*		EMail: sbonnell@teaser.fr								   *)
(*      SMail: 24 bvd Arago, 75013 Paris, France                   *)
(*******************************************************************)
(*	Main window													   *)
(*******************************************************************)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, ExtCtrls, Menus;

type
  TfmMain = class(TForm)
	SpeedButton1: TSpeedButton;
	SpeedButton2: TSpeedButton;
	SpeedButton3: TSpeedButton;
	SpeedButton4: TSpeedButton;
	SpeedButton5: TSpeedButton;
	SpeedButton6: TSpeedButton;
	SpeedButton7: TSpeedButton;
	SpeedButton8: TSpeedButton;
	SpeedButton9: TSpeedButton;
	SpeedButton10: TSpeedButton;
	SpeedButton11: TSpeedButton;
	SpeedButton12: TSpeedButton;
	SpeedButton13: TSpeedButton;
	SpeedButton14: TSpeedButton;
	SpeedButton15: TSpeedButton;
	SpeedButton16: TSpeedButton;
	SpeedButton17: TSpeedButton;
	SpeedButton18: TSpeedButton;
	SpeedButton19: TSpeedButton;
	SpeedButton20: TSpeedButton;
	SpeedButton21: TSpeedButton;
	SpeedButton22: TSpeedButton;
	SpeedButton23: TSpeedButton;
	SpeedButton24: TSpeedButton;
	SpeedButton25: TSpeedButton;
	SpeedButton26: TSpeedButton;
	SpeedButton27: TSpeedButton;
	SpeedButton28: TSpeedButton;
	SpeedButton29: TSpeedButton;
	SpeedButton30: TSpeedButton;
	SpeedButton31: TSpeedButton;
	SpeedButton32: TSpeedButton;
	SpeedButton33: TSpeedButton;
	SpeedButton34: TSpeedButton;
	SpeedButton35: TSpeedButton;
	SpeedButton36: TSpeedButton;
	SpeedButton37: TSpeedButton;
	SpeedButton38: TSpeedButton;
	SpeedButton39: TSpeedButton;
	SpeedButton40: TSpeedButton;

	BvSButton: TBevel;
	BtNext: TBitBtn;
	BtDisable: TBitBtn;
	dgOpen: TOpenDialog;
	btDir: TBitBtn;
	PMNumGl: TPopupMenu;
	CmNumGlyphs: TMenuItem;
	cm1glyph: TMenuItem;
	cm2Glyph: TMenuItem;
	cm3Glyph: TMenuItem;
	cm4Glyph: TMenuItem;
	cmBreak2: TMenuItem;
	cmCopy: TMenuItem;
	BvForm: TBevel;
	BtInfo: TBitBtn;
	procedure FormCreate(Sender: TObject);
	procedure BtNextClick(Sender: TObject);
	procedure BtDisableClick(Sender: TObject);
	procedure btDirClick(Sender: TObject);
	procedure SpeedButtonDblClick(Sender: TObject);
	procedure SpeedButtonMouseDown(Sender: TObject; Button: TMouseButton;
	  Shift: TShiftState; X, Y: Integer);
	procedure NumClick(Sender: TObject);
	procedure cmCopyClick(Sender: TObject);
	procedure BtInfoClick(Sender: TObject);
  private
	{ Private-dclarations }
	sSearchPath:string;
	sSbName:String;
	procedure Draw;
  public
	{ Public-dclarations }
  end;

var
  fmMain: TfmMain;

implementation

{$R *.DFM}

uses Clipbrd,Info;

var
  tsRes:TSearchRec;

{ fill the speedbuttons with the glyphs}
procedure TfmMain.Draw;
var
	nc:integer;
	bEnd:Boolean;
begin
	bEnd:=False;
	nc:=0;
	while nc<ComponentCount do
	begin
		if Components[nc] is TSpeedButton then
			with Components[nc] as TSpeedButton do
				if not bEnd then
				begin
					Glyph.loadFromFile(sSearchPath+TsRes.Name);
					NumGlyphs:=Glyph.width div 16;
					Hint:=TsRes.Name;
					Visible:=True;
					if FindNext(tsRes)<>0 then
					begin
						FindFirst(sSearchPath+'*.bmp',faAnyFile,TsRes);
						bEnd:=True;
					end;
				end
				else
					Visible:=False;
		inc(nc);
	end;
end;

procedure TfmMain.FormCreate(Sender: TObject);
begin
	if ParamCount=1 then
		sSearchPath:=ParamStr(1)
	else
		sSearchPath:='c:\delphi\images\buttons\';
	if sSearchPath[length(sSearchPath)]<>'\' then
		sSearchPath:=sSearchPath+'\';
	btDir.Hint:=sSearchPath;
	if FindFirst(sSearchPath+'*.bmp',faAnyFile,TsRes)<>0 then
		btDir.Click
	else
		Draw;
end;

procedure TfmMain.BtNextClick(Sender: TObject);
begin
	Draw;
end;

procedure TfmMain.BtDisableClick(Sender: TObject);
var
	nc:integer;
begin
	with btDisable do
		if Tag=0 then
		begin
			Caption:='Enable';
			Hint:='Enable glyphs';
			Tag:=1;
		end
		else
		begin
			Caption:='Disable';
			Hint:='Disable glyphs';
			Tag:=0;
		end;

	nc:=0;
	while nc<ComponentCount do
	begin
		if Components[nc] is TSpeedButton then
			TSpeedButton(Components[nc]).Enabled:=(btDisable.Tag=0);
		inc(nc);
	end;
end;

procedure TfmMain.btDirClick(Sender: TObject);
begin
	repeat
		dgOpen.InitialDir:=sSearchPath;
		dgOpen.FileName:='*.bmp';
		if dgOpen.Execute then
		begin
			sSearchPath:=ExtractFilePath(dgOpen.FileName);
			if sSearchPath[length(sSearchPath)]<>'\' then
				sSearchPath:=sSearchPath+'\';
			btDir.Hint:=sSearchPath;
		end;
	until FindFirst(sSearchPath+'*.bmp',faAnyFile,TsRes)=0;
	Draw;
end;

procedure TfmMain.SpeedButtonDblClick(Sender: TObject);
begin
	ClipBoard.AsText:=sSearchPath+TSpeedButton(Sender).Hint;
end;

procedure TfmMain.SpeedButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
	PtPos: TPoint;
begin
	if Button=mbRight then
	begin
		PtPos:=Point(X,Y);
		PtPos:=TSpeedButton(Sender).ClientToScreen(PtPos);
		sSBName:=TSpeedButton(Sender).Name;
		cm1Glyph.Checked:=False;
		cm2Glyph.Checked:=False;
		cm3Glyph.Checked:=False;
		cm4Glyph.Checked:=False;
		case TSpeedButton(Sender).NumGlyphs of
			1: cm1Glyph.Checked:=True;
			2: cm2Glyph.Checked:=True;
			3: cm3Glyph.Checked:=True;
			4: cm4Glyph.Checked:=True;
		end;
		PMNumGl.Popup(PtPos.X,PtPos.Y);
	end;
end;

procedure TfmMain.NumClick(Sender: TObject);
begin
	TSpeedButton(FindComponent(sSbName)).NumGlyphs:=TMenuItem(Sender).Tag;
end;

procedure TfmMain.cmCopyClick(Sender: TObject);
begin
	ClipBoard.AsText:=sSearchPath+TSpeedButton(FindComponent(sSBName)).Hint;
end;

procedure TfmMain.BtInfoClick(Sender: TObject);
begin
	InfoBox.ShowModal;
end;

end.
