unit GestEdit;


(****Componente TFilterAlignEdit*********************************)
{Spanish Component Free to use and redistribute for DELPHI 1,2,3

Implementacin de un componente heredado de TEdit
que tiene como novedad un filtro, un control de campo
requerido y alineamiento de las palabras en el Edit.

Thanks to Wm. Romano for the idea

For install select GestEdit.Pas...(More information Delphi Manual)

WARNING! THE CODE IS PROVIDED AS IS WITH NO GUARANTEES OF ANY KIND!
USE THIS AT YOUR OWN RISK - YOU ARE THE ONLY PERSON RESPONSIBLE FOR
ANY DAMAGE THIS CODE MAY CAUSE - YOU HAVE BEEN WARNED!

Version 1.0. New version on the next...
Copyright (c), 1997 by David Robledo Fernndez. All Rights Reserved
Please Send me e-mail for bugs or updating
        davidr@roble.pntic.mec.es                                  }
(******************************************************************)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Controls,
  Forms, Dialogs, StdCtrls,Clipbrd;

type
  TValidChar=String;
  TFilterAlignEdit = class(TEdit)
  private
     FAlignment:TAlignment; (*For save Alignment*)
    { Private declarations }
  protected
     FRequired : Boolean; (*If Text is required*)
     FValidch  : TValidChar; (*String Char*)
     ValidChar : set of char; (*like ['A','E','I','O','U']*)
     procedure CreateParams(var Params:TCreateParams); override;
     procedure KeyPress(var Key:Char); override;
     procedure SetAlignment(Value:TAlignment);
     procedure CMEnter(var Msg: TCMGotFocus); message CM_ENTER;
     procedure WMPaste(var Message: TWMPaste);   message WM_PASTE;
     Procedure SetValidCh(Value:TValidChar);
     Procedure SetRequired(Value:Boolean);
     { Protected declarations }
  public
     Procedure DoExit; override;
     Constructor Create(AOwner:TComponent); override;
    { Public declarations }
  published
     Property ValidChars:TValidChar
                  read FValidCh
                  Write SetValidCh;
     Property RequiredField:Boolean
                  read FRequired
                  write SetRequired;
     property Alignment: TAlignment
                  read FAlignment
                  write SetAlignment
                  default taLeftJustify;
     { Published declarations }
  end;

procedure Register;

implementation

Constructor TFilterAlignEdit.Create(AOwner:TComponent);
begin
     inherited Create(AOwner);
     FValidCh:='[]';
     FRequired:=False;
     FAlignment:=taLeftJustify;
end;

Procedure TFilterAlignEdit.SetRequired(Value:Boolean);
Begin
     if Value<>FRequired then FRequired:=Value;
end;

procedure TFilterAlignEdit.DoExit;
begin
  inherited DoExit;
  if (FRequired) and (Text = '') then
  Begin
       MessageDlg(' Es obligatorio rellenar este campo! ',mtWarning, [mbOK],0);
       SetFocus;
  end;
end ;

Procedure TFilterAlignEdit.SetValidCh(Value:TValidChar);
var  vc3 :  set of char;
     x   :  integer;
     ch1,ch2,ch3 : char;
     SetRange    :  boolean;

     Procedure MakeSet;
     Begin
          if SetRange then vc3:=[ch1..ch2]
             else vc3:=[ch1];
          validchar:=validchar+vc3;
          ch1:=#0;ch2:=#0;ch3:=#0;
          SetRange:=False;
     End;

Begin {SetValidCh}
      SetRange:=False;
      if Value<>FValidCh then
      BEGIN
           FValidCh:=Value;
           if (FValidCh[1]='[') and (FValidCh[length(FValidCh)]=']' )then
              For x:=2 to length(FValidCh) do
              begin
                   ch3:=FValidCh[x];
                   if (ch3=',') or (ch3=']') then MakeSet;
                   if ch3='.' then SetRange:=True;
                   if ch3='''' then ch3:=FValidCh[x+1];
                   if (SetRange=False) then ch1:=ch3
                      else ch2:=ch3;
              end
           else FValidCh:='Formato invlido'+ FValidCh;
      end;(*BEGIN*)
end;

 procedure TFilterAlignEdit.KeyPress(Var Key: Char);
 begin
      if ValidChar <>[] then
      if (NOT (Key in ValidChar)) and (Key<>#08) then  Key:=#0;
      inherited KeyPress(Key);
      if (Key=#13) or (Key=#10) then Key:=#0;
 end;

procedure TFilterAlignEdit.CreateParams(var Params: TCreateParams);
const Alignments: array[TAlignment] of Longint=(ES_LEFT,ES_RIGHT,ES_CENTER);
begin
     inherited CreateParams(Params);
     Params.Style:=Params.Style or ES_MULTILINE or Alignments[FAlignment];
end;

procedure TFilterAlignEdit.SetAlignment(Value:TAlignment);
begin
     if FAlignment<>Value then
     begin
        FAlignment:=Value;
        RecreateWnd;
     end;
end;

procedure TFilterAlignEdit.CMEnter(var Msg:TCMGotFocus);
begin
  if AutoSelect and not (csLButtonDown in ControlState) then SelectAll;
  inherited;
end;

procedure TFilterAlignEdit.WMPaste(var Message: TWMPaste);
var SGlobalHandel  :THandle;
    Ptr            :PChar;
    Size           :Longint;
    i              :Longint;
    s              :string;
begin
     s:='';
     if OpenClipboard(Handle) then
     try
        if Clipboard.HasFormat(CF_TEXT) then
        begin
           SGlobalHandel:=GetClipboardData(CF_TEXT);
           if SGlobalHandel<>0 then
           begin
                Size:=GlobalSize(SGlobalHandel);
                Ptr :=GlobalLock(SGlobalHandel);
                if Ptr<>nil then begin
                   i:=0;
                   while (i<size) and (Ptr[i]>=#32) do begin
                         s:=s+Ptr[i];
                         inc(i);
                   end;(*While*)
                end;(*If*)
                GlobalUnlock(SGlobalHandel);
           end;
        end;(*If ClipBoard tiene TEXT_FORMAT*)
     finally
        CloseClipboard;
     end;
     SelText:=s;
end;


procedure Register;
begin
  RegisterComponents('Gesticon', [TFilterAlignEdit]);
end;


end.
