unit Bmpfind;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, FileCtrl, Buttons, inifiles, Menus;

type
  TbmpFinder = class(TForm)
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    FilterComboBox1: TFilterComboBox;
    Panel1: TPanel;
    ScrollBox1: TScrollBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Image: TImage;
    Edit1: TEdit;
    DirHistory: TComboBox;
    PopupMenu1: TPopupMenu;
    Delete1: TMenuItem;
    Add1: TMenuItem;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    procedure FileListBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Add1Click(Sender: TObject);
    procedure DirHistoryChange(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
  private
    { Private declarations }
    dirs : TStringList;

    procedure AddDirectory(s : string);
  public
    { Public declarations }
  end;

var
  bmpFinder: TbmpFinder;

implementation
uses add_dir,bmpabout;

{$R *.DFM}

procedure TbmpFinder.FileListBox1Change(Sender: TObject);
begin
  if FileExists(FileListBox1.FileName) then
    begin
      image.picture.loadFromFile(FileListBox1.FileName);
      ScrollBox1.HorzScrollBar.Range:=image.picture.width;
      ScrollBox1.VertScrollBar.Range:=image.picture.height;
      ScrollBox1.HorzScrollBar.position:=0;
      ScrollBox1.VertScrollBar.position:=0;

      if image.picture.bitmap<>nil then
        if image.picture.bitmap.empty then
          BitBtn4.enabled:=FALSE
        else
          BitBtn4.enabled:=TRUE;
    end;
end;

procedure TbmpFinder.AddDirectory(s : string);
begin
  DirHistory.items.add(copy(s,1,pos('=',s)-1));
end;

procedure TbmpFinder.FormCreate(Sender: TObject);
var
  DelphiIni : TIniFile;
  i         : integer;

begin
  dirs:=TStringList.Create;
  DelphiIni := TIniFile.Create('delphi.ini');
  DelphiIni.ReadSectionValues('DanielsBMPfinder', Dirs);
  DelphiIni.Free;
end;

procedure TbmpFinder.Add1Click(Sender: TObject);
begin
  addDir:=TAddDir.Create(Application);
  try
    addDir.Dir.text:=DirectoryListBox1.Directory;
    addDir.DirName.clear;
    if addDir.ShowModal=mrOK then
      begin
        Dirs.values[addDir.DirName.text]:=addDir.Dir.text;
        AddDirectory(Dirs.strings[Dirs.count-1]);
        dirHistory.ItemIndex:=dirs.count-1;
      end;
  finally
    addDir.Free;
  end;
end;

procedure TbmpFinder.DirHistoryChange(Sender: TObject);
begin
  if DirHistory.text<>'' then
    DirectoryListbox1.Directory:=Dirs.values[DirHistory.text];
end;

procedure TbmpFinder.Delete1Click(Sender: TObject);
begin
  DirHistory.items.delete(DirHistory.itemIndex);
end;

procedure TbmpFinder.FormClose(Sender: TObject; var Action: TCloseAction);
var
  DelphiIni : TIniFile;
  i         : integer;

begin
  DelphiIni := TIniFile.Create('delphi.ini');

  DelphiIni.EraseSection('DanielsBMPfinder');

  for i:=0 to Dirs.count-1 do
    DelphiIni.WriteString('DanielsBMPfinder',
                          DirHistory.items.Strings[i],
                          Dirs.values[DirHistory.items.strings[i]]);

  DelphiIni.Free;
end;

procedure TbmpFinder.FormDestroy(Sender: TObject);
begin
  dirs.Free;
end;

procedure TbmpFinder.FormShow(Sender: TObject);
var
  i : integer;

begin
  DirHistory.Clear;

  for i:=0 to dirs.count-1 do
    AddDirectory(dirs.strings[i]);

  if dirs.count<>0 then
    begin
      DirHistory.ItemIndex:=0;
      if DirHistory.text<>'' then
        DirectoryListbox1.Directory:=Dirs.values[DirHistory.text];
    end;

  if image.picture.bitmap<>nil then
    if image.picture.bitmap.empty then
      BitBtn4.enabled:=FALSE
    else
      BitBtn4.enabled:=TRUE;
end;

procedure TbmpFinder.BitBtn3Click(Sender: TObject);
begin
  bmpAboutWindow:=TbmpAboutWindow.Create(Application);
  try
    bmpAboutWindow.ShowModal;
  finally
    bmpAboutWindow.Free;
  end;
end;

procedure TbmpFinder.BitBtn4Click(Sender: TObject);
var
  temp : TBitmap;

begin
  if image.picture.bitmap<>nil then
    begin
{      image.picture.bitmap.free;
      image.picture.bitmap:=TBitmap.Create;
}
      temp:=TBitmap.Create;
      image.picture.bitmap.assign(temp);
      temp.free;
{      image.picture.bitmap.width:=0;
      image.picture.bitmap.height:=0;}

      BitBtn4.enabled:=FALSE;
    end;
end;

end.
