unit Crypt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs;

const
   BlockSize = $4000;

type

   pBuf = ^tBuf;
  tBuf = array[1..BlockSize] of byte;

  TCryptFile = class(TComponent)
  private
    { Private declarations }
    FInFile   : String;
    FOutFile  : String;
    FKey      : LongInt;    { numb. password  }
    FIntKey   : LongInt;    { internal key    }
    FPassword : string;     { string password }
    sour      : tFileRec;
    targ      : tFileRec;
    buf       : pBuf;
    nRead     : integer;
    nWritten  : integer;
    Over      : boolean;  { overwrite flag }
    procedure WriteFPassword(value : string);
    procedure WriteFIntKey(value : LongInt);
    procedure InitKey;
    function  CheckTarget : boolean;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure Encrypt;
    procedure Decrypt;
  published
    { Published declarations }
    property Infile : string read FInFile write FInFile;
    property Outfile : string read FOutFile write FOutFile;
    property Password : string read FPassword write WriteFPassword;
    property IntKey : longInt read FIntKey write WriteFIntKey;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Custom', [TCryptFile]);
end;

constructor TCryptFile.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
   Over     := false;
   IntKey   := 31121999;
   Password := '';
end;

procedure TCryptFile.WriteFPassword(value : string);
begin
   if length(value) > 4 then
   begin
      ShowMessage('Max. length 4 characters');
      exit;
   end;
   FPassword := value;
end;

procedure TCryptFile.WriteFIntKey(value : LongInt);
begin
   if (value = 0) or (value = $FFFFFFFF) then
   begin
      ShowMessage('Value not allowed');
      exit;
   end;
   FIntKey := value;
end;

procedure TCryptFile.InitKey;
var
   cbuf : array[0..4] of char;
begin
   if FPassword = '' then FKey := 0
   else
   begin
      fillChar(cbuf, SizeOf(cbuf), #0);
      StrPCopy(cbuf,FPassword);
      move(cbuf,FKey,sizeOf(FKey));
   end;
   { set random generator }
   RandSeed := FKey;
end;



function TCryptFile.CheckTarget : boolean;
   procedure CheckOver;
   begin
      if FInFile = FOutFile then
      begin
         Over := true;
         FOutFile := ExtractFilePath(FOutFile) + '___.~--';
      end;
   end;
begin
   { if overWrite ... }
   CheckOver;
   { ... then erase FOutFile }
   if over then
   begin
      if fileExists(FOutFile) then
      begin
         Targ.handle := fileOpen(FOutFile, fmOpenWrite);
         fileSeek(Targ.handle, 0, 0);
      end
      else Targ.handle := FileCreate(FOutFile);
      CheckTarget := True;
      exit;
   end;
   if fileExists(FOutFile) then
   begin
      if MessageDlg('The target file : ' +  ExtractFileName(FOutFile) +
                    chr (13) + 'already exists.' + chr(13) +
                    'Any data will be lost.' + chr(13) +
                    chr(13) + 'Proceed ?'
                    ,mtWarning, [mbYes, mbNo], 0) = mrNo then
      begin
         FileClose(Sour.handle);
         CheckTarget := false;
         exit;
      end
      else
      begin
         Targ.handle := fileOpen(FOutFile, fmOpenWrite);
         fileSeek(Targ.handle, 0, 0);
      end;
   end
   else
       Targ.handle := FileCreate(FOutFile);
   CheckTarget := True;
end;


procedure TCryptFile.Encrypt;
var
  cont     : word;
begin
   { checking target file }
   if not CheckTarget then exit;
   new(buf);
   { setting up key }
   InitKey;
   { opening source file }
   Sour.handle := fileOpen(FInfile, fmOpenRead);
   { encoding by internal key }
   inc(FKey, FIntKey);
   nWritten := FileWrite(Targ.Handle, FKey, SizeOf(FKey));
   repeat
   begin
      nRead := FileRead(Sour.Handle,Buf^, sizeOf(buf^));
      { encrypting }
      for cont := 1 to nRead do inc(buf^[cont], random(10));
      nWritten := FileWrite(Targ.Handle, Buf^, nRead);
   end;
   until (nRead = 0) or (nWritten <> nRead);
   Dispose(buf);
   FileClose(Sour.handle);
   FileClose(Targ.handle);
   { if overwrite renames FOutFile with the right name }
   if over then
   begin
      DeleteFile(FInFile);
      RenameFile(FOutFile, FInFile);
   end;
end;

procedure TCryptFile.Decrypt;
var
    cont    : word;
    FileKey : longInt;
begin
   { checking target file }
   if not CheckTarget then exit;
   new(buf);
   { setting up key }
   InitKey;
   { opening source file }
   Sour.handle := fileOpen(FInfile, fmOpenRead);
   { checking password }
   nRead := FileRead(Sour.Handle,FileKey, sizeOf(FileKey));
   { decoding by internal key }
   dec(FileKey, FIntKey);
   if FileKey <> FKey then
   begin
      Dispose(buf);
      FileClose(Sour.handle);
      FileClose(Targ.handle);
      if over then DeleteFile(FOutFile);
      ShowMessage('Bad password !');
      exit;
   end;
   repeat
   begin
      nRead := FileRead(Sour.Handle,Buf^, sizeOf(buf^));
      { decrypting }
      for cont := 1 to nRead do dec(buf^[cont], random(10));
      nWritten := FileWrite(Targ.Handle, Buf^, nRead);
   end;
   until (nRead = 0) or (nWritten <> nRead);
   Dispose(buf);
   FileClose(Sour.handle);
   FileClose(Targ.handle);
   { if overwrite renames FOutFile with the right name }
   if over then
   begin
      DeleteFile(FInFile);
      RenameFile(FOutFile, FInFile);
   end; 
end;

end.
