unit FxRtns;

interface
uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
     Controls, StdCtrls, ExtCtrls, Forms, Tabs, Buttons;


procedure PaintEffect(TheEffect:byte; src,dst:TCanvas; BoxWidth:byte);


(**)	implementation	 (**)
const pin : array[1..9,1..2] of byte =
			   	((2,2),(2,1),(3,1),
                (3,2),(3,3),(2,3),
				(1,3),(1,2),(1,1));

type PLinRec = ^LinRec;
	LinRec = record
		hor : boolean;
        lin : byte;
	 end;

type PBlockRec = ^BlockRec;
	BlockRec = record
    	x,y : byte;
    end;


procedure PaintEffect;
var x,y,i,j,k,m,xx,yy,q : byte;
	x2,y2,x3,y3,x4,y4: byte;
	mid,midx,midy : byte;
	cnt,pix : word;
	bound,bounds2 : TRect;
    LinList: TList;
    Lin : PLinRec;
    Block : PBlockRec;
    canwid,canhei : word;
    BoxAcross, BoxDown : byte;

    procedure DrawBox(x1,y1:byte);
	var TheRect : TRect;
		l,t,r,b : word;
	begin
    	l := (x1-1)*BoxWidth;
	    t := (y1-1)*BoxWidth;
    	r := x1*BoxWidth;
	    b := y1*BoxWidth;
    	if r>canwid then r:= canwid;
	    if b>canhei then b:=canhei;
    	TheRect := Rect(l,t,r,b);
  		dst.CopyRect(TheRect,src,TheRect);
    end;


    function GetHorLine(bline:byte): TRect;
	var l,t,r,b : word;
	begin
    	l := 0;
	    t := (bline-1)*BoxWidth;
    	r:= canwid;
	    b := bline*BoxWidth;
    	if b>canhei then b:=canhei;
		GetHorLine := Rect(l,t,r,b);
	end;

begin
    bound := src.ClipRect;
    canwid := bound.right-bound.left+1;
    canhei := bound.bottom-bound.top+1;
    BoxAcross := Trunc(Int(canwid/BoxWidth));
    if (canwid mod BoxWidth)<>0 then Inc(BoxAcross);
    BoxDown := Trunc(Int(canhei/BoxWidth));
    if (canhei mod BoxWidth)<>0 then Inc(BoxDown);
	case TheEffect of
    0 : dst.CopyRect(src.ClipRect,src,src.ClipRect);
    1 : for i:=1 to BoxAcross do
			for q:=1 to BoxDown do DrawBox(i,q);
    2 : for i:=BoxAcross downto 1 do
    		for q:=1 to BoxDown do DrawBox(i,q);
    3 : for i:=1 to BoxDown do
    		for q:=1 to BoxAcross do DrawBox(q,i);
    4 : for i:=BoxDown downto 1 do
    		for q:=1 to BoxAcross do DrawBox(q,i);
    5 : begin
			k := Round(BoxAcross / 2);
		    for i:=0 to k do begin
            	for q:=1 to BoxDown do DrawBox(i+1,q);
                for q:=1 to BoxDown do DrawBox(BoxAcross-i,q);
			end;
    	end;
    6 : begin
    		k := Round(BoxAcross / 2);
    		for i:=k to BoxAcross do begin
				for q:=1 to BoxDown do DrawBox(i,q);
        		j := BoxAcross-i;
				if j>0 then for q:=1 to BoxDown do DrawBox(j,q);
			end;
    	end;
    7 : begin
		    k := Round(BoxDown / 2);
    		for i:=0 to k do begin
				for q:=1 to BoxAcross do DrawBox(q,i+1);
				for q:=1 to BoxAcross do DrawBox(q,BoxDown-i);
			end;
    	end;
    8 : begin
    		k := Round(BoxDown / 2);
    		for i:=k to BoxDown do begin
            	for q:=1 to BoxAcross do DrawBox(q,BoxDown-i);
				for q:=1 to BoxAcross do DrawBox(q,i);
    	    	j:=BoxDown-i;
				if j>0 then for q:=1 to BoxAcross do DrawBox(q,j);
			end;
    	end;
    9 : begin
		    for x:=1 to BoxAcross do begin
	    		j:= (BoxAcross+1)-x;
	    		y := 1;
    			while y<=BoxDown do begin
		       		DrawBox (x,y);
            		if y<BoxDown then DrawBox (j,y+1);
	        	    inc(y,2);
    		    end;
		    end;
    	end;
    10: begin
    		for y:=1 to BoxDown do begin
           		j:= (BoxDown+1)-y;
               	x := 1;
               	while x<=BoxAcross do begin
                	DrawBox (x,y);
                   	if x<BoxAcross then DrawBox (x+1,j);
                   	inc(x,2);
               	end;
           	end;
    	end;
    11: begin
		    for k:=1 to 2 do begin
	    		for x:=1 to BoxAcross do begin
		    		y := k;
    				while y<=BoxDown do begin
        				DrawBox (x,y);
			            inc(y,2);
    			    end;
			    end;
		    end;
    	end;
    12: begin
		    for k:=1 to 2 do begin
	    		for y:=1 to BoxDown do begin
	    			x := k;
    				while x<=BoxAcross do begin
        				DrawBox (x,y);
		    	        inc(x,2);
    		    	end;
			    end;
		    end;
    	end;
    13: begin
    		for x:=1 to BoxAcross do begin
    			y := 1;
		    	while y<=BoxDown do begin
        			DrawBox (x,y);
		            inc(y,2);
        		end;
		    end;
		    for x:=BoxAcross downto 1 do begin
    			y := 2;
		    	while y<=BoxDown do begin
        		    DrawBox (x,y);
		            inc(y,2);
        		end;
            end;
    	end;
    14: begin
		    for y:=1 to BoxDown do begin
    			x := 1;
		    	while x<=BoxAcross do begin
        			DrawBox (x,y);
		            inc(x,2);
		        end;
		    end;
		    for y:=BoxDown downto 1 do begin
    			x := 2;
		    	while x<=BoxAcross do begin
        			DrawBox (x,y);
		            inc(x,2);
        		end;
		    end;
    	end;
    15: begin
		    for i:=1 to BoxWidth do begin
    			pix := i-1;
                bounds2 := src.ClipRect;
                canhei := bounds2.bottom-bounds2.top+1;
		    	while pix <= canhei do begin
		    		Bound := Rect(0,pix,bounds2.right-bounds2.left+1,pix+1);
					dst.CopyRect(Bound,src,Bound);
		            inc(pix,BoxWidth);
		        end;
		    end;
    	end;
    16: begin
		    for i:=1 to BoxWidth do begin
		    	pix := i-1;
                bounds2 := src.ClipRect;
                canwid := bounds2.right-bounds2.left+1;
    			while pix <= canwid do begin
    				Bound := Rect(pix,0,pix+1,bounds2.bottom-bounds2.top+1);
					dst.CopyRect(Bound,src,Bound);
        		    inc(pix,BoxWidth);
		        end;
		    end;
    	end;
    17: begin
		    for i:=1 to BoxWidth do begin
		    	pix := i-1;
                bounds2 := src.ClipRect;
                canwid := bounds2.right-bounds2.left+1;
                canhei := bounds2.bottom-bounds2.top+1;
    			while (pix<=canhei) or (pix<=canwid) do begin
		        	bounds2 := src.ClipRect;
    				Bound := Rect(pix,0,pix+1,bounds2.Bottom-Bounds2.top+1);
					dst.CopyRect(Bound,src,Bound);
    				Bound := Rect(0,pix,bounds2.right-bounds2.left+1,pix+1);
					dst.CopyRect(Bound,src,Bound);
        		    inc(pix,BoxWidth);
		        end;
		    end;
	   	end;
    18: begin
    		x:=0; y:=1;
    		while (x<BoxAcross) or (y<BoxDown) do begin
    			inc(x);
        		if x>BoxAcross then begin
        			x:=BoxAcross;
            		if y<BoxDown then inc(y);
            	end;
    			i:=x;	 j:=y;
        		while true do begin
        			DrawBox(i,j);
            		dec(i); inc(j);
        	    	if (i<1) or (j>BoxDown) or (i>BoxAcross) then break;
        		end;
    		end;
    	end;
    19: begin
    		x:=1; y:=BoxDown+1;
    		while (x<BoxAcross) or (y<1) do begin
    			dec(y);
        		if y<1 then begin
		        	y:=1;
        		    if x<BoxAcross then inc(x);
		        end;
		    	i:=x;	 j:=y;
        		while true do begin
		        	DrawBox(i,j);
        		    inc(i); inc(j);
		            if (j>BoxDown) or (j<1) or (i>BoxAcross) then break;
        		end;
		    end;
    	end;
    20: begin
    		x:=BoxAcross+1; y:=1;
		    while (x>1) or (y<BoxDown) do begin
		    	dec(x);
        		if x<1 then begin
		        	x:=1;
        		    if y<BoxDown then inc(y);
		        end;
		    	i:=x;	 j:=y;
		        while true do begin
        			DrawBox(i,j);
		            inc(i); inc(j);
        		    if (j>BoxDown) or (i<1) or (i>BoxAcross) then break;
		        end;
		    end;
    	end;
    21: begin
    		x:=BoxAcross; y:=BoxDown+1;
		    while (x>1) or (y>1) do begin
    			dec(y);
		        if y<1 then begin
        			y:=1;
		            if x>1 then dec(x);
		        end;
    			i:=x;	 j:=y;
		        while true do begin
        			DrawBox(i,j);
	            	dec(i); inc(j);
    	        	if (j>BoxDown) or (i<1) or (j<1) then break;
        		end;
		    end;
    	end;
    22: begin
    		x:=0; y:=1;	xx:=BoxAcross; yy:=BoxDown+1;
    		while ((x<BoxAcross) or (y<BoxDown)) and
          		((xx>1) or (yy>1))	do
            begin
		    	inc(x); dec(yy);
        		if x>BoxAcross then begin
		        	x:=BoxAcross;
        		    if y<BoxDown then inc(y);
		        end;
		        if yy<1 then begin
        			yy:=1;
		            if xx>1 then dec(xx);
        		end;
		    	i:=x;	 j:=y;
        		while true do begin
		        	DrawBox(i,j);
        		    dec(i); inc(j);
		            if (i<1) or (j>BoxDown) or (i>BoxAcross) then break;
        		end;
		    	i:=xx;	 j:=yy;
		        while true do begin
        			DrawBox(i,j);
		            dec(i); inc(j);
        		    if (j>BoxDown) or (i<1) or (j<1) then break;
		        end;
		    end;
    	end;
    23: begin
    		x:=BoxAcross+1; y:=1; xx:=1; yy:=BoxDown+1;
		    while ((x>1) or (y<BoxDown)) and
    		  ((xx<BoxAcross) or (yy<1)) do
		    begin
		    	dec(x);
        		if x<1 then begin
		        	x:=1;
        		    if y<BoxDown then inc(y);
		        end;
		    	dec(yy);
		        if yy<1 then begin
        			yy:=1;
		            if xx<BoxAcross then inc(xx);
        		end;
		    	i:=x;	 j:=y;
		        while true do begin
        			DrawBox(i,j);
		            inc(i); inc(j);
        		    if (j>BoxDown) or (i<1) or (i>BoxAcross) then break;
		        end;
		    	i:=xx;	 j:=yy;
        		while true do begin
		        	DrawBox(i,j);
        		    inc(i); inc(j);
		            if (j>BoxDown) or (j<1) or (i>BoxAcross) then break;
        		end;
		    end;
    	end;
    24: begin
    		if BoxAcross>BoxDown then mid:=BoxDown else mid:=BoxAcross;
		    x:=mid+1; y:=1;	xx:=mid-1; yy:=1;
		    while ((x>1) or (y>1)) or
        		  ((xx<BoxAcross) or (yy<BoxDown)) do
		    begin
		    	dec(x); inc(xx);
        		if x<1 then begin
		        	x:=1;
        		    if y>1 then dec(y);
		        end;
		        if xx>BoxAcross then begin
        			xx:=BoxAcross;
		            if yy<BoxDown then inc(yy);
        		end;
		    	i:=x;	 j:=y;
		        while true do begin
        			DrawBox(i,j);
		            dec(i); inc(j);
        		    if (i<1) or (j>BoxDown) or (i>BoxAcross) then break;
		        end;
		    	i:=xx;	 j:=yy;
        		while true do begin
		        	DrawBox(i,j);
	        	    dec(i); inc(j);
    		        if (j>BoxDown) or (i<1) or (j<1) then break;
		        end;
		    end;
    	end;
    25: begin
		    if BoxAcross>BoxDown then mid:=BoxDown else mid:=BoxAcross;
		    mid := BoxAcross-mid;
		    x:=mid+1; y:=1; xx:=mid-1; yy:=1;
		    while ((x>1) or (y<BoxDown)) or
    		  ((xx<BoxAcross) or (yy>1)) do
		    begin
		    	dec(x);
		        if x<1 then begin
        			x:=1;
		            if y<BoxDown then inc(y);
		        end;
		    	inc(xx);
		        if xx>BoxAcross then begin
        			xx:=BoxAcross;
		            if yy>1 then dec(yy);
        		end;
		    	i:=x;	 j:=y;
        		while true do begin
		        	DrawBox(i,j);
        		    inc(i); inc(j);
		            if (j>BoxDown) or (i<1) or (i>BoxAcross) then break;
        		end;
		    	i:=xx;	 j:=yy;
        		while true do begin
		        	DrawBox(i,j);
        		    inc(i); inc(j);
		            if (j>BoxDown) or (j<1) or (i>BoxAcross) then break;
        		end;
		    end;
    	end;
    26: begin
    		midx := Round(BoxAcross/2);
		    midy := Round(BoxDown/2);
		    x:=0; y:=1;	x2:=BoxAcross; y2:=BoxDown+1;
		    x3:=BoxAcross+1; y3:=1; x4:=1; y4:=BoxDown+1;
		    while ((x<midx) or (y<midy)) or
        		  ((x2>midx) or (y2>midy)) or
		          ((x3>midx) or (y3<midy)) or
    			  ((x4<midx) or (y4<midy)) do
		    begin
    			inc(x);
		        if x>midx then begin
        			x:=midx;
		            if y<midy then inc(y);
        		end;
		        dec(y2);
        		if y2<midy then begin
		        	y2:=midy;
        		    if x2>midx then dec(x2);
		        end;
    			dec(x3);
		        if x3<midx then begin
        			x3:=midx;
		            if y3<midy then inc(y3);
        		end;
		    	dec(y4);
        		if y4<midy then begin
		        	y4:=midy;
    		        if x4<BoxAcross then inc(x4);
		        end;
    			i:=x;	 j:=y;
		        while true do begin
        			DrawBox(i,j);
		            dec(i); inc(j);
        		    if (i<1) or (j>midy) or (i>midx) then break;
		        end;
		    	i:=x2;	 j:=y2;
		        while true do begin
        			DrawBox(i,j);
		            dec(i); inc(j);
        		    if (j>BoxDown) or (i<midx) or (j<midy) then break;
		        end;
		    	i:=x3;	 j:=y3;
        		while true do begin
		        	DrawBox(i,j);
        		    inc(i); inc(j);
		            if (j>BoxDown) or (i<1) or (i>BoxAcross) then break;
        		end;
		    	i:=x4;	 j:=y4;
        		while true do begin
		        	DrawBox(i,j);
        		    inc(i); inc(j);
		            if (j>BoxDown) or (j<1) or (i>BoxAcross) then break;
        		end;
		    end;
    	end;
    27: begin
    		midx := Round(BoxAcross/4);
		    for i:=1 to BoxDown do begin
    			for j:=1 to midx do begin
		        	DrawBox(j,i);
        		    DrawBox(midx+j,(BoxDown+1)-i);
		        	DrawBox((midx*2)+j,i);
        		    DrawBox((midx*3)+j,(BoxDown+1)-i);
		        end;
		    end;
    	end;
    28: begin
		    midy := Round(BoxDown/4);
		    for i:=1 to BoxAcross do begin
    			for j:=1 to midy do begin
		        	DrawBox(i,j);
        		    DrawBox((BoxAcross+1)-i,midy+j);
		        	DrawBox(i,(midy*2)+j);
        		    DrawBox((BoxAcross+1)-i,(midy*3)+j);
		        end;
		    end;
    	end;
    29: begin
    		midx := Round(BoxAcross/2);
		    for i:=1 to BoxDown do begin
    			for j:=1 to midx do begin
		        	DrawBox(j,i);
        		    DrawBox(midx+j,(BoxDown+1)-i);
		        end;
		    end;
    	end;
    30: begin
		    midy := Round(BoxDown/2);
		    for i:=1 to BoxAcross do begin
    			for j:=1 to midy do begin
		        	DrawBox(i,j);
        		    DrawBox((BoxAcross+1)-i,midy+j);
		        end;
		    end;
    	end;
    31: begin
		    midx := Round(BoxAcross/2);
		    midy:= Round(BoxDown/2);
		    for i:=1 to midy+1 do begin
    			for j:=1 to midx do begin
		        	DrawBox(j,i);
        		    DrawBox(j,midy+i);
		            DrawBox(midx+j,(BoxDown+1)-i-midy);
        		    DrawBox(midx+j,(BoxDown+1)-i);
		        end;
		    end;
    	end;
    32: begin
			y := Round(BoxDown/3);
		    yy := y*2;
		    midx := Round(BoxAcross/2);
		    for i:=1 to midx do begin
    			for j:=y to yy do begin
		        	DrawBox(midx+1-i,j);
        		    DrawBox(midx+i,j);
		        end;
		    end;
		    for i:=1 to y do begin
    			for j:=1 to BoxAcross do begin
		    		DrawBox(j,y+1-i);
        			DrawBox(j,yy+i);
		        end;
		    end;
    	end;
    33: begin
		    y := Round(BoxDown/3);
		    yy := y*2;
		    midx := Round(BoxAcross/2);
		    for i:=1 to y do begin
    			for j:=1 to BoxAcross do begin
		    		DrawBox(j,i);
        			DrawBox(j,BoxDown+1-i);
		        end;
		    end;
		    for i:=1 to midx+1 do begin
    			for j:=y to yy+1 do begin
		        	DrawBox(i,j);
        		    DrawBox(BoxAcross+1-i,j);
		        end;
		    end;
    	end;
    34: begin
			LinList := TList.Create;
			for i:=1 to BoxAcross do begin
    			New(Lin);
		        Lin^.hor := False;
        		Lin^.lin := i;
		        LinList.Add(Lin);
		    end;
			for i:=1 to BoxDown do begin
    			New(Lin);
		        Lin^.hor := True;
        		Lin^.lin:= i;
		        LinList.Add(Lin);
		    end;
		    (**)
		    repeat
        		k := LinList.Count;
		        j := Round(Random(k));
        		if PLinRec(LinList.Items[j])^.hor
                	then for q:=1 to BoxAcross do DrawBox(q,PLinRec(LinList.Items[j])^.lin)
                	else for q:=1 to BoxAcross do DrawBox(q,PLinRec(LinList.Items[j])^.lin);
		        Dispose(LinList.Items[j]);
        		LinList.Delete(j);
		    until k=1;
		    LinList.Free;
    	end;
    35: begin
    		LinList := TList.Create;
			for i:=1 to BoxAcross do begin
    			for j:=1 to BoxDown do begin
			    	New(Block);
        			Block^.x := i;
		        	Block^.y := j;
        			LinList.Add(Block);
		        end;
		    end;
		    (**)
		    repeat
        		cnt := LinList.Count;
		        pix := Round(Random(cnt));
		        DrawBox(PBlockRec(LinList.Items[pix])^.x,
        				PBlockRec(LinList.Items[pix])^.y);
		        Dispose(LinList.Items[pix]);
        		LinList.Delete(pix);
		    until cnt=1;
		    LinList.Free;
    	end;
    36: begin
		    for k:=0 to 1 do begin
			    j:=1;
        		while j<=BoxDown do begin
			        i:=(j mod 2)+k;
    				while i<=BoxAcross do begin
		        		DrawBox(i,j);
	    		    	inc(i,2);
		    	    end;
        		    inc(j);
			    end;
		    end;
    	end;
    37: begin
		    for i:=BoxDown downto 1 do begin
		    	bound := GetHorLine(i);
        		for k:=1 to i do begin
					bounds2 := GetHorLine(k);
					dst.CopyRect(bounds2,src,bound);
		        end;
		    end;
    	end;
    38: begin
		    for k:=1 to 9 do begin
		    	i:=pin[k,1];
        		while i<=BoxAcross do begin
		        	j:=pin[k,2];
	    		    while j<=BoxDown do begin
            			DrawBox(i,j);
		                inc(j,3);
        		    end;
		            inc(i,3);
		        end;
		    end;
    	end;
    39: begin
		    x:=1; y:=1; xx:=BoxAcross; yy:=BoxDown;
		    while x<xx do begin
    			for i:=x to xx do DrawBox(i,y);
		        for i:=y to yy do DrawBox(xx,i);
        		for i:=xx downto x do DrawBox(i,yy);
		        for i:=yy downto y do DrawBox(x,i);
        		inc(x); inc(y); dec(xx); dec(yy);
		    end;
    	end;
    40: begin
    		for k:=1 to 2 do begin
				y:=k;
    			while y<=BoxDown do begin
            		if (y mod 2)=1
                    then for x:=1 to BoxAcross do DrawBox(x,y)
                    else for x:=BoxAcross downto 1 do DrawBox(x,y);
                	inc(y,2);
                end;
            end;
    	end;
    41: begin
    		for k:=1 to 2 do begin
            	x := k;
                while x<=BoxAcross do begin
    				if (x mod 2)=1
                		then for y:=1 to BoxDown do DrawBox(x,y)
	                	else for y:=BoxDown downto 1 do DrawBox(x,y);
                    inc(x,2);
                end;
            end;
    	end;
    end;
end;


end.
