unit FxForms;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, Tabs, Buttons, FxRtns,DsgnIntf;

type
  TFxSelectDialog = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    TabSet1: TTabSet;
    Notebook1: TNotebook;
    BitBtn44: TBitBtn;
    BitBtn12: TBitBtn;
    BitBtn13: TBitBtn;
    BitBtn23: TBitBtn;
    BitBtn24: TBitBtn;
    BitBtn19: TBitBtn;
    BitBtn20: TBitBtn;
    BitBtn21: TBitBtn;
    BitBtn60: TBitBtn;
    BitBtn27: TBitBtn;
    BitBtn28: TBitBtn;
    BitBtn29: TBitBtn;
    BitBtn30: TBitBtn;
    BitBtn31: TBitBtn;
    BitBtn15: TBitBtn;
    BitBtn16: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    BitBtn9: TBitBtn;
    BitBtn59: TBitBtn;
    BitBtn11: TBitBtn;
    BitBtn61: TBitBtn;
    BitBtn40: TBitBtn;
    BitBtn39: TBitBtn;
    BitBtn41: TBitBtn;
    BitBtn42: TBitBtn;
    BitBtn43: TBitBtn;
    BitBtn14: TBitBtn;
    BitBtn26: TBitBtn;
    BitBtn34: TBitBtn;
    BitBtn45: TBitBtn;
    BitBtn62: TBitBtn;
    BitBtn10: TBitBtn;
    BitBtn22: TBitBtn;
    BitBtn25: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Bevel2: TBevel;
    Label4: TLabel;
    BitBtn35: TBitBtn;
    BitBtn36: TBitBtn;
    ComboBox1: TComboBox;
    BitBtn37: TBitBtn;
    Image1: TImage;
    PaintBox1: TPaintBox;
    BitBtn33: TBitBtn;
    BitBtn32: TBitBtn;
    procedure TabSet1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn61Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure BitBtn35Click(Sender: TObject);
    procedure BitBtn36Click(Sender: TObject);
  public
  	BoxWidth : byte;
    srcCanvas, dstCanvas : TCanvas;
    TheEffect : byte;
  end;


type
  TEffectProperty = class(TIntegerProperty)
  public
  	FXDialog : TFxSelectDialog;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
    procedure Edit; override;
    function EffectToText(eff:byte):String;
  end;


implementation

{$R *.DFM}

procedure TFxSelectDialog.TabSet1Change(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
	Notebook1.PageIndex := NewTab;
    Label1.Caption := Notebook1.ActivePage+' Effects';
end;

procedure TFxSelectDialog.FormCreate(Sender: TObject);
begin
  	NoteBook1.PageIndex := 0;
    Label1.Caption := Notebook1.ActivePage+' Effects';
    ComboBox1.ItemIndex := 1;
	BoxWidth := 5;
    TheEffect := 0;
    srcCanvas := Image1.Canvas;
    dstCanvas := PaintBox1.Canvas;
	Randomize;
    Screen.Cursor := crDefault;
end;

procedure TFxSelectDialog.BitBtn61Click(Sender: TObject);
begin
	Label4.Caption := TBitBtn(Sender).Hint;
    Label4.Refresh;
    TheEffect := TBitBtn(Sender).Tag;
    BitBtn35Click(Self);
    BitBtn36Click(Self);
end;

procedure TFxSelectDialog.ComboBox1Change(Sender: TObject);
begin
	case ComboBox1.ItemIndex of
	0 : BoxWidth := 2;
    1 : BoxWidth := 5;
    2 : BoxWidth := 7;
    3 : BoxWidth := 10;
    4 : BoxWidth := 15;
    end;
end;

procedure TFxSelectDialog.BitBtn35Click(Sender: TObject);
begin
    dstCanvas.Brush.Color := clSilver;
    dstCanvas.FillRect(dstCanvas.ClipRect);
end;

procedure TFxSelectDialog.BitBtn36Click(Sender: TObject);
begin
	PaintEffect(TheEffect,srcCanvas,dstCanvas,BoxWidth);
end;

(*		TEffectPropepty		*)

function TEffectProperty.GetAttributes: TPropertyAttributes;
begin
	Result := [paMultiSelect,paDialog];
end;

function TEffectProperty.GetValue: string;
var CurValue: Byte;
begin
  	CurValue := GetOrdValue;
    Result := EffectToText(CurValue);
end;

procedure TEffectProperty.SetValue(const Value: string);
var newvalue:byte;
begin
	if Value[2]=' '
    	then NewValue := StrToInt(Copy(Value,1,1))
        else NewValue := StrToInt(Copy(Value,1,2));
	SetOrdValue(NewValue);
end;

procedure TEffectProperty.Edit;
begin
	Screen.Cursor := crHourGlass;
	FxDialog := TFxSelectDialog.Create(Application);
    try
		FxDialog.ShowModal;
        if FxDialog.ModalResult = mrOk then begin
        	SetOrdValue(FxDialog.TheEffect);
        end;
    finally
		Screen.Cursor := crDefault;
	    FxDialog.Free;
    end;
end;

function TEffectProperty.EffectToText(eff:byte):string;
var r:string;
begin
	case eff of
    0: R:='No Effect';
    1 : R:='Left To Right';
    2 : R:='Right To Left';
    3 : R:='Top To Bottom';
    4 : R:='Bottom To Top';
    5 : R:='Horizontal Wipe In';
    6 : R:='Horizontal Wipe Out';
    7 : R:='Vertical Wipe In';
    8 : R:='Vertical Wipe Out';
    9 : R:='Horizontal Interlace';
    10: R:='Vertical Interlace';
    11 : R:='Horizontal Double Pass';
    12: R:='Vertical Double Pass';
    13: R:='Horizontal Double Pass 2';
    14: R:='Vertical Double Pass 2';
    15: R:='Vertical Blind';
    16: R:='Horizontal Blind';
    17: R:='Double Blind';
    18: R:='Diagonal TL-BR';
    19: R:='Diagonal BL-TR';
    20: R:='Diagonal TR-BL';
    21: R:='Diagonal BR-TL';
    22: R:='Double Diagonal TL-BR';
    23: R:='Double Diagonal TR-BL';
    24: R:='Diagonal Out TL-BR';
    25: R:='Diagonal Out TR-BL';
    26: R:='Diagonal Quad';
    27: R:='Vertical Stripes';
    28: R:='Horizontal Stripes';
    29: R:='Vertical Big Stripes';
    30: R:='Horizontal Big Stripes';
    31: R:='Kaleidoscope';
    32: R:='Double Wipe Out';
    33: R:='Double Wipe In';
    34: R:='Random Lines';
    35: R:='Random Blocks';
    36: R:='CheckerBoard';
    37: R:='Screen Drip';
    38: R:='Spray';
    39: R:='Swirl In';
    40: R:='Horizontal Snake';
    41: R:='Vertical Snake';
    end;
	EffectToText := IntToStr(Eff)+' - '+R;
end;

end.
