unit FV_Main;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, Menus, StdCtrls, Ver, Printers, WinCrt, Buttons, ExtCtrls,
	PS_Frm;

type
	TFV_Form 		= class(TForm)
		MainMenu		: TMainMenu;
		MmFile		: TMenuItem;
		MiOpen		: TMenuItem;
		MiPrint		: TMenuItem;
		MiSep1		: TMenuItem;
		MiExit		: TMenuItem;
		MmOptions	: TMenuItem;
		MiFonts		: TMenuItem;
		MiPageSetup	: TMenuItem;
		MiFileSelectDialog: TOpenDialog;
		MiPrintDialog: TPrintDialog;
		MiFontDialog: TFontDialog;
		Panel1		: TPanel;
		ButtonPrevious: TSpeedButton;
		ButtonNext	: TSpeedButton;
		ButtonFirst	: TSpeedButton;
		ButtonLast	: TSpeedButton;
		DisplayArea	: TMemo;
		procedure	FvSelectFile(Sender: TObject);
		procedure	ButtonPreviousClick(Sender: TObject);
		procedure	ButtonNextClick(Sender: TObject);
		procedure	ButtonLastClick(Sender: TObject);
		procedure	ButtonFirstClick(Sender: TObject);
		procedure	MiPrintClick(Sender: TObject);
		procedure	MiExitClick(Sender: TObject);
		procedure	FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure	FormCreate(Sender: TObject);
		procedure	FormDestroy(Sender: TObject);
		procedure	MiFontsClick(Sender: TObject);
		procedure	MiPageSetupClick(Sender: TObject);
		private
			FV_Index	: Integer;
			FileInfo	: TStringList;
			procedure GetFileInfo(Filename: string);
			procedure Display_FI(Filename: string);
		end;

var
	FV_Form	: TFV_Form;

implementation
{$R *.DFM}

procedure TFV_Form.GetFileInfo(Filename: string);
var P		 : Pointer;
	L		 : Word;
procedure GetFI_Fixed(IB: Pointer);
	type PFFI	=	^Tvs_FixedFileInfo;
	var auxstr	: string;
		F			: PFFI;
	begin
		VerQueryValue(IB,'\',P,L);
		F:= PFFI(P);
    	FileInfo.Add('---- Fixed File Info block ---');
		FileInfo.Add('Signature'#9+Format('%8.8x',[F^.dwSignature]));
		FileInfo.Add('StrucVersion'#9+Format('%8.8x',[F^.dwStrucVersion]));
		FileInfo.Add('File version'#9
					+ IntToStr(HiWord(F^.dwFileVersionMS))+'.'
					+IntToStr(LoWord(F^.dwFileVersionMS))+'.'
					+IntToStr(HiWord(F^.dwFileVersionLS))+'.'
					+IntToStr(LoWord(F^.dwFileVersionLS)));
		FileInfo.Add('Product version'#9
					+ IntToStr(HiWord(F^.dwProductVersionMS))+'.'
					+IntToStr(LoWord(F^.dwProductVersionMS))+'.'
					+IntToStr(HiWord(F^.dwProductVersionLS))+'.'
					+IntToStr(LoWord(F^.dwProductVersionLS)));
		FileInfo.Add('File flags mask'#9+Format('%x', [F^.dwFileFlagsMask]));
		auxstr:='';
		if (F^.dwFileFlags and vs_FF_Debug)<>0 then auxstr:= auxstr+',Debug';
		if (F^.dwFileFlags and vs_FF_Prerelease)<>0 then auxstr:= auxstr+',Prerelease';
		if (F^.dwFileFlags and vs_FF_Patched)<>0 then auxstr:= auxstr+',Patched';
		if (F^.dwFileFlags and vs_FF_PrivateBuild)<>0 then auxstr:= auxstr+',PrivateBuild';
		if (F^.dwFileFlags and vs_FF_InfoInferred)<>0 then auxstr:= auxstr+',InfoInferred';
		if (F^.dwFileFlags and vs_FF_SpecialBuild)<>0 then auxstr:= auxstr+',SpecialBuild';
		if auxstr<>'' then auxstr[1]:='[' else auxstr:='[';
		FileInfo.Add('File flags'#9+auxstr+']');
		if F^.dwFileOS = vos__Windows16 then auxstr:= 'Win16'
		else if F^.dwFileOS = vos__Windows32 then auxstr:= 'Win32'
		else if F^.dwFileOS = vos_NT then auxstr:= 'Windows NT'
		else if F^.dwFileOS = vos_DOS then auxstr:= 'DOS'
		else if F^.dwFileOS = vos_DOS_Windows16 then auxstr:= 'Win16 with DOS'
		else if F^.dwFileOS = vos_DOS_Windows32 then auxstr:= 'Win32 with DOS'
		else if F^.dwFileOS = vos_NT_Windows32 then auxstr:= 'Win32 with Windows NT'
		else auxstr:= 'Unknown';
		FileInfo.Add('File OS'#9 + auxstr);
		if F^.dwFileType=vft_APP then auxstr:='App'
		else if F^.dwFileType=vft_DLL then auxstr:='DLL'
		else if F^.dwFileType=vft_DRV then
				if F^.dwFileSubtype=vft2_DRV_Printer then auxstr:='Printer DRV'
				else if F^.dwFileSubtype=vft2_DRV_Keyboard then auxstr:='Keyboard DRV'
				else if F^.dwFileSubtype=vft2_DRV_Language then auxstr:='Language DRV'
				else if F^.dwFileSubtype=vft2_DRV_Display then auxstr:='Display DRV'
				else if F^.dwFileSubtype=vft2_DRV_Mouse then auxstr:='Mouse DRV'
				else if F^.dwFileSubtype=vft2_DRV_Network then auxstr:='Network DRV'
				else if F^.dwFileSubtype=vft2_DRV_System then auxstr:='System DRV'
				else if F^.dwFileSubtype=vft2_DRV_Installable then
								auxstr:='Installable DRV'
				else if F^.dwFileSubtype=vft2_DRV_Sound then auxstr:='Sound DRV'
				else if F^.dwFileSubtype=vft2_DRV_Comm then auxstr:='Comm DRV'
				else auxstr:='Unknown DRV'
		else if F^.dwFileType=vft_Font then
				if F^.dwFileSubtype=vft2_Font_Raster then auxstr:='Raster Font'
				else if F^.dwFileSubtype=vft2_Font_Vector then auxstr:='Vector Font'
				else if F^.dwFileSubtype=vft2_Font_TrueType then auxstr:='TrueType Font'
				else auxstr:= 'Unknown font type'
		else if F^.dwFileType=vft_VXD then auxstr:='VXD'
		else if F^.dwFileType=vft_Static_Lib then auxstr:='Static Lib'
		else auxstr:='Unknown';
		FileInfo.Add('File type'#9+ auxstr);
	end;
procedure GetFI_Variable(IB:Pointer);
    const language: array [0..44] of record LC: Word; LS: string[25] end =
	((LC:$401;LS:'Arabic')		,(LC:$402;LS:'Bulgarian')	,(LC:$403;LS:'Catalan')
	,(LC:$404;LS:'Traditional Chinese'),(LC:$405;LS:'Czech'),(LC:$406;LS:'Danish')
	,(LC:$407;LS:'German')		,(LC:$408;LS:'Greek')		,(LC:$409;LS:'U.S. English')
	,(LC:$40A;LS:'Castilian Spanish'),(LC:$40B;LS:'Finnish'),(LC:$40C;LS:'French')
	,(LC:$40D;LS:'Hebrew')		,(LC:$40E;LS:'Hungarian')	,(LC:$40F;LS:'Icelandic')
	,(LC:$410;LS:'Italian')		,(LC:$411;LS:'Japanese')	,(LC:$412;LS:'Korean')
	,(LC:$413;LS:'Dutch')		,(LC:$414;LS:'Norwegian - Bokml'),(LC:$415;LS:'Polish')
	,(LC:$416;LS:'Brazilian Portuguese'),(LC:$417;LS:'Rhaeto-Romanic'),(LC:$418;LS:'Romanian')
	,(LC:$419;LS:'Russian')		,(LC:$41A;LS:'Croato-Serbian (Latin)'),(LC:$41B;LS:'Slovak')
	,(LC:$41C;LS:'Albanian')	,(LC:$41D;LS:'Swedish')		,(LC:$41E;LS:'Thai')
	,(LC:$41F;LS:'Turkish')		,(LC:$420;LS:'Urdu')		,(LC:$421;LS:'Bahasa')
	,(LC:$804;LS:'Simplified Chinese'),(LC:$807;LS:'Swiss German'),(LC:$809;LS:'U.K. English')
	,(LC:$80A;LS:'Mexican Spanish'),(LC:$80C;LS:'Belgian French'),(LC:$810;LS:'Swiss Italian')
	,(LC:$813;LS:'Belgian Dutch'),(LC:$814;LS:'Norwegian - Nynorsk'),(LC:$816;LS:'Portuguese')
	,(LC:$81A;LS:'Serbo-Croatian (Cyrillic)'),(LC:$C0C;LS:'Canadian French'),(LC:$100C;LS:'Swiss French'));
	const charset: array [0..11] of record CC: Word; CS: string[32] end =
	((CC:0;CS:'7-bit ASCII')		,(CC:932;CS:'Windows, Japan (Shift - JIS X-0208)')
	,(CC:949;CS:'Windows, Korea (Shift - KSC 5601)')
    ,(CC:950;CS:'Windows, Taiwan (GB5)')
    ,(CC:1200;CS:'Unicode')			,(CC:1250;CS:'Windows, Latin-2 (Eastern European)')
    ,(CC:1251;CS:'Windows, Cyrillic'),(CC:1252;CS:'Windows, Multilingual')
	,(CC:1253;CS:'Windows, Greek')  ,(CC:1254;CS:'Windows, Turkish')
	,(CC:1255;CS:'Windows, Hebrew') ,(CC:1256;CS:'Windows, Arabic'));
	const infonames: array [0..11] of string[17] =
	('Comments'       ,'CompanyName'     ,'FileDescription'
	,'FileVersion'    ,'InternalName'    ,'LegalCopyRight'
	,'LegalTrademarks','OriginalFilename','PrivateBuild'
	,'ProductName'    ,'ProductVersion'  ,'SpecialBuild');
	type PVFI =	^VFI;
		VFI  =	array [0..80] of record LC: Word; CC: Word end;
	var LS	: string[25];
		CS		: string[32];
		LC, CC: Word;
		Buf: array [0..255] of Char;
		i,j	: integer;
	begin
		if VerQueryValue(IB,'\VarFileInfo\Translation',P,L) then
			for i:= 0 to (L div 4)-1 do begin
    	    	LS:='';
				LC:=PVFI(P)^[i].LC;
				for j:=0 to 43 do
					if LC=language[j].LC then begin
						LS:=language[j].LS;
						break
					end;
				if LS='' then LS:= 'Unknown';
				CS:='';
				CC:=PVFI(P)^[i].CC;
				for j:=0 to 11 do
					if CC=charset[j].CC then begin
						CS:=charset[j].CS;
						break
					end;
				if CS='' then CS:= 'Unknown';
				FileInfo.Add('----Language-specific block ----');
				FileInfo.Add('Language'#9+LS);
				FileInfo.Add('Character set'#9+CS);
				if (LS<>'Unknown') and ((CC=0) or (CC=1252)) then
					for j:= 0 to 11 do
						if VerQueryValue(IB,
								StrPCopy(@Buf,'\StringFileInfo\'
													+Format('%4.4x%4.4x',[LC,CC])+'\'+infonames[j])
								,P,L) then
							FileInfo.Add(infonames[j]+#9+StrPas(StrMove(Buf,PChar(P),L)));
			end
	end;
var PFilename	: PChar;
	InfoSize		: Longint;
	InfoHandle	: Longint;
	InfoBuffer	: PChar;
begin
	FileInfo.Clear;
	FileInfo.Add('Information on'#9+Filename);
	FileInfo.Add('Last Saved on'#9+FormatDateTime('yyyy-mm-dd hh:nn:ss'
									,FileDateToDateTime(FileAge(Filename))));
	PFilename:= StrAlloc(Length(Filename)+1);
	StrPCopy(PFilename,Filename);
	InfoSize:= GetFileVersionInfoSize(PFilename, InfoHandle);
	if InfoSize<>0 then begin
		InfoBuffer:= StrAlloc(InfoSize+1);
		if GetFileVersionInfo(PFilename, InfoHandle, InfoSize, InfoBuffer) then begin
			GetFI_Fixed(InfoBuffer);
			GetFI_Variable(InfoBuffer);
		end;
		StrDispose(InfoBuffer)
	end;
	StrDispose(PFilename)
end;

{Printing part}
procedure TFV_Form.MiPrintClick(Sender: TObject);
type
	PrnDevInfo=record
		PW, PH			: Integer;	{physical page size}
		VrtG, HrzG		: Integer;	{gutters}
		VrtPPI, HrzPPI	: Integer;	{pixels per inch}
		end;
var PDI	: PrnDevInfo;
procedure SetPrnDevInfo;
	var pt: TPoint;
	begin
		with Printer, PDI do begin
			Escape(Canvas.Handle, GETPHYSPAGESIZE, 0, Nil, @pt);
			PW:= pt.X;
			PH:= pt.Y;
			Escape(Canvas.Handle, GETPRINTINGOFFSET, 0, Nil, @pt);
			HrzG:= pt.X;
			VrtG:= pt.Y;
			VrtPPI := GetDeviceCaps(Handle, LogPixelsX);
			HrzPPI := GetDeviceCaps(Handle, LogPixelsY);
		end
	end;
type
	PrnStatusInfo=record
		M			: TRect;					{margins}
		Y										{current vert. position, in pixels}
		, DY		: Integer;				{delta vert. position, in pixels}
		HTstop	: array[0..0] of Word;{tabstops}
		PgHdr		: Boolean;				{page header}
		RH, RD	: HRgn;					{clipping regions}
		end;
var PSI: PrnStatusInfo;
procedure PrnInitialize;
	begin
		with Printer, PDI, PSI do begin
			Canvas.Font:=PS_Form.Dlg_PrnFonts.Font;
			HTstop[0]:= 10*Canvas.TextWidth('mn');
			DY:= Canvas.TextHeight('Xg');
			PgHdr:= PS_Form.CB_PgHdr.Checked;
			M.Top:= 0;
			if PS_Form.CB_Top.Checked and (VrtPPI>VrtG) then M.Top:= VrtPPI-VrtG;
			M.Bottom:= PH-2*VrtG;
			if PS_Form.CB_Bottom.Checked and (VrtPPI>VrtG) then M.Bottom:= PH-VrtG-VrtPPI;
			M.Left:= 0;
			if PS_Form.CB_Left.Checked and (HrzPPI>HrzG) then M.Left:= HrzPPI-HrzG;
			M.Right:= PW-2*HrzG;
			if PS_Form.CB_Right.Checked and (HrzPPI>HrzG) then M.Right:= PW-HrzG-HrzPPI;
			RH := CreateRectRgn(M.Left, M.Top div 2, M.Right, M.Top+2*DY);
			RD := CreateRectRgn(M.Left, M.Top, M.Right, M.Bottom);
			SelectClipRgn(Canvas.Handle, RD);
		end
	end;
procedure PrnFinalize;
	begin
		with Printer, PSI do begin
			DeleteObject(RH);
			DeleteObject(RD)
		end
	end;
procedure DrawLine(Xf, Yf, Xt, Yt, W: Integer);
	begin
		with Printer.Canvas do begin
			Pen.Width:= W;
			MoveTo(Xf, Yf);
			LineTo(Xt, Yt)
		end
	end;
procedure InitPage;
	begin
		with Printer, PSI, M do begin
			if PgHdr then begin
				SelectClipRgn(Canvas.Handle, RH);
				Canvas.TextOut(Left, Top div 2
						,'File Version Info '+' - Page '+IntToStr(PageNumber));
				Drawline(Left, Top div 2 + DY, Right, Top div 2 + DY, 1);
				SelectClipRgn(Canvas.Handle, RD);
				if Top=0 then Y:= 2*DY else Y:= Top-DY
			end else
				Y:= Top-DY;
		end
	end;
var pstring	: array[0..255] of char;
	F,L		:	Integer;
begin
	if MiPrintDialog.Execute then
		with Printer, PDI, PSI, M do begin
			BeginDoc;
			SetPrnDevInfo;
			PrnInitialize;
			try
				InitPage;
				for F:= 0 to MiFileSelectDialog.Files.Count -1 do begin
					GetFileInfo(MiFileSelectDialog.Files[F]);
					for L:=0 to FileInfo.Count-1 do begin
						Inc(Y, DY);
						if Y+DY > Bottom then begin
							NewPage;
							InitPage
						end;
						TabbedTextOut(Printer.Handle, Left,Y
								,StrPCopy(@pstring, FileInfo[L]),Length(FileInfo[L])
								,1,HTstop,Left)
					end;
					Inc(Y, DY);
					DrawLine(Left, Y, Left+HTstop[0], Y, 5)
				end;
			finally
				PrnFinalize
			end;
			EndDoc
		end
end;

{Screen part}
procedure TFV_Form.Display_FI(Filename: string);
var tabstops: array[0..0] of Word;
begin
	GetFileInfo(Filename);
	with DisplayArea do begin
		tabstops[0]:= 20 * 32 div LOWORD(GetDialogBaseUnits);
		SendMessage(Handle, EM_SetTabStops, 1, Longint(@tabstops));
		Clear;
		Lines:= FileInfo
	end
end;

procedure TFV_Form.FvSelectFile(Sender: TObject);
begin
	DisplayArea.Clear;
	ButtonFirst.Enabled:= False;
	ButtonPrevious.Enabled:= False;
	ButtonNext.Enabled:= False;
	ButtonLast.Enabled:= False;
	MiPrint.Enabled:= False;
	if MiFileSelectDialog.Execute then begin
		MiPrint.Enabled:= True;
		FV_Index:= 0;
		if MiFileSelectDialog.Files.Count>1 then begin
			ButtonNext.Enabled:= True;
			ButtonLast.Enabled:= True
		end;
		Display_FI(MiFileSelectDialog.Files[0]);
	 end
end;

procedure TFV_Form.ButtonFirstClick(Sender: TObject);
begin
	ButtonPrevious.Enabled:= False;
	ButtonFirst.Enabled:= False;
	ButtonNext.Enabled:= True;
	ButtonLast.Enabled:= True;
	FV_Index:= 0;
	Display_FI(MiFileSelectDialog.Files[0]);
end;

procedure TFV_Form.ButtonPreviousClick(Sender: TObject);
begin
	Dec(FV_Index);
	if FV_Index=0 then begin
		ButtonPrevious.Enabled:= False;
		ButtonFirst.Enabled:= False
	end;
	ButtonNext.Enabled:= True;
	ButtonLast.Enabled:= True;
	Display_FI(MiFileSelectDialog.Files[FV_Index]);
end;

procedure TFV_Form.ButtonNextClick(Sender: TObject);
begin
	Inc(FV_Index);
	ButtonPrevious.Enabled:= True;
	ButtonFirst.Enabled:= True;
	if FV_Index=MiFileSelectDialog.Files.Count-1 then begin
		ButtonNext.Enabled:= False;
		ButtonLast.Enabled:= False
	end;
	Display_FI(MiFileSelectDialog.Files[FV_Index]);
end;

procedure TFV_Form.ButtonLastClick(Sender: TObject);
begin
	FV_Index:= MiFileSelectDialog.Files.Count - 1;
	ButtonPrevious.Enabled:= True;
	ButtonFirst.Enabled:= True;
	ButtonNext.Enabled:= False;
	ButtonLast.Enabled:= False;
	Display_FI(MiFileSelectDialog.Files[FV_Index])
end;

{Setup part}
procedure TFV_Form.MiFontsClick(Sender: TObject);
begin
	MiFontDialog.Execute;
	DisplayArea.Font.Assign(MiFontDialog.Font);
	if FV_Index>=0 then Display_FI(MiFileSelectDialog.Files[FV_Index])
end;

procedure TFV_Form.MiPageSetupClick(Sender: TObject);
begin
	PS_Form.ShowModal
end;

{general part}
procedure TFV_Form.MiExitClick(Sender: TObject);
begin Close end;

procedure TFV_Form.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin CanClose:= True end;

procedure TFV_Form.FormCreate(Sender: TObject);
begin FileInfo:= TStringList.Create end;

procedure TFV_Form.FormDestroy(Sender: TObject);
begin FileInfo.Free end;

end.
