{
   Example code using the FormSet control. This is the "parent" or "book"
   form. It has the FormSet control on it. The FormSet displays "child" or
   "page" forms in the client area of the parent.

   One critical procedure in this unit is the OnTabLoad event handler.
   This procedure maps TForm objects onto the tabs. It is called any time a
   tab is selected and FormSet does not already have the TForm object for
   that tab.

   Another important point is to set FormSet1.TabIndex to a valid tab index
   before the main form is seen by the user.  This triggers a Change event
   within FormSet which is needed to display the first tab and form.
}
Unit Unit1;

interface

uses
  SysUtils, Classes, Forms, Dialogs,  Tabs, Controls, Formset, ExtCtrls;

type
  TForm1 = class(TForm)
    FormSet1: TFormSet;
    procedure FormCreate(Sender: TObject);
    procedure FormSet1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure FormSet1Click(Sender: TObject);
    procedure FormSet1TabLoad(Sender: TObject; TabIndex: Integer;
      FormTab: TFormTab);
  private
    { Private declarations }
  public
    { Public declarations  }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}
uses Page1, Page2, Page3;

procedure TForm1.FormCreate(Sender: TObject);
begin
   FormSet1.TabIndex := 0;  { Necessary to trigger first Change }
end;

procedure TForm1.FormSet1Change(Sender: TObject; NewTab: Integer;
   var AllowChange: Boolean);
begin
   showmessage(format('FormSet: Change (TabIndex=%d, NewTab=%d)',
      [FormSet1.Tabindex,NewTab]));
end;

procedure TForm1.FormSet1Click(Sender: TObject);
begin
   showmessage('FormSet: Click.');
end;

procedure TForm1.FormSet1TabLoad(Sender: TObject; TabIndex: Integer;
  FormTab: TFormTab);
var
   Caption : String;
begin
   Caption := FormSet1.Tabs[TabIndex];
   if Caption = 'Page &1' then
   begin
      FormTab.Form    := TfPage1.Create(Self);
      FormTab.OnOpen  := ftoSizeBookToPage;
      FormTab.OnClose := ftcAlwaysRelease;
   end
   else
   if Caption = 'Page &2' then
   begin
      FormTab.Form    := TfPage2.Create(Self);
      FormTab.OnOpen  := ftoSizeBookToPage;
      FormTab.OnClose := ftcNeverRelease;
   end
   else
   if Caption = 'Page &3' then
   begin
      FormTab.Form    := fPage3;   { already exists! }
      FormTab.OnOpen  := ftoSizePageToBook;
      FormTab.OnClose := ftcNeverRelease;
   end;;
end;

end.
