{ copyright (c) 1995 - Microcomputer Enhancement }
unit Main;

interface

uses
  Classes, Controls, Dialogs, Forms, Graphics, Messages, Printers, StdCtrls,
  SysUtils, WinProcs, WinTypes;

type
  TfrmFourPage = class(TForm)
    PrinterSetupDialog: TPrinterSetupDialog;
    OpenDialog: TOpenDialog;
    btnPSetup: TButton;
    btnPrint: TButton;
    btnClose: TButton;
    cbTwoPages: TCheckBox;
    procedure btnPSetupClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmFourPage: TfrmFourPage;

implementation

{$R *.DFM}

procedure TfrmFourPage.btnPSetupClick(Sender: TObject);
begin
  PrinterSetupDialog.Execute;
end;

procedure TfrmFourPage.btnPrintClick(Sender: TObject);
const
  SECOND = 'Insert page(s) for second side';
var
  linesPerPage, charsPerLine, ctr, offset, rOffset, rowHeight,  pageWidth,
  pageNum, adjPhysWidth, pagesPerPage : integer;
  f : TextFile;
  fileName, dateTime : string;
  isPrint, havePrinted : Boolean;
  PhysSize, PrintOffset : TPoint;

  procedure DoLayout;
  var
    s : string;
    i, j, row, col : integer;
  begin
    col := offset;
    inc(pageNum, 1);
    if isPrint then
    begin
      s := lowercase(format('Page %d: %s @ %s', [pageNum, fileName, dateTime]));
      Printer.Canvas.TextOut(col, 0, s);
    end;
    for i := 1 to pagesPerPage do
    begin
      row := 2 * rowHeight;
      for j := 3 to linesPerPage do
      begin
        if eof(f) then exit;
        readln(f, s);
        if isPrint then
        begin
          s := copy(s, 1, charsPerLine);
          Printer.Canvas.TextOut(col, row, s);
          havePrinted := True;
          inc(row, rowHeight);
        end
      end;
      inc(col, pageWidth);
    end
  end;

  procedure OddPages;
  begin
    dateTime := DateTimeToStr(FileDateToDateTime(FileAge(fileName)));
    AssignFile(f, fileName);
    Reset(f);
    isPrint := True;
    havePrinted := False;
    pageNum := 0;
    repeat
      if havePrinted then Printer.NewPage;
      havePrinted := False;
      DoLayout;
      isPrint := not isPrint
    until eof(f);
    if havePrinted then Printer.NewPage;
    CloseFile(f);
  end;

  procedure EvenPages;
  begin
    dateTime := DateTimeToStr(FileDateToDateTime(FileAge(fileName)));
    AssignFile(f, fileName);
    Reset(f);
    havePrinted := False;
    isPrint := False;
    pageNum := 0;
    repeat
      if havePrinted then Printer.NewPage;
      havePrinted := False;
      DoLayout;
      isPrint := not isPrint
    until eof(f);
    CloseFile(f);
  end;

begin
  if not OpenDialog.Execute then exit;
  if cbTwoPages.Checked then
  begin
    Printer.Orientation := poLandscape;
    PagesPerPage := 2;
    Printer.Canvas.Font.Size := 7;
  end
  else
  begin
    Printer.Orientation := poPortrait;
    PagesPerPage := 1;
    PRinter.Canvas.Font.Size := 7;
  end;
  Printer.Canvas.Font.Name := 'Courier New';
  rowHeight := Printer.Canvas.TextHeight('0');
  linesPerPage := Printer.PageHeight div rowHeight;
  Escape(Printer.Handle, GETPHYSPAGESIZE, 0, nil, @PhysSize);
  Escape(Printer.Handle, GETPRINTINGOFFSET, 0, nil, @PrintOffset);
  rOffset := PhysSize.x - Printer.PageWidth - PrintOffset.x;
  if rOffset > PrintOffset.x then
  begin
    offset := rOffset - PrintOffset.x;
    adjPhysWidth := Printer.PageWidth - offset;
  end
  else
  begin
    offset := 0;
    adjPhysWidth := Printer.PageWidth - (PrintOffset.x - rOffset);
  end;
  pageWidth := adjPhysWidth div pagesPerPage;
  charsPerLine := (pageWidth div Printer.Canvas.TextWidth('0')) - 2;
  Printer.BeginDoc;
  for ctr := 0 to OpenDialog.Files.Count - 1 do
  begin
    fileName := OpenDialog.Files.Strings[ctr];
    OddPages;
  end;
  if MessageDlg(SECOND, mtConfirmation, [mbOK, mbCancel], 0) = mrOK then
    for ctr := 0 to OpenDialog.Files.Count - 1 do
    begin
      if ctr > 0 then Printer.NewPage;
      fileName := OpenDialog.Files.Strings[ctr];
      EvenPages;
    end
  else
  begin
    Printer.Abort;
    WinProcs.AbortDoc(Printer.Canvas.Handle);
  end;
  Printer.EndDoc;
end;

procedure TfrmFourPage.btnCloseClick(Sender: TObject);
begin
  Close;
end;

end.
