{
                               Saxman Software
                        Programmer Productivity Series
                            Delphi Custom Controls
                       Copyright 1995, 1996 Jim Standley

                           FormSet Demo, Main Form
}
{
   Example code using the FormSet control. This is the "parent" or "notebook"
   form. It has the FormSet control on it. The FormSet displays "child" or
   "page" forms in the client area of the parent.

   This unit has the OnTabLoad event handler.  This procedure maps TForm
   objects onto the tabs.  It is called any time a tab is selected and
   FormSet does not already have the TForm object for that tab.

   Another important point is to set FormSet1.TabIndex to a valid tab index
   before the main form is seen by the user.  This triggers a Change event
   within FormSet which is needed to display the first tab and form.
}
Unit Notebook;

interface

uses
  SysUtils, Classes, Forms, Dialogs,  Tabs, Controls, Formset, ExtCtrls;

type
  TfNoteBook = class(TForm)
    FormSet1: TFormSet;
    procedure FormCreate(Sender: TObject);
    procedure FormSet1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure FormSet1Click(Sender: TObject);
    procedure FormSet1TabLoad(Sender: TObject; TabIndex: Integer;
      FormTab: TFormTab);
  private
    { Private declarations }
  public
    { Public declarations  }
  end;

var
  fNoteBook: TfNoteBook;

implementation
{$R *.DFM}

uses Page1, Page2, Page3, Logger;

{------------------------------  Form Create  -------------------------------}
procedure TfNoteBook.FormCreate(Sender: TObject);
begin
   fNoteBook.Top     := 20;  { Position the notebook window      }
   fNoteBook.Left    := 20;  {   near top left corner of screen  }
   FormSet1.TabIndex :=  0;  { Necessary to trigger first Change }
end;

{----------------------------  FormSet Change  ------------------------------}
procedure TfNoteBook.FormSet1Change(Sender: TObject; NewTab: Integer;
   var AllowChange: Boolean);
begin
   Log(format('FormSet: Change (TabIndex=%d, NewTab=%d)',
      [FormSet1.Tabindex,NewTab]));
end;

{-----------------------------  FormSet Click  ------------------------------}
{ Fired after all the interesting bits have happened and the new page is     }
{ visible.                                                                   }
procedure TfNoteBook.FormSet1Click(Sender: TObject);
begin
   Log('FormSet: Click.');
end;

{----------------------------  FormSet TabLoad  -----------------------------}
{ Fired by FormSet when the form for a page is not known.  This routine must }
{ load FormTab.Form.  It can optionally override defaults for other FormTab  }
{ properties.  See Options/Project to control which forms are auto-created.  }
procedure TfNoteBook.FormSet1TabLoad(Sender: TObject; TabIndex: Integer;
  FormTab: TFormTab);
var
   Caption : String;
begin
   Log('FormSet: TabLoad');
   Caption := FormSet1.Tabs[TabIndex];
   if Caption = 'Page &1' then
   begin
      FormTab.Form    := TfPage1.Create(Self);  { Not auto-created     }
      FormTab.OnOpen  := ftoSizeBookToPage;
      FormTab.OnClose := ftcAlwaysRelease;      { Released when closed }
   end
   else
   if Caption = 'Page &2' then
   begin
      FormTab.Form    := TfPage2.Create(Self);  { Not auto-created     }
      FormTab.OnOpen  := ftoSizePageToBook;
      FormTab.OnClose := ftcNeverRelease;       { Not released         }
   end
   else
   if Caption = 'Page &3' then
   begin
      FormTab.Form    := fPage3;                { Auto-created         }
      FormTab.OnOpen  := ftoSizePageToBook;
      FormTab.OnClose := ftcNeverRelease;       { Not released         }
   end;;
end;

end.
