unit Fitest1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, StdCtrls, ExtCtrls, Grids, DBGrids,
  DBCtrls, RWForInh;

type
  TCustomerForm = class(TAncestorForm)
    Panel1: TPanel;
    Label1: TLabel;
    CriteriaCombo: TComboBox;
    ValueEdit: TEdit;
    DoBtn: TButton;
    CtrlsPanel: TPanel;
    Navigator: TDBNavigator;
    CustPanel: TPanel;
    CustGrid: TDBGrid;
    Cust: TTable;
    CustCustNo: TFloatField;
    CustCompany: TStringField;
    CustPhone: TStringField;
    CustLastInvoiceDate: TDateTimeField;
    CustSource: TDataSource;
    BtnPanel: TPanel;
    EditBtn: TButton;
    CloseBtn: TButton;
    procedure ValueEditKeyPress(Sender: TObject; var Key: Char);
    procedure DoBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure EditBtnClick(Sender: TObject);
    procedure CustGridEnter(Sender: TObject);
  protected
    { Private declarations }
    FActiveSource: TDataSource;
    procedure SetActiveSource(DataSource: TDataSource);
    property ActiveSource: TDataSource read FActiveSource write SetActiveSource;
    procedure DoSearch; virtual;
  public
    { Public declarations }
    Tablename : string;
  end;

var
  CustomerForm: TCustomerForm;

implementation

{$R *.DFM}

uses
    EdCust;

procedure TCustomerForm.ValueEditKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then begin
    Key := #0;
    DoSearch;
  end;
end;

procedure TCustomerForm.DoBtnClick(Sender: TObject);
begin
  DoSearch;
end;

procedure TCustomerForm.DoSearch;
var F : TField;
    A : integer;
    Table : TTable;
begin
  A := CriteriaCombo.ItemIndex;
  if A<0 then Exit;
  F := TField(CriteriaCombo.Items.Objects[A]);
  Table := TTable(F.Dataset);
  Table.IndexFieldnames := F.FieldName;
  Table.FindNearest([ValueEdit.Text]);
  ActiveControl := CustGrid;
end;

procedure TCustomerForm.FormCreate(Sender: TObject);
begin
  Cust.Open;
  CriteriaCombo.Items.AddObject('Cust no',CustCustNo);
  CriteriaCombo.Items.AddObject('Company',CustCompany);
  CriteriaCombo.ItemIndex := 0;
end;

procedure TCustomerForm.CloseBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TCustomerForm.EditBtnClick(Sender: TObject);
begin
  if EdCustForm = nil then
    EdCustForm:= TEdCustForm.Create(Application);

  EdCustForm.Edit(Cust.Fields[0].AsFloat)
end;

procedure TCustomerForm.CustGridEnter(Sender: TObject);
begin
  ActiveSource := CustSource;
end;

procedure TCustomerForm.SetActiveSource(DataSource: TDataSource);
begin
  FActiveSource := DataSource;
  Navigator.DataSource := FActiveSource;
end;


end.
