unit Custord;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBTables, DB, DBCtrls, StdCtrls, ExtCtrls, Grids,
  DBGrids, Buttons, FITest1;

type
  TBrCustOrdForm = class(TCustomerForm)
    Orders: TTable;
    OrdersSource: TDataSource;
    CustQuery: TQuery;
    CustQueryCustNo: TFloatField;
    CustQueryCompany: TStringField;
    OrdersOrderNo: TFloatField;
    OrdersCustNo: TFloatField;
    OrdersItemsTotal: TCurrencyField;
    OrdersTaxRate: TFloatField;
    OrdersFreight: TCurrencyField;
    OrdersAmountPaid: TCurrencyField;
    OrdersAmountDue: TCurrencyField;
    CustQueryPhone: TStringField;
    CustQueryLastInvoiceDate: TDateTimeField;
    OrdersSaleDate: TDateTimeField;
    OrdersShipDate: TDateTimeField;
    OrdersPanel: TPanel;
    OrdersGrid: TDBGrid;
    DefineBtn: TSpeedButton;
    ActivateBtn: TSpeedButton;
    procedure OrdersCalcFields(DataSet: TDataSet);
    procedure SetQuery(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ActivateQuery(Sender: TObject);
    procedure OrdersGridEnter(Sender: TObject);
  private
    FCustNo: Double;
    FOrderNo: Double;
    function GetCustNo: Double;
    function GetOrderNo: Double;
    procedure SetCustNo(NewCustNo: Double);
    procedure SetOrderNo(NewOrderNo: Double);
    procedure DoSearch; override;
  public
    property CustNo: Double read GetCustNo write SetCustNo;
    property OrderNo: Double read GetOrderNo write SetOrderNo;
  end;

var
  BrCustOrdForm: TBrCustOrdForm;

implementation

{$R *.DFM}

procedure TBrCustOrdForm.FormCreate(Sender: TObject);
begin
  inherited FormCreate(Sender);
  CustQuery.Prepare;
  {link detail table}
  Orders.MasterSource := CustSource;
  Orders.Open;
  {move buttons to ancestor's panel}
  DefineBtn.Parent := CtrlsPanel;
  ActivateBtn.Parent := CtrlsPanel;
  {move orders panel between CtrlsPanel and BtnPanel}
  CtrlsPanel.Top := 0;
  CriteriaCombo.ItemIndex := CriteriaCombo.Items.AddObject('Order no',OrdersOrderNo);
  {adjust tab order}
  OrdersPanel.TabOrder := CtrlsPanel.Taborder;
end;

{ retrieve from active customer table or query--whichever is active }
function TBrCustOrdForm.GetCustNo: Double;
begin
  Result := CustSource.Dataset.Fields[0].AsFloat;
end;

procedure TBrCustOrdForm.SetCustNo(NewCustNo: Double);
begin
  CustSource.Dataset := Cust;
  Cust.FindKey([NewCustNo]);
end;

function TBrCustOrdForm.GetOrderNo: Double;
begin
  Result := OrdersOrderNo.Value;
end;

procedure TBrCustOrdForm.SetOrderNo(NewOrderNo: Double);
begin
  Orders.FindNearest([NewOrderNo]);
end;

procedure TBrCustOrdForm.OrdersCalcFields(DataSet: TDataSet);
begin
  OrdersAmountDue.Value := OrdersItemsTotal.Value +
    OrdersItemsTotal.Value * OrdersTaxRate.Value / 100 +
    OrdersFreight.Value + - OrdersAmountPaid.Value;
end;

procedure TBrCustOrdForm.OrdersGridEnter(Sender: TObject);
begin
  ActiveSource := OrdersSource;
end;

procedure TBrCustOrdForm.SetQuery(Sender: TObject);
begin
  ShowMessage('Define query click');
end;

procedure TBrCustOrdForm.ActivateQuery(Sender: TObject);
begin
  ShowMessage('Activate query click');
end;

procedure TBrCustOrdForm.DoSearch;
var F : TField;
    A : integer;
    CustID : double;
begin
  A := CriteriaCombo.ItemIndex;
  if A<0 then Exit;
  F := TField(CriteriaCombo.Items.Objects[A]);
  if F=OrdersOrderNo then begin
    Orders.MasterSource := nil;
    Orders.IndexFieldnames := F.Fieldname;
    if Orders.FindKey([StrToFloat(ValueEdit.Text)]) then begin
      CustID := OrdersCustNo.Value;
    end else CustID := 0.0;
    Orders.IndexFieldnames := 'CUSTNO';
    if CustID<>0.0 then Cust.FindKey([CustID]);
    Orders.MasterSource := CustSource;
    ActiveControl := OrdersGrid;
  end else
    inherited DoSearch;
end;

end.
