{

 Inheritable forms support for D1
 Author: Cerny Robert
 Email: robert.cerny@eunet.si

    This software is free, which means that you are allowed to used it
    in any project for free. You are NOT allowed to claim that you have created
    this software or to copy its code into your own component and claim
    that is was your idea or even worse to sell it.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 Usage: Just inherit your form from TAncestorForm and any form you inherit from
        it will merge its ancestor's resource. See demo.

 Because there's no "inherited-form aware" designer, you have to take care of some things:
 1. component names must be unique along inheritance path - the form can't have any
    component named as any ancestors' component

 2. if you create a form's event, be sure to call inherited event (if any):
type
 TForm2=class(TAncestorForm)
   ....
   procedure FormCreate(Sender:TObject);
 end;

 TBrCustOrdForm=class(TForm2)
   ....
   procedure FormCreate(Sender:TObject);
 end;

procedure TBrCustOrdForm.FormCreate(Sender: TObject);
begin
  inherited FormCreate(Sender);
  <link detail table>
  Orders.MasterSource := CustSource;
  <other stuff>
end;

 3. if you want to link components to ancestor's components, do it in formcreate:
  Orders.MasterSource := CustSource;
    where CustSource is from TForm2;

 4. See demo for other features.

}

unit RwForInh;

interface

uses
    WinProcs, WinTypes, SysUtils, Classes, Controls, Forms;
type
  TAncestorForm = class(TForm)
  public
    constructor Create(AOwner:TComponent); override;
  published
  end;

implementation

type
  PFieldClassTable = ^TFieldClassTable;
  TFieldClassTable = packed record
    Count: Smallint;
    Classes: array[0..8191] of TPersistentClass;
  end;

function GetFieldClassTable(AClass: TClass): PFieldClassTable; assembler;
asm
        XOR     AX,AX
        XOR     DX,DX
        LES     DI,AClass
        MOV     DI,ES:[DI-30]   { vtFieldTable }
        OR      DI,DI
        JE      @@1
        MOV     AX,ES:[DI+2]    { ftClassTable }
        MOV     DX,ES
@@1:
end;

procedure RegisterAncestorFormFieldClasses(AClass:TClass;ClassList:TList);
var
  I: Integer;
  ClassTable: PFieldClassTable;
  FClass : TPersistentClass;
begin
  while (AClass <> TAncestorForm) and (AClass<>nil) do begin
    ClassTable := GetFieldClassTable(AClass);
    if ClassTable <> nil then for I := 0 to ClassTable^.Count - 1 do begin
      FClass := ClassTable^.Classes[I];
      if (ClassList<>nil) and (ClassList.Indexof(FClass)>=0) then continue;
      RegisterClass(FClass);
      if ClassList<>nil then ClassList.Add(FClass);
    end;
    AClass := AClass.ClassParent;
  end;
end;

function ReadComponentResNoError(const ResName: string; Instance: TComponent): TComponent;
var
  HResInfo: THandle;
  Handle: Integer;
  Stream: TStream;
  Name: array[0..63] of Char;
begin
  StrPLCopy(Name, ResName, SizeOf(Name) - 1);
  HResInfo := FindResource(HInstance, Name, rt_RCData);
  if HResInfo = 0 then Exit;
  Handle := AccessResource(HInstance, HResInfo);
  if Handle = 0 then Exit;
  Stream := THandleStream.Create(Handle);
  try
    try
      Result := Stream.ReadComponent(Instance);
    except
      Application.HandleException(Instance);
    end;
  finally
    Stream.Free;
    FileClose(Handle);
  end;
end;

procedure LoadTheRes(AClass:TClass;Instance: TComponent);
begin
  ReadComponentResNoError(AClass.ClassName, Instance);
end;

procedure ReadComponentResWithAncestors(AClass:TClass;Instance:TComponent);
begin
  if AClass = TAncestorForm then Exit;
  ReadComponentResWithAncestors(AClass.ClassParent,Instance);
  LoadTheRes(AClass,Instance);
end;

type
    TProxyForm = class(TScrollingWinControl)
    private
      FActiveControl: TWinControl;
      FFocusedControl: TWinControl;
      FBorderIcons: TBorderIcons;
      FBorderStyle: TFormBorderStyle;
      FWindowState: TWindowState;
      FShowAction: TShowAction;
      FKeyPreview: Boolean;
      FActive: Boolean;
      FFormStyle: TFormStyle;
      FPosition: TPosition;
      FTileMode: TTileMode;
      FFormState: TFormState;
    end;

constructor TAncestorForm.Create(AOwner:TComponent);
{$IFDEF Ver80}
var FOnCreate : TNotifyEvent;
    ClassList : TList;
    A : integer;
{$ENDIF}
begin
{use this feature in D1 only}
{$IFDEF Ver80}
  CreateNew(AOwner);
  Include(TProxyForm(Self).FFormState, fsCreating);
  ClassList := TList.Create;
  try
    RegisterAncestorFormFieldClasses(ClassType.Classparent,ClassList);
    ReadComponentResWithAncestors(ClassType,Self);
  finally
    for A := 0 to ClassList.Count-1 do
      UnregisterClass(ClassList[A]);
    Exclude(TProxyForm(Self).FFormState, fsCreating);
    ClassList.Free;
  end;
  try
    FOnCreate := OnCreate;
    if Assigned(FOnCreate) then FOnCreate(Self);
  except
    Application.HandleException(Self);
  end;
  if fsVisible in TProxyForm(Self).FFormState then Visible := True;
{$ELSE}
  inherited Create(AOwner);
{$ENDIF}
end;

end.

