unit Edcust;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBTables, DB, StdCtrls, ExtCtrls, Mask, DBCtrls, Buttons;

type
  TEdCustForm = class(TForm)
    Cust: TTable;
    CustSource: TDataSource;
    CustCustNo: TFloatField;
    CustCompany: TStringField;
    CustAddr: TStringField;
    CustAddr2: TStringField;
    CustCity: TStringField;
    CustState: TStringField;
    CustZip: TStringField;
    CustCountry: TStringField;
    CustPhone: TStringField;
    CustTaxRate: TFloatField;
    CustContact: TStringField;
    CustFAX: TStringField;
    CustLastInvoiceDate: TDateTimeField;
    Panel2: TPanel;
    Label1: TLabel;
    DBEdCustNo: TDBEdit;
    DBEdName: TDBEdit;
    DBEdit3: TDBEdit;
    DBEdit4: TDBEdit;
    DBEdit5: TDBEdit;
    DBEdit6: TDBEdit;
    DBEdit7: TDBEdit;
    DBEdit8: TDBEdit;
    DBEdit9: TDBEdit;
    DBEdit11: TDBEdit;
    DBEdit12: TDBEdit;
    DBEdInv: TDBEdit;
    DBEdit14: TDBEdit;
    Label14: TLabel;
    NextCust: TTable;
    NextCustNewCust: TFloatField;
    Panel: TPanel;
    DBNavigator: TDBNavigator;
    DoneBtn: TButton;
    PrintBtn: TSpeedButton;
    procedure CustNewRecord(DataSet: TDataset);
    procedure PrintBtnClick(Sender: TObject);
    procedure DoneBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  public
    procedure Edit(CustNo: Double);
  end;

var
  EdCustForm: TEdCustForm;

implementation

{$R *.DFM}

procedure TEdCustForm.Edit(CustNo: Double);
begin
  Cust.Open;
  Cust.FindKey([CustNo]);
  ShowModal;
end;

procedure TEdCustForm.CustNewRecord(DataSet: TDataset);
begin
  { get next CustNo }
  NextCust.Open;
  NextCust.Edit;
  try
    CustCustNo.Value := NextCustNewCust.Value;
    NextCustNewCust.Value := NextCustNewCust.Value + 1;
    NextCust.Post;
  finally
    NextCust.Cancel;
    NextCust.Close;
  end;
end;

procedure TEdCustForm.DoneBtnClick(Sender: TObject);
begin
  if Cust.State in [dsEdit, dsInsert] then Cust.Post;
  Close;
end;

procedure TEdCustForm.PrintBtnClick(Sender: TObject);
begin
  if MessageDlg('   Print this form?', mtConfirmation, [mbYes,mbNo], 0) = mrYes then
    Print;
end;

procedure TEdCustForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Cust.State in [dsEdit, dsInsert] then Cust.Post;
end;

end.
