unit Custqry;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons;

type
  TCustQueryDlg = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    FromEdit: TEdit;
    ToEdit: TEdit;
    CancelBtn: TButton;
    OkBtn: TButton;
    Msglab: TLabel;
    PopupCalBtnFrom: TSpeedButton;
    PopupCalToBtn: TSpeedButton;
    Bevel1: TBevel;
    procedure OkBtnClick(Sender: TObject);
    procedure PopupCalBtnFromClick(Sender: TObject);
    procedure PopupCalToBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
  private
    function GetFromDate: TDateTime;
    function GetToDate: TDateTime;
    procedure SetFromDate(NewDate: TDateTime);
    procedure SetToDate(NewDate: TDateTime);
  public
    property FromDate: TDateTime read GetFromDate write SetFromDate;
    property ToDate: TDateTime read GetToDate write SetToDate;
  end;

var
  CustQueryDlg: TCustQueryDlg;

implementation

{$R *.DFM}

uses Pickdate;

procedure TCustQueryDlg.SetFromDate(NewDate: TDateTime);
begin
  FromEdit.Text := DateToStr(NewDate);
end;

procedure TCustQueryDlg.SetToDate(NewDate: TDateTime);
begin
  ToEdit.Text := DateToStr(NewDate);
end;

function TCustQueryDlg.GetFromDate: TDateTime;
begin
  if FromEdit.Text = '' then Result := 0
  else Result := StrToDate(FromEdit.Text);
end;

function TCustQueryDlg.GetToDate: TDateTime;
begin
  if ToEdit.Text = '' then Result := 0
  else Result := StrToDate(ToEdit.Text);
end;

procedure TCustQueryDlg.OkBtnClick(Sender: TObject);
var Test: TdateTime;
begin
  try
    Test := StrToDate(FromEdit.Text); { validate date strings }
    Test := StrToDate(ToEdit.Text);
    if (ToDate <> 0) and (ToDate < FromDate) then
    begin
      ShowMessage('"TO" date cannot be less than "FROM" date');
      ModalResult := mrNone;
    end
    else ModalResult := mrOk;
  except
    ShowMessage('  Invalid date specified');
    ModalResult := mrNone;
  end;
end;

procedure TCustQueryDlg.PopupCalBtnFromClick(Sender: TObject);
begin
  BrDateForm.Date := StrToDate(FromEdit.Text);  { start with current date }
  if BrDateForm.ShowModal = mrOk then
    FromEdit.Text := DateToStr(BrDateForm.Date);
end;

procedure TCustQueryDlg.PopupCalToBtnClick(Sender: TObject);
begin
  BrDateForm.Date := StrToDate(ToEdit.Text);    { start with current date }
  if BrDateForm.ShowModal = mrOk then
    ToEdit.Text := DateToStr(BrDateForm.Date);
end;

procedure TCustQueryDlg.CancelBtnClick(Sender: TObject);
begin
  ToEdit.Text := '';
  FromEdit.Text := '';
end;

end.
