
{*******************************************************}
{                                                       }
{       Delphi flat button interface                    }
{       Windows 32bit flab button interface Unit        }
{                                                       }
{       Copyright (c) 1998 Maciej Zagozda               }
{                                                       }
{*******************************************************}

unit FlatButton;

interface

uses
  Classes,
  Controls,
  Dialogs,
  ExtCtrls,
  Forms,
  Graphics,
  Messages,
  SysUtils,
  Windows,
  WinProcs,
  WinTypes;

type
  TClickEvent = procedure( Sender: TObject ) of object;
  TFlatButton = class( TCustomPanel )

  private
    fActive: Boolean;
    fEnabled: Boolean;
    fOnClick: TClickEvent;
    procedure CMMouseEnter( var Message: TMessage ); message cm_mouseenter;
    procedure CMMouseLeave( var Message: TMessage ); message cm_mouseleave;
    procedure WMLButtonDown( var Message: TMessage ); message wm_lbuttondown;
    procedure WMLButtonUp( var Message: TMessage ); message wm_lbuttonup;
    procedure CMDialogChar( var Message: TCMDialogChar ); message cm_dialogchar;
  protected
    procedure SetActive( aActive: Boolean );
    procedure SetEnabled( aEnabled: Boolean );
  public
    constructor Create( AOwner: TComponent ); override;
    destructor Destroy; override;
  published
    property Active: Boolean read fActive write SetActive;
    property Caption;
    property Cursor;
    property Enabled: Boolean read fEnabled write SetEnabled;
    property Font;
    property Hint;
    property ParentFont;
    property ParentShowHint;
    property TabOrder;
    property TabStop;
    property Tag;
    property Visible;
    property OnClick: TClickEvent read fOnClick Write fOnClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

Implementation

constructor TFlatButton.Create( aOwner: TComponent );
begin
  inherited Create( aOwner );

  BevelWidth := 1;
  BevelOuter := bvRaised;
  Caption := Name;
  Enabled := True;
  FullRepaint := False;
  Height := 25;
  ParentFont := True;
  Width := 85;
  Visible := True;

end;

procedure TFlatButton.CMDialogChar( var Message: TCMDialogChar );
begin
  with Message do
  begin
    if IsAccel( Message.CharCode, Caption ) then
    begin
      if ( Assigned( OnClick )) and ( Enabled = True ) then OnClick( Self );
      Result := 1;
    end
    else
    begin
      inherited;
    end;//if
  end;//with
end;

destructor TFlatButton.Destroy;
begin
  Inherited Destroy;
end;//destroy

procedure TFlatButton.CMMouseEnter( var Message: TMessage );
begin
  inherited;
  If (Enabled = True ) And ( Active = True ) And ( Cursor <> crHandPoint ) And ( Font.Color <> clBlue ) Then
  begin
    Font.Color := clBlue;
    Font.Style := Font.Style + [fsUnderline];
    Cursor := crHandPoint;
  end;
end;

procedure TFlatButton.CMMouseLeave( var Message: TMessage );
begin
  inherited;
  If Enabled Then
  begin
    Font.Color := clBtnText;
    Font.Style := Font.Style - [fsUnderline];
    Cursor := crDefault;
  end;//if

  BevelOuter := bvRaised;
end;

procedure TFlatButton.WMLButtonDown( var Message: TMessage );
begin
  inherited;
  if fEnabled = True then BevelOuter := bvLowered;
end;

procedure TFlatButton.WMLButtonUp( var Message: TMessage );
begin
  inherited;
  BevelOuter := bvRaised;
  if ( Assigned( OnClick )) and ( fEnabled = True ) then OnClick( Self );
end;

procedure TFlatButton.SetActive( aActive: Boolean );
begin
  If( aActive <> fActive ) Then
  begin
    fActive := aActive;
  end;//if

  if csDesigning in ComponentState then
  begin
    if Active = True then
    begin
      Font.Color := clBlue;
      Font.Style := Font.Style + [fsUnderline];
    end
    else
    begin
      Font.Color := clBtnText;
      Font.Style := Font.Style - [fsUnderline];
    end;//if
  end;//if
end;

procedure TFlatButton.SetEnabled( aEnabled: Boolean );
begin
  If( aEnabled <> fEnabled ) then
  begin
    fEnabled := aEnabled;
  end;//if

  If aEnabled = True Then
    Font.Color := clBtnText
  else
    Font.Color := clBtnShadow;
end;

procedure Register;
begin
  RegisterComponents('Standard', [TFlatButton]);
end;

end.