Unit FitLabel;

Interface

Uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, 
  Dialogs, StdCtrls;

Type
  TFitLabel = class(TLabel)

  Private
    { Private declarations }
    {Made read-only}
    FAutoSize : Boolean;    {Will NOT show up in the ObjectInspector}
    FLayout : TTextLayout;  {Will NOT show up in the ObjectInspector}
    FAlignment : TAlignment; {Will NOT show up in the ObjectInspector}

    {These values are normally NOT in the ObjectInspector}
    FXAspectRatio : Word; {Publish, will be shown in ObjectInspector}
    FYAspectRatio : Word; {Publish, will be shown in ObjectInspector}

    {Internal procedures}
    Procedure DrawLabelText(Flags : Word);
    Procedure SetXAspectRatio(Value : Word); {You can change its value
    in the ObjectInspector}
    Procedure SetYAspectRatio(Value : Word); {You can change its value
    in the ObjectInspector}

  Protected
    { Protected declarations }
    Procedure Paint; override;

  Public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;

  Published
    { Published declarations }
    Property AutoSize : Boolean read FAutoSize;
    Property Layout : TTextLayout read FLayout;
    Property Alignment : TAlignment read FAlignment;
    {Property Color;
    Property Font;}

    {Inherited anyway
    Property Color;
    Property Cursor;
    Property DragCursor;
    Property DragMode;
    Property Enabled;
    Property Hint;
    Property ParentColor;
    Property ParentFont;
    Property Font;
    Property ShowHint; }

    {New properties for FitLabel}
    Property XAspectRatio : Word read FXAspectRatio
       write SetXAspectRatio default 900;
    {I don't know why I can set the default here, the ObjectInspector
    shows a '0' anyway...}

    Property YAspectRatio : word read FYAspectRatio
       write SetYAspectRatio default 1000;
    {I don't know why I can set the default here, the ObjectInspector
    shows a '0' anyway...}

  End;

Procedure Register;

Implementation

{----------------------------------------------------------------------}
Procedure TFitLabel.SetXAspectRatio(Value : Word);

Begin
If Value <> FXAspectRatio then
   Begin
   FXAspectRatio := Value;    {FXAspectRatio has changed!}
   Invalidate;                {Update the label caption}
   End;
End;
{----------------------------------------------------------------------}
Procedure TFitLabel.SetYAspectRatio(Value : Word);

Begin
If Value <> FYAspectRatio then
   Begin
   FYAspectRatio := Value;    {FYAspectRatio has changed!}
   Invalidate;                {Update the label caption}
   End;
End;
{----------------------------------------------------------------------}
Procedure TFitLabel.DrawLabelText(Flags : Word);

Var
   Text                              : Array[0..255] of Char;
   LogFont,NewLogFont                : TLogFont;
   NewFont,OldFont                   : HFont;
   L                                 : Byte;
   MRect                             : TRect;
   TextXOffset,TextYOffset           : Integer;

Begin
{Delphi automatically fills the text: 'FitLabel#' in here. # is a number
starting from '1'}
GetTextBuf(Text,SizeOf(Text));

If (Flags and DT_CALCRECT <> 0) and
   ((Text[0] = #0) or ShowAccelChar and
   (Text[0] = '&') and (Text[1] = #0)) then
   StrCopy(Text,' ');
   {I assume that this statement corrects the length of the string
   if an accelerator character is used, but I don't know how it
   works [1] }

If not ShowAccelChar then
   Flags := Flags or DT_NOPREFIX;
   {No idea what DT_NOPREFIX means [1] }

L := StrLen(Text);

Canvas.Font := Font;
GetObject(Font.Handle,SizeOf(TLogFont),@LogFont);
NewLogFont := LogFont;

MRect := ClientRect;
NewLogFont.lfWidth := FXAspectRatio * (MRect.Right - MRect.Left) div ((L + 1) * 1000);
NewLogFont.lfHeight := (FYAspectRatio * (- MRect.Bottom + MRect.Top)) div 1000; {Must be negative}
NewFont := CreateFontIndirect(NewLogFont);
OldFont := SelectObject(Canvas.Font.Handle,NewFont);
DeleteObject(OldFont);
Canvas.Font.Handle := NewFont;

{Place the text in the middle of ClientRect}
TextXOffset := (ClientWidth - Canvas.TextWidth(Text)) shr 1;
TextYOffset := (ClientHeight - Canvas.TextHeight(Text)) shr 1;
Canvas.TextRect(MRect,TextXOffset,TextYOffset,Text);
End;
{----------------------------------------------------------------------}
Procedure TFitLabel.Paint;

Const
   Alignments : array[TAlignment] of Word = (DT_LEFT,DT_RIGHT,DT_CENTER);
   {I don't know why [1] }

Var
   MRect : TRect;

Begin
With Canvas do
   Begin
   If not Transparent then
      Begin
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(ClientRect);
      {ClientRect = Rect(Client.Left, Client.Top,
                         Client.Right, Client.Bottom}
      End;

   Brush.Style := bsClear;
   MRect := Rect(0,0,(FXAspectRatio * ClientWidth) div 1000,
      (FYAspectRatio * ClientHeight) div 1000);
   {By changing the value of XAspectRatio the caption will fit in the
   label. However a lot of trial and error is needed... If you know
   a better way, please inform me [1] }

   DrawLabelText({MRect,}(DT_EXPANDTABS or DT_WORDBREAK) or
      Alignments[Alignment]);
   {I don't know what DT_XXXXXXX means [1] }
   End;
End;
{----------------------------------------------------------------------}
Procedure Register;

Begin
RegisterComponents('Samples', [TFitLabel]);
End;
{----------------------------------------------------------------------}
constructor TFitLabel.Create(AOwner:TComponent);

Begin
Inherited Create(AOwner);
Font.Name := 'Arial';                 {Not necessary, but the font
                                      is much nicer than MS Sans Serif}

{Set the values in spite of the fact that they are made readonly!}
Inherited AutoSize := False;          {Strange effects if AutoSize =
                                      True! So I have turned it off}

Inherited Layout := tlTop;            {Cannot be changed anyway for
                                      some reason, so I have turned it
                                      off}

Inherited Alignment := taLeftJustify; {Cannot be changed anyway for
                                      some reason, so I have turned it
                                      off}

Inherited WordWrap := False;          {I have turned it off}


Width := 73;                          {To start with}
Height := 73;                         {To start with}

{With other fonts you have to find the optimal AspectRatio. For instance
the font 'OCRA' must have a XAspectRatio of about 550 befor the caption
will properly fit into the label. With 985 it is far to large.}

{The next statement will change the number shown in the ObjectInspector.
And not the 'default' statement in the 'property' declaration...}
XAspectRatio := 895;  {Optimized for Arial}

{The next statement will change the number shown in the ObjectInspector.
And not the 'default' statement in the 'property'declaration...}
YAspectRatio := 1000; {Mostly 1000 is OK}

End;
{----------------------------------------------------------------------}
End.

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/

                                   [1]

           You can send your help, answers, comments and advises to:
     
                            m.deHaan@inn.nl

                  (Only ASCII files are accepted)

\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}

{======================================================================}

