unit Ffmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileFind, ExtCtrls;

const
  AppName = 'TFileFind demo';

type
  TForm1 = class(TForm)
    FileFind1: TFileFind;
    Label1: TLabel;
    Edit1: TEdit;
    ListBox1: TListBox;
    Start: TButton;
    Stop: TButton;
    RadioGroup1: TRadioGroup;
    CheckBox1: TCheckBox;
    Close: TButton;
    Total: TLabel;
    procedure StartClick(Sender: TObject);
    procedure StopClick(Sender: TObject);
    procedure FileFind1Match(Sender: TObject);
    procedure FileFind1ChangeDrive(Sender: TObject; NewDrive: Char);
    procedure FileFind1ChangeDirectory(Sender: TObject;
      NewDirectory: TFileName);
    procedure RadioGroup1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CloseClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FileFind1Stop(Sender: TObject; var CanStop: Boolean);
  private
    { Private declarations }
    Count: Integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.StartClick(Sender: TObject);
begin
  Count := 0;
  Total.Caption := '0';
  ListBox1.Items.Clear;

  { enable/disable controls }
  Start.Enabled := false;
  Close.Enabled := false;
  Edit1.Enabled := false;
  CheckBox1.Enabled := false;
  RadioGroup1.Enabled := false;
  Stop.Enabled := true;

  { setup control }
  FileFind1.FileName := Edit1.Text;

  { do it! }
  try
    FileFind1.Start;
  finally

    { restore controls }
    Start.Enabled := true;
    Close.Enabled := true;
    Edit1.Enabled := true;
    CheckBox1.Enabled := true;
    RadioGroup1.Enabled := true;
    Stop.Enabled := false;

    Caption := AppName;
    Application.Title := AppName;
  end
end;

procedure TForm1.StopClick(Sender: TObject);
begin
  FileFind1.Stop;
end;

procedure TForm1.FileFind1Match(Sender: TObject);
begin
  ListBox1.Items.Add(FileFind1.LastMatch);
  Inc(Count);
  Total.Caption := IntToStr(Count);
{  ListBox1.ItemIndex := ListBox1.Items.Count-1; }
end;

procedure TForm1.FileFind1ChangeDrive(Sender: TObject; NewDrive: Char);
begin
  ListBox1.Items.Add('');
  ListBox1.Items.Add('Drive '+NewDrive+':');
end;

procedure TForm1.FileFind1ChangeDirectory(Sender: TObject;
  NewDirectory: TFileName);
begin
  Caption := NewDirectory;
  Application.Title := NewDirectory; { Try minimize when searching... }
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  FileFind1.SearchScope := TSearchScope(RadioGroup1.ItemIndex);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  FileFind1.StopOnFirstMatch := CheckBox1.Checked;
end;

procedure TForm1.CloseClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  Caption := AppName;
  Application.Title := AppName;
  Total.Caption := '';
  Edit1.Text := '';
  RadioGroup1.ItemIndex := Integer(FileFind1.SearchScope);
  CheckBox1.Checked := FileFind1.StopOnFirstMatch;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  Start.Enabled := Edit1.Text <> '';
end;

procedure TForm1.FileFind1Stop(Sender: TObject; var CanStop: Boolean);
begin
  CanStop := MessageDlg('Do you really want to stop?',
                mtConfirmation,[mbYes,mbNo],0) = mrYes;
end;

end.
