unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    MainMenu1: TMainMenu;
    EdLoad: TEdit;
    BtLoad: TButton;
    EdSave: TEdit;
    BtSave: TButton;
    BtHelp: TButton;
    BtExit: TButton;
    Datei1: TMenuItem;
    MnLaden: TMenuItem;
    MnSave: TMenuItem;
    MnExit: TMenuItem;
    MnHelp: TMenuItem;
    BtStart: TButton;
    StartKonverter1: TMenuItem;
    Memo1: TMemo;
    Rbtxt2txt: TRadioButton;
    RbBin2txt: TRadioButton;
    RbTxt2Bin: TRadioButton;
    procedure MnExitClick(Sender: TObject);
    procedure MnLadenClick(Sender: TObject);
    procedure MnSaveClick(Sender: TObject);
    procedure StartKonverter1Click(Sender: TObject);
    procedure Konvert(sender: Tobject);
    procedure Konbin(sender: TObject);
    procedure Kontxt(sender: TObject);
    procedure BtHelpClick(Sender: TObject);

  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  wbuffer: word;
  infotexte: string;
  NameOfFile1,NameOfFile2,teile: string;
  Txt,cif: file ;
  CifBuffer,extens,txthex,txthi,txtlo: string;
  TxTBuffer,typen,hitxt,lotxt:byte;
  ok,i: integer;
  Buffer: integer;
implementation

{$R *.DFM}

procedure TForm1.MnExitClick(Sender: TObject);
begin
application.terminate;
end;

procedure TForm1.MnLadenClick(Sender: TObject);
begin
OpenDialog1.Filter := 'Text-Datei: *.Txt *.Doc *.Cif|*.Txt;*.Doc;*.Cif|Alle Dateien: *.*|*.*';
  if OpenDialog1.Execute then
   begin
    NameOfFile1 := OpenDialog1.FileName;
   end;
   EdLoad.text:=NameOfFile1;
   if edload.text <> '' then btsave.enabled:=true;
end;

procedure TForm1.MnSaveClick(Sender: TObject);
begin
SaveDialog1.Filter := 'Enigma-Datei: *.Cif|*.Cif|Alle Dateien: *.*|*.*';
  if SaveDialog1.Execute then
   begin
    NameOfFile2 := SaveDialog1.FileName;
   end;
  extens:=ExtractFileExt(NameOfFile2);
 if extens='' then extens:='.cif';
 NameOfFile2:=changeFileext(NameOfFile2,extens);
 if FileExists(NameOfFile2) then    // prfe ob vorhanden dann weiter sonst abbrechen
  if MessageDlg('Soll ich '+NameOfFile2+' berschreiben ?',mtError,[mbYes, mbNo],
   0) =  mrNo then begin
   NameOfFile2:='';
   EdSave.text:='';
   exit;            // abbruch procedure
  end;
  EdSave.text:=NameOfFile2;
  if edsave.text <> '' then btstart.enabled:=true;
 end;

procedure TForm1.StartKonverter1Click(Sender: TObject);
begin
  typen:=0;
  if rbtxt2txt.checked then typen:=1;
  if rbbin2txt.checked then typen:=2;
  if rbtxt2bin.checked then typen:=3;
  AssignFile(Txt, NameOfFile1);   { im Dialogfenster gewhlte Datei }
  if NameOfFile1 = '' then exit;
  Reset(Txt,1);            // ffne txt
 case typen of
  1: Konvert(sender);       // konvertiere alle Zeichen und symbole
  2: Konbin(sender);   //konvertiert bin zu hex-texte
  3: Kontxt(sender);  //konvertiert von hext-texte zurck zu binr
 end;
  closefile(txt);
end;

procedure TForm1.Konvert(Sender: TObject);
begin
  infotexte:=' ';
  While NOT EOF(txt) do begin   //ende des files ??
    BlockRead(txt,txtbuffer,1, ok);
    if ok >0 then begin
     case txtbuffer of
      0: Teile:='NUL';
      1: Teile:='SOH';
      2: Teile:='STX';
      3: Teile:='ETX';
      4: Teile:='E KU T';
      5: Teile:='EN KU';
      6: Teile:='ACK';
      7: Teile:='BEL';
      8: Teile:='BS';
      9: Teile:='HT';
      10: Teile:='LF';
      11: Teile:='VT';
      12: Teile:='FF';
      13: Teile:='CR';
      14: Teile:='SO';
      15: Teile:='SI';
      16: Teile:='DLE';
      17: Teile:='DCI';
      18: Teile:='DC2';
      19: Teile:='DC3';
      20: Teile:='DC4';
      21: Teile:='NAK';
      22: Teile:='S IPSILON N';
      23: Teile:='ETB';
      24: Teile:='CAN';
      25: Teile:='EM';
      26: Teile:='SUB';
      27: Teile:='ESC';
      28: Teile:='FS';
      29: Teile:='GS';
      30: Teile:='RS';
      31: Teile:='US';
      32: Teile:=' ';
      33: Teile:='AUSRUFEZEICHEN';
      34: Teile:='ANFUEHRUNGSZEICHEN';
      35: Teile:='DOPPELKREUZ';
      36: Teile:='DOLLAR';
      37: Teile:='PROZENT';
      38: Teile:='UND';
      39: Teile:='HOCHSTRICH RECHTS';
      40: Teile:='KLAMMER AUF';
      41: Teile:='KLAMMER ZU';
      42: Teile:='STERN';
      43: Teile:='PLUS';
      44: Teile:='KOMMA';
      45: Teile:='MINUS';
      46: Teile:='PUNKT';
      47: Teile:='SCHRAEGSTRICH RECHTS';
      48: Teile:='O';
      49: Teile:='I';
      50..57: Teile:=Char(txtbuffer);
      58: Teile:='DOPPELPUNKT';
      59: Teile:='SEMIKOLON';
      60: Teile:='KLEINER ALS';
      61: Teile:='IST GLEICH';
      62: Teile:='GR OE SSER ALS';
      63: Teile:='FRAGEZEICHEN';
      64: Teile:='AT';
      65..73: Teile:=Char(TXTBUFFER);
      74: Teile:='IOT';
      75..86: Teile:=Char(txtbuffer);
      87: Teile:='VV';
      88: Teile:='IKS';
      89: Teile:='IPSILON';
      90: Teile:='Z';
      91: Teile:='ECKIGE KLAMMER AUF';
      92: Teile:='SCHRAEGSTRICH LINKS';
      93: Teile:='ECKIGE KLAMMER ZU';
      94: Teile:='CONTROL';
      95: Teile:='UNTERSTRICH';
      96: Teile:='HOCHSTRICH LINKS';
      97..106: Teile:=uppercase(char(txtBuffer));
      107: Teile:='IOT';
      108..118: Teile:=uppercase(char(txtBuffer));
      119: Teile:='VV';
      120: Teile:='IKS';
      121: Teile:='IPSILON';
      122: Teile:='Z';
      123: Teile:='GESCHVVEIFTE KLAMMER AUF';
      124: Teile:='I';
      125: Teile:='GESCHVVEIFTE KLAMMER ZU';
      126: Teile:='VVELLE';
      127..129: Teile:='I'+InttoStr(txtbuffer-100);
      130: Teile:='I3O';
      131: Teile:='I3I';
      132..139: Teile:='I'+InttoStr(txtbuffer-100);
      140: Teile:='I4O';                // 2. version splitte zahl auf i[1],i[2],i[3]:=I23456789O
      141: Teile:='I4I';
      142..149: Teile:='I'+InttoStr(txtbuffer-100);
      150: Teile:='I5O';
      151: Teile:='I5I';
      152..159: Teile:='I'+InttoStr(txtbuffer-100);
      160: Teile:='I6O';
      161: Teile:='I6I';
      162..169: Teile:='I'+InttoStr(txtbuffer-100);
      170:  Teile:='I7O';
      171:  Teile:='I7I';
      172..179: Teile:='I'+InttoStr(txtbuffer-100);
      180:  Teile:='I8O';
      181:  Teile:='I8I';
      182..189: Teile:='I'+InttoStr(txtbuffer-100);
      190: Teile:='I9O';
      191: Teile:='I9I';
      192..199: Teile:='I'+InttoStr(txtbuffer-100);
      200: Teile:='2OO';
      201: teile:='2OI';
      202..209: Teile:='20'+IntToStr(txtbuffer-200);
      210: Teile:='2IO';
      211: Teile:='2II';
      212..219: Teile:='2I'+InttoStr(txtbuffer-210);
      220: Teile:='22O';
      221: Teile:='22I';
      222..229: Teile:=IntToStr(Txtbuffer);
      230: Teile:='23O';
      231: Teile:='23I';
      232..239: Teile:=IntToStr(txtbuffer);
      240: Teile:='24O';
      241: Teile:='24I';
      242..249: Teile:=IntToStr(TxtBuffer);
      250: Teile:='25O';
      251: Teile:='25I';
      252..255: Teile:=IntToStr(txtbuffer);
     end;   // case of end;
     infotexte:=infotexte+teile+' ';
    end;   // if end;
   end;   //while end
    memo1.text:=infotexte;
    infotexte:='';
    memo1.lines.savetofile(nameoffile2);
end;    // konvert-end

procedure TForm1.Konbin(Sender: TObject); // binr zu txt
begin
   While NOT EOF(txt) do begin   //ende des files ??
    BlockRead(txt,txtbuffer,1, ok);
    if ok >0 then begin
     txtlo:=inttohex(txtbuffer,1);
     if length(txtlo)=1 then txtlo:='O'+txtlo;   //groses Oh
     if (copy(txtlo,2,1)='0') then txtlo:=copy(txtlo,1,1)+'O';
     infotexte:=infotexte+txtlo;
    end; //if then
   end; //while end
   memo1.text:=infotexte;
   infotexte:='';
   memo1.lines.savetofile(nameoffile2);
end; //program

procedure TForm1.Kontxt(Sender: TObject);  // txt zu binr
begin
  assignfile(cif,nameoffile2);
  rewrite(cif,1);
  While NOT EOF(txt) do begin   //ende des files ??
    BlockRead(txt,wbuffer,2, ok);
    if (lo(wbuffer)=79) then lotxt:=0 else
     if (lo(wbuffer)>57) then lotxt:=lo(wbuffer)-55 else lotxt:=lo(wbuffer)-48;
    if (hi(wbuffer)=79) then hitxt:=0 else
     if (hi(wbuffer)>57) then hitxt:=hi(wbuffer)-55 else hitxt:=hi(wbuffer)-48;
    buffer:=(lotxt shl 4)+ hitxt;
    blockwrite(cif,buffer,1);
  end; //while end
   memo1.text:='Binre Zeichen werden hier nicht dargestellt !';
   infotexte:='';
end; //program

 procedure TForm1.BtHelpClick(Sender: TObject);
begin
 Application.HelpFile := 'Convert.HLP';
 Application.HelpContext(11);
end;


end.
