unit ExtdList;

(****************************************************************************

Delphi 1.0/2.0. Beyond ??   My first component, have mercy.

TExtdList is a TListBox with a TPanel that appears when the text of an
item in the listbox exceeds the listbox width less scroll bar if present.
ExtdList's owner MUST BE A FORM to work properly. The default Style is
lbOwnerDrawFixed also a must for ExtdList to do it's thing.

4 added properties, HiBackColor, HiFontColor, Extension, and ExtBevel.

HiBackColor and HiFontColor are active for both listbox or panel when an
item is focused or selected overriding normal accent.

Extension sets the direction the panel appears relative to the listbox
for overlong items either epLeft or epRight. When text exceeds FORM width
it is lead clipped if epLeft, tail clipped if epRight.

ExtBevel provides access to the panel bevel, none (default) or lowered.

Freeware...absolutely no warranties of any kind. Use at your own risk.

Roy Carter email roycarter.msn@attcanada.com

****************************************************************************)

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes,
     Graphics, Controls, Forms,    StdCtrls, ExtCtrls;

type TExPanel  = class(TPanel);
     TExPos    = (epRight, epLeft);
     TExBevel  = (ebNone,  ebLower);
     TExtdList = class(TListBox)
     private
       ExPanel : TExPanel;
       fExPos  : TExPos;
       fBcolor : TColor;
       fFcolor : TColor;
       fWidth  : integer;
       fBevel  : TExBevel;
       fShft   : byte;
     protected
       procedure Loaded; override;
       procedure DrawItem(Index: Integer; Rect : TRect;
                          State: TOwnerDrawState); override;
       procedure DoExit; override;

     public
       constructor Create(AOwner : TComponent); override;
     published
       property HiBackColor : TColor   read fBcolor write fBcolor;
       property HiFontColor : TColor   read fFcolor write fFcolor;
       property Extension   : TExPos   read fExPos  write fExPos;
       property ExtnBevel   : TExBevel read fBevel  write fBevel;
     end;

procedure Register;

implementation

constructor TExtdList.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  fBColor := clBlack;
  fFcolor := clWhite;
  fBevel  := ebNone;
  ExPanel := TExPanel.Create(Self);
end;

procedure TExtdList.Loaded;
begin
  inherited Loaded;
  Style   := lbOwnerDrawFixed;
  fFcolor := HiFontColor;
  fShft   := Ord(BorderStyle = bsSingle);
end;

procedure TExtdList.DoExit;
begin
  ItemIndex := -1;
  ExPanel.Hide;
  inherited DoExit;
end;

procedure TExtdList.DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState);
var W : integer;
begin
  inherited DrawItem(Index, Rect, State);
  if (odSelected in State) or (odFocused in State) then
  with Canvas do
  begin
    W := TextWidth(Items[Index]);
    Font.Color  := fFcolor;
    Brush.Color := fBcolor;
    if W <= Rect.Right then
    begin
      ExPanel.Hide;
      FillRect(Rect);
      TextOut(Rect.Left + 1, Rect.Top, Items[Index]);
    end
    else
    with ExPanel do
    begin
      if Parent <> TForm(GetParentForm(Self)) then
      begin
        Parent      := TForm(GetParentForm(Self));
        Font        := TExtdList(Owner).Font;
        Font.Color  := fFcolor;
        Color       := fBcolor;
        Height      := TExtdList(Owner).ItemHeight;
        if Extension = epRight then
            fWidth  := Parent.Width - TExtdList(Owner).Left - 12;
        Alignment   := taLeftJustify;
        BorderStyle := bsNone;
        if fBevel = ebNone then BevelOuter := bvNone
                           else BevelOuter := bvLowered;
      end;
      Caption := Items[Index];
      if (W + 4 > fWidth) and (Extension = epRight) then
          Width := fWidth + fShft else Width := W;
      Top := TExtdList(Owner).Top + Rect.Top + fShft;
      if fExPos = epRight then Left := TExtdList(Owner).Left + Succ(fShft)
      else Left := TExtdList(Owner).Left - Width + Rect.Right;
      Show;
    end;
  end;
end;

procedure Register;
begin
  RegisterComponents('Additional', [TExtdList]);
end;

end.
