unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DB, DBTables, Grids, DBGrids, TabNotBk, ExPars,
  Exprbldr, Exprfns, ExtCtrls, DBCtrls, Fnlists, Vars, ExFuncs, parstype;

type
  TForm1 = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    DBGrid1: TDBGrid;
    Table1: TTable;
    DataSource1: TDataSource;
    Database1: TDatabase;
    Button1: TButton;
    Button2: TButton;
    ExprParser1: TExParser;
    ExprFunctions1: TExprFunctions;
    ExprBuilderDlg1: TExprBuilderDlg;
    EPUserLib1: TEPUserLib;
    ExprSolver1: TExprSolver;
    Table1FormulaNo: TSmallintField;
    Table1Descr: TStringField;
    Table1Expression: TMemoField;
    Table1ExprStr: TStringField;
    Table1UserData: TBlobField;
    DBNavigator1: TDBNavigator;
    VarsTbl: TTable;
    DataTbl: TTable;
    DataSource2: TDataSource;
    Label5: TLabel;
    DBGrid2: TDBGrid;
    DBGrid3: TDBGrid;
    Label6: TLabel;
    Label7: TLabel;
    DBNavigator2: TDBNavigator;
    DBNavigator3: TDBNavigator;
    DataSource3: TDataSource;
    DataTblUDSetNo: TSmallintField;
    DataTblFieldValue1: TFloatField;
    DataTblFieldValue2: TFloatField;
    DataTblFieldValue3: TFloatField;
    VarsTblVarsSetNo: TSmallintField;
    VarsTblVar3: TFloatField;
    VarsTblVar4: TFloatField;
    VarsTblVar5: TFloatField;
    FnListBox1: TFnListBox;
    VarListBox1: TVarListBox;
    UserDataListBox1: TUserDataListBox;
    DBMemo1: TDBMemo;
    FnCategoryCombo1: TFnCategoryCombo;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Button3: TButton;
    Label15: TLabel;
    Label16: TLabel;
    EPRegFuncs1: TEPRegFuncs;
    EPVars1: TEPVars;
    EPVars1VAR1: TVariable;
    EPVars1VAR2: TVariable;
    EPVars1VAR3: TVariable;
    EPVars1VAR4: TVariable;
    EPVars1VAR5: TVariable;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    function ExprBuilderDlg1EditUserData(ExprBuilder: TExprBuilderDlg;
      var DataList: TUserDataList; Index: Integer;
      var UserData: TUserData): Boolean;
    function ExprParser1Variable(Sender: TObject;
      const VarName: String): Extended;
    function ExprParser1Function(Sender: TObject; const FuncName: String;
      const FuncParams: array of Extended): Extended;
    procedure ExprSolver1BeforeEvaluate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    IsSolveMode: Boolean;
  end;

  TMyUserData = class(TUserData)
  public
    FldName: string[30];
    procedure Assign(Source: TPersistent); override;
    procedure ReadFromStream(S: TStream); override;
    procedure WriteToStream(S : TStream); override;
  end;

  TMyUserDataList = class(TUserDataList)
  end;

var
  Form1: TForm1;

implementation

uses Unit2;
{$R *.DFM}

procedure TMyUserData.Assign(Source: TPersistent);
begin
   inherited Assign(Source);
   if Source is TMyUserData then begin
     FldName:=TMyUserData(Source).FldName;
   end;
end;
procedure TMyUserData.ReadFromStream(S: TStream);
begin
   inherited ReadFromStream(S);
   FldName:=ReadStr(S);
end;
procedure TMyUserData.WriteToStream(S : TStream);
begin
   inherited WriteToStream(S);
   WriteStr(S,FldName);
end;

(*********************************)

procedure TForm1.FormCreate(Sender: TObject);
begin
   RegisterClass(TMyUserData);
   RegisterClass(TMyUserDataList);
   IsSolveMode:=False;
   Table1.Open; VarsTbl.Open; DataTbl.Open;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   IsSolveMode:=False;
   ExprBuilderDlg1.Execute;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   IsSolveMode:=True;
   { Here you may place a code that finds appropriate records containing desired
     set of variable values in VarsTbl and/or DataTbl, or initilize them manually}
   MessageDlg('Result: '+FloatToStr(ExprSolver1.F([0])),mtInformation,[mbOK],0);
   IsSolveMode:=False;
end;

procedure TForm1.ExprSolver1BeforeEvaluate(Sender: TObject);
begin
   {Here you may place a code if you want to initilize some variables
   which values can't be fetched from INI-file or from a field in a dataset.
   A list of variables used by a given expression can be retrived
   from ExprParser1.UsedVariables }
end;

function TForm1.ExprBuilderDlg1EditUserData(ExprBuilder: TExprBuilderDlg;
  var DataList: TUserDataList; Index: Integer; var UserData: TUserData): Boolean;
var ADlg: TGetUserDataDlg;
    AddMode: Boolean;
    ACnt: Integer;
    LastCur: hCursor;
    EditUD: TMyUserData;
procedure InitilizeDialog;
begin
   with ADlg do begin
     Edit1.Text:=EditUD.Name;
     with ComboBox1 do ItemIndex:=Items.IndexOf(EditUD.FldName);
   end;
end;
procedure GetUserDataSettings;
begin
   with ADlg do begin
     EditUD.Name:=Edit1.Text;
     EditUD.FldName:=ComboBox1.Text;
   end;
end;
begin
   {if UserData is nil or Index is = -1 then Add button is pressed,
    and you must initilize UserData object. Probably you will use your own UserData,
    and the class must be descendant from TUserData class, and must be registered with RegisterClass,
    at the begining of your program}
   AddMode := UserData = nil;
   EditUD:=TMyUserData.Create;
   LastCur:=SetCursor(LoadCursor(0,idc_WAIT));
   ADlg:=TGetUserDataDlg.Create(Self);
   try
     if AddMode then begin
       if DataList=nil then ACnt:=0 else ACnt:=DataList.Count;
       EditUD.Name:='Data' + IntToStr(ACnt+1);
     end else EditUD.Assign(UserData);
     InitilizeDialog;
     Result:=ADlg.ShowModal = id_OK;
     if Result then begin
       {if DataList is nil, you may omit initilizing it, by default DataList will be initilized as TUserDataList.
        But this example will show you how you may define your own user data list object.
        Your user data list class must be derived from TUserDataList,
        and must be registered with procedure RegisterClass,
        at the begining of your program}
       if DataList=nil then DataList:=TMyUserDataList.Create;
       if UserData=nil then UserData:=TMyUserData.Create;
       GetUserDataSettings;
       UserData.Assign(EditUD);
     end;
   finally
     EditUD.Free; ADlg.Free; SetCursor(LastCur);
   end;
end;



function TForm1.ExprParser1Variable(Sender: TObject; const VarName: String): Extended;
var UserData: TUserDataList;
begin
   {if you specify the representation of the user data in expression to be by Name (UDRepresentAs:=udrt_Name),
   here you must check a VarName for any User data and return an Index of user data represented by VarName}
   If IsSolveMode then UserData:=ExprSolver1.UserData else UserData:=ExprBuilderDlg1.UserData;
   if UserData<>nil then Result:=UserData.IndexOf(VarName) else Result:=-1;
   if Result=-1 then raise EBadName.Create(msgInvalidIdent+': '+VarName);
end;

function TForm1.ExprParser1Function(Sender: TObject; const FuncName: String;
                const FuncParams: array of Extended): Extended;
var UserData: TUserDataList;
    UDIdx: Integer;
    AFldName: string[30];
begin
   If IsSolveMode then UserData:=ExprSolver1.UserData else UserData:=ExprBuilderDlg1.UserData;
   if FuncName = 'GETFLDVALUE' then begin
     if Integer(High(FuncParams))>=0 then begin
       try
         UDIdx:=Round(FuncParams[0]);
       except
         raise ESyntaxError.Create(msgMismatchArgs);
       end;
       if (UserData<>nil) and (UDIdx>=0) and (UDIdx<UserData.Count) then begin
         AFldName:=(UserData.Objects[UDIdx] as TMyUserData).FldName;
         Result:=DataTbl.FieldByName(AFldName).AsFloat;
       end else raise ESyntaxError.Create('Invalid UserData index');
     end else raise ESyntaxError.Create(msgMismatchArgs);
   end else raise EBadName.Create(msgInvalidIdent+': '+FuncName);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   with ExprParser1 do begin
     Expression:=DBMemo1.Lines;
     if Check(False) then MessageDlg('Expression is OK!',mtInformation,[mbOK],0);
   end;
end;

end.
