unit test;

interface

uses
  WinProcs, WinTypes, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ExtCtrls, explbtn, Buttons;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    PaintBox1: TPaintBox;
    OfficeButton1: TOfficeButton;
    PopupFile: TPopupMenu;
    New1: TMenuItem;
    Open1: TMenuItem;
    Exit1: TMenuItem;
    Panel2: TPanel;
    OfficeButton2: TOfficeButton;
    OfficeButton3: TOfficeButton;
    OfficeButton4: TOfficeButton;
    PopupEdit: TPopupMenu;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    Bevel1: TBevel;
    OfficeButton5: TOfficeButton;
    PaintBox2: TPaintBox;
    OfficeButton6: TOfficeButton;
    OfficeButton7: TOfficeButton;
    Memo: TMemo;
    OpenDialog: TOpenDialog;
    procedure PaintBox1Paint(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure MenuItem1Click(Sender: TObject);
    procedure MenuItem2Click(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure DrawFancyBars(canvas: TCanvas; height: integer);
var
	r: TRect;
begin
   r.Left := 3;
   r.Right := 5;
   r.Top := 3;
   r.Bottom := Height - 2;
   Frame3D(Canvas, r, clBtnHighlight, clBtnShadow, 1);
   r.Left := 6;
   r.Right := 8;
   r.Top := 3;
   r.Bottom := Height - 2;
   Frame3D(Canvas, r, clBtnHighlight, clBtnShadow, 1);
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
	DrawFancyBars((Sender as TPaintBox).Canvas, (Sender as TPaintBox).Height);
end;

procedure TForm1.New1Click(Sender: TObject);
begin
	Memo.Lines.Clear;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
	if OpenDialog.Execute then
  	Memo.Lines.LoadFromFile(OpenDialog.Filename);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
	Close;
end;

procedure TForm1.MenuItem1Click(Sender: TObject);
begin
	Memo.CutToClipboard;
end;

procedure TForm1.MenuItem2Click(Sender: TObject);
begin
	Memo.CopyToClipboard;
end;

procedure TForm1.MenuItem3Click(Sender: TObject);
begin
		Memo.PasteFromClipboard;
end;

end.
