unit Sequence;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons;

type
  TFormSequence = class(TForm)
    Panel1: TPanel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    GpBoxFirst: TGroupBox;
    RdButXOR1: TRadioButton;
    RdButMove1: TRadioButton;
    RdButTurning1: TRadioButton;
    GpBoxSecond: TGroupBox;
    RdButXOR2: TRadioButton;
    RdButMove2: TRadioButton;
    RdButTurning2: TRadioButton;
    GpBoxThird: TGroupBox;
    RdButMove3: TRadioButton;
    RdButXOR3: TRadioButton;
    RdButTurning3: TRadioButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Memo1: TMemo;
    EdResult: TEdit;

    procedure RdButXOR1Click(Sender: TObject);
    procedure RdButMove1Click(Sender: TObject);
    procedure RdButTurning1Click(Sender: TObject);
    procedure RdButXOR2Click(Sender: TObject);
    procedure RdButMove2Click(Sender: TObject);
    procedure RdButTurning2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FSequenceOut: String;
    Procedure FindLast;
    Function ReadSequence: String;
  public
    { Public declarations }
    property SequenceOut: String read FSequenceOut;
  end;

var
  FormSequence: TFormSequence;

implementation

{$R *.DFM}

procedure TFormSequence.RdButXOR1Click(Sender: TObject);
begin
  RdButXOR2.checked := False;
  RdButXOR3.checked := False;
  RdButXOR2.enabled := False;
  RdButmove2.enabled := True;
  RdButTurning2.enabled := True;
end;

procedure TFormSequence.RdButMove1Click(Sender: TObject);
begin
  RdButmove2.checked := False;
  RdButmove3.checked := False;
  RdButXOR2.enabled := True;
  RdButmove2.enabled := False;
  RdButTurning2.enabled := True;
end;

procedure TFormSequence.RdButTurning1Click(Sender: TObject);
begin
  RdButTurning2.checked := False;
  RdButTurning3.checked := False;
  RdButXOR2.enabled := True;
  RdButMove2.enabled := True;
  RdButTurning2.enabled := False;
end;

procedure TFormSequence.RdButXOR2Click(Sender: TObject);
begin
  RdButXOR3.checked := False;
  RdButXOR3.enabled := False;
  FindLast;
end;

procedure TFormSequence.RdButMove2Click(Sender: TObject);
begin
  RdButmove3.checked := False;
  RdButmove3.enabled := False;
  FindLast;
end;

procedure TFormSequence.RdButTurning2Click(Sender: TObject);
begin
  RdButTurning3.checked := False;
  RdButTurning3.enabled := False;
  FindLast;
end;

Procedure TFormSequence.FindLast;
var
  Str: String;
  Checked: Array[1..3] of Boolean;
  i: Integer;
begin
  Str := ReadSequence;
  if Length(Str) < 3 then
  begin
    for i := 1 to 3 do
    Checked[i] := False;
    for i := 1 to 2 do
    begin
      case Str[i] of
        '1': Checked[1] := True;
        '2': Checked[2] := True;
        '3': Checked[3] := True;
      end;
    end;
    for i := 1 to 3 do
    begin
      case Checked[i] of
        False : Str := Str + IntToStr(i);
      end;
    end;
    if not Checked[1] then RdButXOR3.checked := True;
    if not Checked[2] then RdButMove3.checked := True;
    if not Checked[3] then RdButTurning3.checked := True;
  end;
  EdResult.Text := Str;
end;

Function TFormSequence.ReadSequence: String;
var
  Str: String;
begin
  Str := '';
  if RdButXOR1.checked then Str := '1';
  if RdButMove1.checked then Str := '2';
  if RdButTurning1.checked then Str := '3';

  if RdButXOR2.checked then
    Str := Str + '1';
  if RdButMove2.checked then
    Str := Str + '2';
  if RdButTurning2.checked then
    Str := Str + '3';

  if RdButXOR3.checked then
    Str := Str + '1';
  if RdButMove3.checked then
    Str := Str + '2';
  if RdButTurning3.checked then
    Str := Str + '3';
  ReadSequence := Str;
end;

procedure TFormSequence.BitBtn1Click(Sender: TObject);
begin
  FSequenceOut := EdResult.Text;
end;

procedure TFormSequence.FormCreate(Sender: TObject);
begin
  FSequenceOut := '123';
end;

end.
