(*
 EditNew.pas

 Comment in English y en Espaol por supuesto.

 English
 -------------------------------------------------------------------------------
 - Author   : Jos M Gas
 - email    : sigecom@bbvnet.es
 - Version  : 1.03
 - Date     : 07.12.97
 - Type     : FreeWare

 - Component enlarged TEdit that tries to integrating many of the actions that
   customarily they are accomplished in the applications upon using the component
   TEdit standar, and adds the following properties:

   ColorOnFocus    - Back Color when the Edit has the focus

   ColorOnNotFocus - Back Color when the Edit Does not has the focus

   EditType        - etString, etInteger, etFloat. Consideration of the data
                     that it will contain the Edit

   EditAlign       - etAlignRight, etAlignLeft, etAlignCenter, etAlignNone.
                     Align the string, with respect to the indicated length
                     in EditLengthAlign, when EditType = etString

                     etAlignValue. If EditType = etInteger or etFLoat, fills with 0
                     the spaces to the left of the String until completing the
                     quantity of characters indicated in EditLengthAlign.
                     Observe the negative sign if it has been introduced, and
                     the separating decimal counting as a char more of the string.

   EditLengthAlign - Length of the string when it is aligned. Have into account
                     when EditAlign <> etAlignNone, and is fulfilled indicated
                     what is for EditAlign

   ValueInteger     - Integer Value of the Edit, when EditType = etInteger
                     If is produced a conversion mistake would return 0

   ValueFloat       - FloatValue of the Edit, when EditType = etFloat
                     If is produced a conversion mistake would return 0

   EditPrecision   - Permits to define the quantity of decimal. If the value is
                     greater than 0, format the value, completing with zeroes to
                     the end if there is no decimal introduced.

                     ## In the case of be value Float, the separating decimal it
                     catch by defect of Windows.

   KeyByTab        - Response upon pulsateing a key as if is pulsateed Tabulator
                     to leave of the component happening the focus to the
                     following, with the value of other key.

                     For defect is assigned the standar of Windows Tabulator for
                     to annul it: KeyByTab = #9

                     For example, if we wish that of a TEditN could be happened
                     the focus to the following object with the Return key, in
                     addition to with the Tabulator, we would put this value to
                     KeyByTab = #13

   FirstCharUpper  - Converts to Uppers the first char of the string if
                     EditType = etString

   WidthOnFocus    - Permits to define a width of the different EditN when the
                     EditN has the Focus. The width is not adjusted in function
                     of the introduced text, being had to be defined in design
                     mode.

   SetInteger      - Procedure, by the one which can allot directly a value
                     Integer to the EditN, when it is defined as etInteger
                     Example:   EditN10.SetInteger(63565);

   SetFloat        - Procedure, by the one which can allot directly a value
                     Float to the EditN, when it is defined as etFloat.
                     Example:   EditN9.SetFloat(- 63,56);

 ###############################################################################

 Version 1.01

  - Include controls to avoid that is generated exception upon converting a
    value integer, when it exceeds of the maximum ranges of said type.

    In this case, it notifies of the fact that it has been exceeded of the
    range, and lets ValueInteger = 0

  - Include control so that when it is a value Float could not be introduced
    but of 20 digits

 ###############################################################################

 Version 1.02

  - Amends an existing Bug when the EditType = etString or etFloat, and is loaded
    directly a value on the EditNew, so that ValueInteger and ValueFloat they
    are not updated. Part of the procedure DoExit has been separated to Change.

  - Is added a control to eliminate the characters not permitted, before
    to convert to Integer or Float.

  - Change control so that when it is a value Float could not be introduced
    but of 16 digits. Now ValueFloat is Double, before is Extended.

  - Is added the property WidthOnFocus for power to configure a Width of the Edit
   when this has the Focus. It is valid when its value is greater than 0

 -------------------------------------------------------------------------------
 ## The following properti are introduced by Raymond Kleefstra:

 - Raymond Kleefstra
 - mail: malloc@stad.dsl.nl
 - URL:  http://stad.dsl.nl/~malloc

  TextAtEnter     - Memories the exact text as it was when the field is entered.
                    Is used to cancel changed when ESC is pressed

 ###############################################################################

 Version 1.03   07.12.1997

 - Is amended an Bug of the prior version, by the one which the property MaxLength
   it is put automatically with value 10.

 - Is amended a Bug that was happening in manner diseo, upon defining
   etInteger or etFloat and to enter to erase the value of Text, gave a Range
   error

 - Is included in the refunding of FirstCharUpper in the proceeding OnExit, for
   the case of the fact that is traded to the first position during the edition.

 - Is traded the decision of the events OnKeyPress, OnEnter, OnExit, OnChange
   to the public part for power to use them thereinafter

 - Is included the option of introducing directly a value Integer or Float
   according to this the property EditType, with the proceeding SetInteger or
   SetFloat respectively. To see the demo for its operation

 ###############################################################################
 To be Freeware, they are not offered guarantees of no class neither are admitted
 claims of no type.

 This component can be used, be distributed and be modified freely for use
 particular or didactic, but not for commercial use. For commercial use be put
 in touch with the author.

 This component can be put on the page WEB that is wished, be redistributed
 with an application freely, or be included in any book, CDROM or any other
 middle, as long as is included 100% of the content of the component.

 It will be thanked the one which any commentary, alteration or improvement
 introduced in the component is transmitted to the author.

 -------------------------------------------------------------------------------
 Espaol
 -------------------------------------------------------------------------------
 - Autor     : Jos.M Gas
 - email     : sigecom@bbvnet.es
 - Versin   : 1.03
 - Fecha     : 07.12.97
 - Tipo      : FreeWare

 - Componente TEdit ampliado, que trata de integrar muchas de las acciones que
   habitulmente se realizan en las aplicaciones al utilizar el componente TEdit
   estandar, y aade las siguientes propiedades:

   ColorOnFocus    - Color de fondo cuando el Edit tiene el Foco

   ColorOnNotFocus - Color de fondo cuando el Edit No tiene el Foco

   EditType        - etString, etInteger, etFloat. Consideracin de los datos
                     que contendr el Edit

   EditAlign       - etAlignRight, etAlignLeft, etAlignCenter, etAlignNone.
                     Alinean la cadena, con respecto a la longitud indicada
                     en EditLengthAlign, cuando EditType = etString

                     etAlignValue. Si EditType = Integer o FLoat, rellena con 0
                     los espacios a la Izqda. de la cadena, hasta completar la
                     cantidad de caracteres indicada en EditLengthAlign.
                     Respeta el signo negativo si se ha introducido, y el separador
                     decimal contando como un caracter mas de la cadena.

   EditLengthAlign - Longitud de la cadena cuando es alineada. Se tiene en cuenta
                     cuando EditAlign <> etAlignNone, y se cumple lo indicado para
                     EditAlign

   ValueInteger    - Valor Integer del Edit, cuando EditType = etInteger
                     Si se produjera un error de conversin devolvera 0

   ValueFloat      - Valor Float del Edit, cuando EditType = etFloat
                     Si se produjera un error de conversin devolvera 0

   EditPrecision   - Permite definir la cantidad de decimales. Si el valor es
                     mayor de 0, formatear el valor, completando con ceros al
                     final si no hay decimales introducidos.

                     ## En el caso de ser valor Float, el separador decimal lo
                     coge por defecto de Windows.

   KeyByTab        - Respuesta al pulsar una tecla como si se pulsara Tabulador
                     para salir del componente, pasando el foco al siguiente, con
                     el valor de otra tecla.

                     Por defecto se asigna el estandar de Windows Tabulador, para
                     anularlo: KeyByTab = #9

                     Por ejemplo, si deseamos que de un TEditN se pueda pasar el
                     foco al siguiente objeto con la tecla Enter ademas de con
                     el Tabulador, pondriamos esta valor a KeyByTab = #13

   FirstCharUpper  - Convierte a mayusculas el primer Caracter de la cadena si
                     EditType = etString

   WidthOnFocus    - Permite definir una anchura del TEditN diferente cuando el
                     EditN tiene el Foco. La anchura no se ajusta en funcin del
                     texto introducido, debiendose definirse en modo diseo.

   SetInteger      - Procedure, por el cual podemos asignar directamente un valor
                     Integer al TEditN, cuando est definido como etInteger
                     Ejemplo:   EditN10.SetInteger(63565);

   SetFloat        - Procedure, por el cual podemos asignar directamente un valor
                     Float al TEditN, cuando est definido como etFloat.
                     Ejemplo:   EditN9.SetFloat(-63,56);

 ###############################################################################
 Version 1.01   05.06.1997

  - Incluye controles para evitar que se genere excepcion al convertir un valor
    Integer, cuando excede de los rangos mximos de dicho tipo.

    En este caso, avisa de que se ha excedido del rango, y deja ValueInteger = 0

  - Incluye control para que cuando es un valor Float no puedan introducirse
    mas de 20 dgitos

 ###############################################################################
 Version 1.02   25.07.1997

  - Corrige un Bug existente cuando el EditType = etString o etFloat, y se carga
    directamente un valor sobre el EditNew, de forma que ValueInteger y
    ValueFloat no se actualizan. Parte del procedimiento DoExit se ha separado
    a Change.

  - Se aade un control para eliminar los caracteres no permitidos, antes de
    convertir a Integer o Float.

  - Value Float se cambia de tipo Extended a Double por ser el genricamente
    mas utilizado.

  - Se aade la propiedad WidthOnFocus para disponer de un ancho del Edit
    configurable cuando este tiene el Foco. Se tiene en cuenta cuando su valor
    es mayor de 0

 -------------------------------------------------------------------------------
 Cambios por Raymond Kleefstra

 - Raymond Kleefstra
 - mail: malloc@stad.dsl.nl
 - URL:  http://stad.dsl.nl/~malloc

  - Al pulsar la tecla Escape, anula los cambios, en lugar de borrar el contenido

 ###############################################################################
 Version 1.03   07.12.1997

 - Se corrige un Bug de la versin anterior, por el cual la propiedad MaxLength
   se ponia automticamente con valor 10.

 - Se corrige un Bug que ocurra en modo diseo, al definir etInteger o etFloat,
   y entrar a borrar el valor de Text, daba un error de Rango

 - Se incluye en la conversin de FirstCharUpper en el procedimiento OnExit,
   para el caso de que se cambie a la primera posicin durante la edicin.

 - Se cambia la definicin de los eventos OnKeyPress, On Enter, OnExit, OnChange
   a la parte pblica para poder utilizarlos posteriormente

 - Se incluye la opcin de introducir directamente un valor Integer o Float segn
   este la propiedad EditType, con el procedimiento SetInteger o SetFloat
   respectivamente. Ver la demo para su funcionamiento

 ###############################################################################
 Al ser Freeware, no se ofrecen garantas de ninguna clase, ni se admiten
 reclamaciones de ningun tipo.

 Este componente puede usarse, distribuirse y modificarse libremente para uso
 particular o didctico, pero no para uso comercial. Para uso comercial ponerse
 en contacto con el autor.

 Este componente puede ponerse en la pgina WEB que se desee, redistribuirse con
 una aplicacin libremente, o incluirse en cualquier libro, CDROM o cualquier
 otro medio, siempre que se incluya el 100% del contenido del componente.

 Se agradecer el que cualquier comentario, correccin o mejora introducida en
 el componente se remita al autor.

*)

unit EditNew;

interface

uses
  {$IFDEF WIN32}Windows,{$ELSE}Winprocs,{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TEditTypes = (etString, etInteger, etFloat);
  TEditAlign = (etAlignRight, etAlignLeft, etAlignCenter, etAlignNone, etAlignValue);

  TEditN = class(TEdit)
  private
    { Private declarations }
    FOnEnter      : TNotifyEvent;
    FOnExit       : TNotifyEvent;
    FOnChange     : TNotifyEvent;
    I_Color       : TColor;
    E_Color       : TColor;
    TipoEdit      : TEditTypes;
    TipoAlign     : TEditAlign;
    KeyTab        : Char;
    LongAlign     : Integer;
    ValInteger    : Integer;
    ValFloat      : Double;
    SDecimal      : Char;
    EPrecision    : Integer;
    FUpper        : Boolean;
    ValTemp       : Extended;
    TxtConvert    : String;   {New in Version 1.02}
    FWidthOnFocus : Integer;  {New in version 1.02}
    iWidth        : Integer;  {New in version 1.02}
    TextAtEnter   : String;   {New in version 1.02 by Raymond Kleefstra}
  protected
    { Protected declarations }
  public
    procedure KeyPress(var Key: Char); override;
    procedure DoEnter; override;
    procedure DoExit; override;
    procedure Change; override;
    procedure SetInteger(VInteger : Integer);          {New in version 1.03}
    procedure SetFloat(VFloat : Double);               {New in version 1.03}
    constructor Create(AOwner : TComponent); override;
  published
    property  OnEnter: TNotifyEvent read FOnEnter write FOnEnter; {Change in version 1.01}
    property  OnExit : TNotifyEvent read FOnExit  write FOnExit;  {Change in version 1.01}
    property  OnChange : TNotifyEvent read FOnChange  write FOnChange; {New in version 1.02}
    property  ColorOnFocus : TColor read I_Color write I_Color;
    property  ColorOnNotFocus : TColor read E_Color write E_Color;
    property  EditType : TEditTypes read TipoEdit write TipoEdit;
    property  EditKeyByTab : Char read KeyTab write KeyTab;
    property  EditAlign : TEditAlign read TipoAlign write TipoAlign;
    property  EditLengthAlign : Integer read LongAlign write LongAlign;
    property  ValueInteger : Integer read ValInteger write ValInteger;
    property  ValueFloat : Double read ValFloat write ValFloat;
    property  EditPrecision : Integer read EPrecision write EPrecision;
    property  FirstCharUpper : Boolean read FUpper write FUpper;
    property  WidthOnFocus : Integer read FWidthOnFocus write FWidthOnFocus; {New in version 1.02}
  end;

procedure Register;

implementation

constructor TEditN.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  ColorOnFocus    := clWhite;
  ColorOnNotFocus := clSilver;
  Color           := ColorOnNotFocus;
  TipoEdit        := etString;
  TipoAlign       := etAlignNone;
  LongAlign       := 0;
  KeyTab          := #9;
  ValInteger      := 0;
  ValFloat        := 0;
  EPrecision      := 0;
  SDecimal        := DecimalSeparator;
  FUpper          := False;
  FWidthOnFocus   := 0;  {New in version 1.02}
  TextAtEnter     := ''; {New in version 1.02 by Raymond Kleefstra}
end;

procedure TEditN.KeyPress(var Key: Char);
var
 {$IFDEF VER100}
  FEditTemp : TCustomForm; {For Delphi 3}
 {$ELSE}
  FEditTemp : TForm;       {For Delphi 1 - 2}
 {$ENDIF}
 C         : String;
begin

 if Key = EditKeyByTab then begin
  FEditTemp := GetParentForm(Self); {Change declaration in "var" for Delphi version}
  SendMessage(FEditTemp.Handle, WM_NEXTDLGCTL, 0, 0);
  Key := #0;
 end else begin
  if Key = #27 then begin  {Change in version 1.02 by Raymond Kleefstra}
   Text := TextAtEnter; {If ESC is pressed during edit, all changes are cancelled
                         Si se ha pulsado escape, se anulan los cambios}
   Key  := #15; {Delete'the ESC-key press
                 Borrar la pulsacin de la tecla escape}
  end;

  if EditType = etString then begin
    {To put the first char with capital letters upon beginning to write
     Poner el primer caracter con mayusculas al comenzar a escribir}
    if FUpper then begin {Change in Version 1.03}
     if Length(Text) = 0 then begin
      C   := AnsiUpperCase(Key);
      Key := C[1];
     end;
    end;

   {To try the alone chain when it is numerical, to avoid to introduce  wrong
    characters
    Tratar la cadena solo cuando es numerica, para evitar introducir caracteres
    erroneos}
  end else begin

   {Permitted characters when it is Integer
    Caracteres permitidos cuando es Integer}
   if EditType = etInteger then begin
    if ((Pos('-',Text) > 0) or (Key = '-')) and (MaxLength = 0) then MaxLength := 11;
    if not (Key in ['0'..'9','-',#8,#13,#35,#36,#37,#39]) then Key := #15;
   end;

   {Permitted characters when it is Float
    Caracteres permitidos cuando es Float}
   if EditType = etFloat then begin
    if not (Key in ['0'..'9',',','.','-',#8,#13,#35,#36,#37,#39]) then Key := #15;
    if (Key = ',') or (Key = '.') then
     if (Pos(',',Text) > 0) or (Pos('.',Text) > 0)
      then Key := #15
      else Key := DecimalSeparator;
   end;

   {To eliminate the introduction from spaces
    Eliminar la introduccion de espacios}
   if Key = #32 then Key := #15;

   {To verify that alone is introduce a negative sign.
    Verificar que solo se introduzca un signo negativo.}
   if (Key = '-') and (Pos('-',Text) > 0) then Key := #15;

  end;
 end;
 if Key <> #0 then inherited KeyPress(Key);
end;

procedure TEditN.DoEnter;
begin
 {To assign the Color upon receiving the focus
  Asignar el Color al recibir el foco}
 if (EditType = etFloat) and (MaxLength = 0) then MaxLength := 16; {Change in Version 1.03}
 Color       := ColorOnFocus;
 TextAtEnter := Text; {New in version 1.02 by Raymond Kleefstra}

 if WidthOnFocus > 0 then begin {New in version 1.02}
  iWidth := Width;
  Width  := FWidthOnFocus;
 end;

 if Assigned(FOnEnter) then FOnEnter(Self);
end;

procedure TEditN.DoExit;
var
 k : Integer;
 s : String;
begin
 {To return the color of the fund upon leaving and losing the focus
  Devolver el color del fondo al salir y perder el foco}
 Color := ColorOnNotFocus;

 if WidthOnFocus > 0 then Width := iWidth; {New in version 1.02}

 {Alignment of the String, when have a form defined alignment
  Alineacion de Cadenas String, cuando tienen una forma alineacion definida}
 if (EditType = etString) and (Length(Text) > 0) then begin {String}
  {Poner el primer caracter en maysculas}
  if FUpper then begin
   if Length(Text) = 1 then Text := AnsiUpperCase(Text);
   if Length(Text) > 1 then Text := AnsiUpperCase(Text[1]) + Copy(Text,2,Length(Text)-1);
  end;

  if (EditAlign <> etAlignNone) and (EditLengthAlign > 0) then begin {With Alignment
                                                                      Con alineacion}
   if (EditAlign = etAlignLeft) then
    while Copy(Text,1,1) = ' ' do Text := Copy(Text,2,Length(Text)-1);

   {The length of the chain is < that that of Align.
    La long. de la cadena es < que la de Align.}
   if (EditLengthAlign > Length(Text)) then begin

    if (EditAlign = etAlignLeft) then {Left  -  Izqda}
     for k:= 1 to EditLengthAlign - Length(Text) do Text := Text + ' ';

    if (EditAlign = etAlignRight)  then {Right  -  Dcha}
     for k:= 1 to EditLengthAlign - Length(Text) do Text := ' ' + Text;

    if (EditAlign = etAlignCenter) then begin {Center  -  Centrado}
     for k := 1 to Round((EditLengthAlign - Length(Text))/2) do Text := ' ' + Text; {Left - Izqda}
     for k := Length(Text) to EditLengthAlign do Text := Text + ' '; {Right - Dcha}
    end;

   end;
  end;
 end;

 {To align a string Integer, filling with zeroes, if it has been indicated.
  The negative sign if exists, counts it as a digit but
  Alinear una cadena Integer, rellenando de ceros, si se ha indicado.
  El signo negativo si existe, lo cuenta como un digito mas}
 if (EditType = etInteger) and (EditAlign = etAlignValue) and
    (EditLengthAlign > 0) then
  if Length(Text) < EditLengthAlign then
   for k := Length(Text) to EditLengthAlign - 1 do Text := '0' + Text;

 {To put the negative sign to the beginning of the chain. It has been designed
  so that the negative sign could be introduced in any place, and here we happen
  it to the beginning
  Colocar el signo negativo al comienzo de la cadena. Se ha diseado para que el
  signo negativo pueda introducirse en cualquier lugar, y aqu lo pasamos al
  comienzo}
 if (EditType <> etString) and (Pos('-',Text) > 1) then
  if Length(Text) = Pos('-',Text)
   then Text := '-' + Copy(Text,1,Pos('-',Text)-1)
   else Text := '-' +
                Copy(Text,1,Pos('-',Text)-1) +
                Copy(Text,Pos('-',Text) + 1,Length(Text) - Pos('-',Text));

 {If it has been defined precision, gives format  to the string
  Si se ha definido precisin, formatea la cadena}
 if (EditType = etFloat) and (EditPrecision > 0) then begin
  if Length(Text) = 0 then Text := '0';
  SDecimal := DecimalSeparator;
  if Pos(SDecimal,Text) = 0 then begin
   Text := Text + SDecimal;
   for k := 1 to EditPrecision do Text := Text + '0';
  end else begin
   if Length(Text) - Pos(SDecimal,Text) > EditPrecision then
    Text := Copy(Text,1,Pos(SDecimal,Text) + EditPrecision);
   if Length(Text) - Pos(SDecimal,Text) < EditPrecision then
    for k := Length(Text) - Pos(SDecimal,Text) + 1 to EditPrecision do Text := Text + '0';
  end;
 end;

 {To align a string Float, filling of zeroes, if it has been indicated.
  The negative sign if exists and the separating decimal, the account as a digit but
  Alinear una cadena Float, rellenando de ceros, si se ha indicado.
  El signo negativo si existe y el separador decimal, los cuenta como un digito mas}
 if (EditType = etFloat) and (EditAlign = etAlignValue) and
    (EditLengthAlign > 0) then
 if Length(Text) < EditLengthAlign then
  for k := Length(Text) to EditLengthAlign - 1 do Text := '0' + Text;

 if Assigned(FOnExit) then FOnExit(Self);
end;

procedure TEditN.Change; {New and change in version 1.02}
var
 i : Integer;
 C : String;
begin
  {To convert the chain if it is numerical,to return a value
 Convertir la cadena si es numrica para devolver un valor}
 if ((EditType = etInteger) or (EditType = etFloat)) and (Length(Text) > 0) then begin

  if EditType = etInteger then begin  {New in version 1.03}
   for i := 1 to Length(Text) do begin
    if Text[i] in ['0'..'9','-','+'] then C := C + Text[i]
   end;
   Text := C;
  end;

  if EditType = etFloat then begin    {New in version 1.03}
   for i := 1 to Length(Text) do begin
    if Text[i] in ['0'..'9',',','.','-','+'] then C := C + Text[i]
   end;
   Text := C;
  end;

  if Length(Text) = 0 then begin      {New in version 1.03}
   if Assigned(FOnChange) then FOnChange(Self);
   Exit;
  end;

  try
   ValueFloat   := 0;
   ValueInteger := 0;

   {Eliminar caracteres no permitidos y cambiar el signo - al comienzo para
    que no de error de conversin}
   i := 1;
   while i <= Length(Text) do
    if not (Text[i] in ['0'..'9',',','.','-'])
     then Text := Copy(Text,1,i-1) + Copy(Text,i+1,Length(Text)-i)
     else i := i + 1;

   {Si solo tenemos el signo negativo, dara error}
   if (Pos('-',Text) = 1) and (Length(Text) = 1) then Exit;

   {Temporary variable to accomplish the conversion
    Variable temporal para realizar la conversin}
   TxtConvert := Text;

   {To put the negative sign to the beginning
    Posicionamos el signo negativo al comienzo}
   if (EditType <> etString) and (Pos('-',TxtConvert) > 1) then
    if Length(TxtConvert) = Pos('-',TxtConvert)
     then TxtConvert := '-' + Copy(TxtConvert,1,Pos('-',TxtConvert)-1)
     else TxtConvert := '-' +
                        Copy(TxtConvert,1,Pos('-',TxtConvert)-1) +
                        Copy(TxtConvert,Pos('-',TxtConvert) + 1,Length(TxtConvert) - Pos('-',TxtConvert));

   if EditType = etInteger then begin
    {Range control of Integer
     Control de rango del valor Integer}
    ValTemp := StrToFloat(TxtConvert);
    if (ValTemp > 2147483647) or (ValTemp < -2147483647) then begin
     ShowMessage('Range Max. : -2147483647 <-> 2147483647');
     ValueInteger := 0;
    end else ValueInteger := StrToInt(TxtConvert);
   end;

   {El tipo Float - Double, permite valores hasta 5.0 * 10e-324 .. 1.7 * 10e308
   con 15-16 digitos significativos, por lo que solamente controlamos que el total
   no pase de 16 digitos. Hasta la fecha no he experimentado con valores Float tan
   altos, por lo que no me atrevo a condicionar algo que no conozco con exactitud.}
   if EditType = etFloat then begin
    ValueFloat   := StrToFloat(TxtConvert);
   end;

  except
   on EConvertError do begin
     ShowMessage('Range Max. :' + #13 +
                 ' - Integer : -2147483647 <-> 2147483647' + #13 +
                 ' - Float   : 5.0e-324 <-> 1.7e+308');
     ValueInteger := 0;
     ValueFloat   := 0;
   end;
  end;
 end;

 if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TEditN.SetInteger(VInteger : Integer);
begin
 if EditType = etInteger then Text := IntToStr(VInteger);
end;

procedure TEditN.SetFloat(VFloat : Double);
begin
 if EditType = etFloat then Text := FloatToStr(VFloat);
end;

procedure Register;
begin
  RegisterComponents('Standard', [TEditN]);
end;

end.
