unit Wsapi;

interface
{
  Winsock.h file for Delphi Based on a conversion by
  Marc B. Manza of Center for Applied Large-Scale Computing
  as modified by Mike Caughran of Cedar Island Software in Nov 1994
  winsock.inc, winsock.if & winsock.imp

  Converted to a single unit by Keith Hawes. For use with Delphi and
  dWinSock.pas (A Delphi WinSock VCL)

}

Uses WinTypes, WinProcs, dwsError;

type
  TSock = integer;

const
  FD_SETSIZE = 64;

type
  fd_set = record
    fd_count : word;
    fd_array : array[0..FD_SETSIZE-1] of TSock;
  end;

  timeval = record
    tv_sec, tv_usec : longint;
  end;

const
  IOCPARM_MASK   =   $007f;
  IOC_VOID       =   $20000000;
  IOC_OUT        =   $40000000;
  IOC_IN         =   $80000000;
  IOC_INOUT      =   (IOC_IN OR IOC_OUT);

  MAXGETHOSTSTRUCT   =  1024;


type
  PPchar = ^PChar;
  u_int = cardinal;

  hostent = record
    h_name : PChar;
    h_aliases : PPChar;
    h_addrtype : SmallInt;
    h_length : SmallInt;
    h_addr_list : PPChar;
   {  h_addr : PChar; }
  end;

  netent = record
    n_name : PChar;
    n_aliases : ^PChar;
    n_addrtype : SmallInt;
    n_net : LongInt;
  end;

  servent = record
    s_name : PChar;
    s_aliases : ^PChar;
    s_port : SmallInt;
    s_proto : PChar;
  end;

  protoent = record
    p_name : PChar;
    p_aliases : ^Pchar;
    p_proto : SmallInt;
  end;

PAsyncBuf = ^TAsyncBuf;
TAsyncBuf = record { KH Used in calls to WASAsyncXbyY calls }
  case byte of
    0: (Host:     Hostent);
    1: (Service:  ServEnt);
    2: (Protocol: ProtoEnt);
  255: (Reserved: array[1..MaxGetHostStruct] of byte);
end;

const
  IPPROTO_IP     =   0;
  IPPROTO_ICMP   =   1;
  IPPROTO_GGP    =   2;
  IPPROTO_TCP    =   6;
  IPPROTO_PUP    =   12;
  IPPROTO_UDP    =   17;
  IPPROTO_IDP    =   22;
  IPPROTO_ND     =   77;

  IPPROTO_RAW    =   255;
  IPPROTO_MAX    =   256;

  IPPORT_ECHO    =   7;
  IPPORT_DISCARD =   9;
  IPPORT_SYSTAT  =   11;
  IPPORT_DAYTIME =   13;
  IPPORT_NETSTAT =   15;
  IPPORT_FTP     =   21;
  IPPORT_TELNET  =   23;
  IPPORT_SMTP    =   25;
  IPPORT_TIMESERVER  =  37;
  IPPORT_NAMESERVER  =  42;
  IPPORT_WHOIS       =  43;
  IPPORT_MTP         =  57;

  IPPORT_TFTP        =  69;
  IPPORT_RJE         =  77;
  IPPORT_FINGER      =  79;
  IPPORT_TTYLINK     =  87;
  IPPORT_SUPDUP      =  95;

  IPPORT_EXECSERVER  =  512;
  IPPORT_LOGINSERVER =  513;
  IPPORT_CMDSERVER   =  514;
  IPPORT_EFSSERVER   =  520;

  IPPORT_BIFFUDP     =  512;
  IPPORT_WHOSERVER   =  513;
  IPPORT_ROUTESERVER =  520;

  IPPORT_RESERVED    =  1024;

  IMPLINK_IP         =  155;
  IMPLINK_LOWEXPER   =  156;
  IMPLINK_HIGHEXPER  =  158;

Type
  SunB = record
    s_b1, s_b2, s_b3, s_b4 : Byte;
  end;

  SunW = record
    s_w1, s_w2 : Word;
  end;

  in_addr = record
    case integer of
      0 : (S_un_b : SunB);
      1 : (S_un_w : SunW);
      2 : (S_addr : LongInt);
    end;

var
  S_un : in_addr;

type
  sockaddr_in = record
    sin_family : SmallInt;
    sin_port : Word;
    sin_addr : in_addr;
    sin_zero : array[0..7] of char;
  end;

const
  WSADESCRIPTION_LEN     =   256;
  WSASYS_STATUS_LEN      =   128;

type
  LPWSADATA = ^WSAData;
  WSAData = record
    wVersion : word;
    wHighVersion : word;
    szDescription : array[0..WSADESCRIPTION_LEN] of char;
    szSystemStatus : array[0..WSASYS_STATUS_LEN] of char;
    iMaxSockets : SmallInt;
    iMaxUdpDg : SmallInt;
    lpVendorInfo : PChar;
  end;

const
  IP_OPTIONS        = 1;
  INADDR_ANY        = 0;
  INADDR_LOOPBACK   = $7f000001;
  INADDR_BROADCAST  = $ffffffff;
  INADDR_NONE       = $ffffffff;

  INVALID_SOCKET    = TSock(NOT(0));
  SOCKET_ERROR      = -1;

  SOCK_STREAM    =   1;
  SOCK_DGRAM     =   2;
  SOCK_RAW       =   3;
  SOCK_RDM       =   4;
  SOCK_SEQPACKET =   5;

  SO_DEBUG       =   $0001;
  SO_ACCEPTCONN  =   $0002;
  SO_REUSEADDR   =   $0004;
  SO_KEEPALIVE   =   $0008;
  SO_DONTROUTE   =   $0010;
  SO_BROADCAST   =   $0020;
  SO_USELOOPBACK =   $0040;
  SO_LINGER      =   $0080;
  SO_OOBINLINE   =   $0100;

  SO_DONTLINGER  =   $ff7f;

  SO_SNDBUF      =   $1001;
  SO_RCVBUF      =   $1002;
  SO_SNDLOWAT    =   $1003;
  SO_RCVLOWAT    =   $1004;
  SO_SNDTIMEO    =   $1005;
  SO_RCVTIMEO    =   $1006;
  SO_ERROR       =   $1007;
  SO_TYPE        =   $1008;

  AF_UNSPEC      =   0;
  AF_UNIX        =   1;
  AF_INET        =   2;
  AF_IMPLINK     =   3;
  AF_PUP         =   4;
  AF_CHAOS       =   5;
  AF_NS          =   6;
  AF_NBS         =   7;
  AF_ECMA        =   8;
  AF_DATAKIT     =   9;
  AF_CCITT       =   10;
  AF_SNA         =   11;
  AF_DECnet      =   12;
  AF_DLI         =   13;
  AF_LAT         =   14;
  AF_HYLINK      =   15;
  AF_APPLETALK   =   16;

  AF_MAX         =   17;

type
  sockaddr = record
    sa_family : Word;
    sa_data : array[0..13] of char; { should be 0..13 ?}
  end;

  sockproto = record
    sp_family : Word;
    sp_protocol : Word;
  end;

const
  PF_UNSPEC      =   AF_UNSPEC;
  PF_UNIX        =   AF_UNIX;
  PF_INET        =   AF_INET;
  PF_IMPLINK     =   AF_IMPLINK;
  PF_PUP         =   AF_PUP;
  PF_CHAOS       =   AF_CHAOS;
  PF_NS          =   AF_NS;
  PF_NBS         =   AF_NBS;
  PF_ECMA        =   AF_ECMA;
  PF_DATAKIT     =   AF_DATAKIT;
  PF_CCITT       =   AF_CCITT;
  PF_SNA         =   AF_SNA;
  PF_DECnet      =   AF_DECnet;
  PF_DLI         =   AF_DLI;
  PF_LAT         =   AF_LAT;
  PF_HYLINK      =   AF_HYLINK;
  PF_APPLETALK   =   AF_APPLETALK;

  PF_MAX         =   AF_MAX;

type
  linger = record
    l_onoff : Word;
    l_linger : Word;
  end;

const
  SOL_SOCKET     =   $ffff;

  SOMAXCONN      =   5;

  MSG_OOB        =   $1;
  MSG_PEEK       =   $2;
  MSG_DONTROUTE  =   $4;

  MSG_MAXIOVLEN  =   16;

  FD_READ            =  $01;
  FD_WRITE           =  $02;
  FD_OOB             =  $04;
  FD_ACCEPT          =  $08;
  FD_CONNECT         =  $10;
  FD_CLOSE           =  $20;


type
  Pint = ^Integer;   {msc}
  PSockAddr = ^SockAddr;
  PSockAddr_In = ^SockAddr_In;
  PLinger = ^Linger;
  PIn_Addr = ^In_Addr;
  PFD_SET = ^FD_SET;
  PHostEnt = ^HostEnt;
  PServEnt = ^ServEnt;
  PProtoEnt = ^ProtoEnt;


function accept( s: TSock; addr: PSockaddr; addrlen: Pint ): TSock;
function bind( s: TSock; addr: Psockaddr; namelen: Integer ): Integer;
function closesocket( s: TSock ): Integer;
function connect( s: TSock; name: Psockaddr; namelen: integer ): integer;
function ioctlsocket( s: TSock; cmd: longint; var argp ): Integer;
function getpeername( s: TSock; name: Psockaddr; namelen: Pint ): Integer;
function getsockname( s: TSock; name: Psockaddr; namelen: Pint ): Integer;
function getsockopt( s: TSock; level, optname: Integer; optval: PChar;
                     optlen: Integer ): Integer;
function htonl( hostlong: LongInt ): LongInt;
function htons( hostshort: Word ): Word;
function inet_addr( cp: PChar ): LongInt;
function inet_ntoa( inaddr: in_addr ): PChar;
function listen( s: TSock; backlog: Integer ): Integer;
function ntohl( netlong: LongInt ): LongInt;
function ntohs( netshort: Word ): Word;
function recv( s: TSock; buf: PChar; len, flags: Integer ): Integer;
function recvfrom( s: TSock; buf: PChar; len, flags: Integer;
                   from: sockaddr; fromlen: Integer ): Integer;
function select( nfds: Integer; readfds, writefds, exceptfds: fd_set;
                 timeout: timeval ): longint;
function send( s: TSock; buf: PChar; len, flags: Integer ): Integer;
function sendto( s: TSock; buf: PChar; len, flags: Integer;
                 addrto: sockaddr; tolen: Integer ): Integer;
function setsockopt( s: TSock; level, optname: Integer; optval: PChar;
                    optlen: Integer ): Integer;
function shutdown( s: TSock; how: Integer ): Integer;
function socket( af, struct, protocol: Integer ): TSock;
function gethostbyaddr( addr: PChar; len, struct: Integer ): PHostEnt;
function gethostbyname( name: PChar ): PHostEnt;
function gethostname( name: PChar; len: Integer ): Integer;
function getservbyport( port: Integer; proto: PChar ): PServEnt;
function getservbyname( name, proto: PChar ): PServEnt;
function getprotobynumber( proto: Integer ): PProtoEnt;
function getprotobyname( name: PChar ): PProtoEnt;
function WSAStartup( wVersionRequired: word; lpWSData: LPWSADATA ): Integer;
function WSACleanup: Integer;
procedure WSASetLastError( iError: Integer );
function WSAGetLastError: Integer;
function WSAIsBlocking: BOOL;
function WSAUnhookBlockingHook: Integer;
function WSASetBlockingHook( lpBlockFunc: TFarProc ): TFarProc;
function WSACancelBlockingCall: Integer;
function WSAAsyncGetServByName( HWindow: HWND; wMsg: u_int; name, proto,
                                buf: PChar; buflen: Integer ): THandle;
function WSAAsyncGetServByPort(  HWindow: HWND; wMsg: u_int; port: integer; proto,
                                 buf: PChar; buflen: Integer ): THandle;
function WSAAsyncGetProtoByName( HWindow: HWND; wMsg: u_int; name,
                                 buf: PChar; buflen: Integer ): THandle;
function WSAAsyncGetProtoByNumber( HWindow: HWND; wMsg: u_int; number: Integer;
                                   buf: PChar; buflen: Integer ): THandle;
function WSAAsyncGetHostByName( HWindow: HWND; wMsg: u_int; name,
                                buf: PChar; buflen: Integer ): THandle;
function WSAAsyncGetHostByAddr( HWindow: HWND; wMsg: u_int; addr: PChar;
                                len, struct: Integer; buf: PChar;
                                buflen: Integer ): THandle;
function WSACancelAsyncRequest( hAsyncTaskHandle: THandle ): Integer;
function WSAAsyncSelect( s: TSock; HWindow: HWND; wMsg: u_int;
                         lEvent: longint ): Integer;

{ Delphi functions for C macros }
function WSAMakeAsyncReply( Buflen, Error: Word ): LongInt;
function WSAMakeSelectReply( Event, Error: Word ): LongInt;
function WSAGetAsyncBuflen( Param: LongInt ): Word;
function WSAGetAsyncError( Param: LongInt ): Word;
function WSAGetSelectEvent( Param: LongInt ): Word;
function WSAGetSelectError( Param: LongInt ): Word;

implementation

function FIONBIO (x, y : SmallInt; t : LongInt) : LongInt;
begin
  FIONBIO := (IOC_IN OR ((IOCPARM_MASK shl 16) OR (x SHL 8) OR (Y)));
end;

function WSAMakeAsyncReply( Buflen, Error: Word ): LongInt;
begin
  WSAMakeAsyncReply := MakeLong (Buflen, Error);
end;

function WSAMakeSelectReply( Event, Error: Word ): LongInt;
begin
  WSAMakeSelectReply := MakeLong (Event, Error);
end;

function WSAGetAsyncBuflen( Param: LongInt ): Word;
begin
  WSAGetAsyncBuflen := LOWORD(Param);
end;

function WSAGetAsyncError( Param: LongInt ): Word;
begin
  WSAGetAsyncError := HIWORD(Param);
end;

function WSAGetSelectEvent( Param: LongInt ): Word;
begin
  WSAGetSelectEvent := LOWORD(Param);
end;

function WSAGetSelectError( Param: LongInt ): Word;
begin
  WSAGetSelectError := HIWORD(Param);
end;

const WinSockDLL = 'WINSOCK';

function accept;                   external    WinSockDLL index 1;
function bind;                     external    WinSockDLL index 2;
function closesocket;              external    WinSockDLL index 3;
function connect;                  external    WinSockDLL index 4;
function getpeername;              external    WinSockDLL index 5;
function getsockname;              external    WinSockDLL index 6;
function getsockopt;               external    WinSockDLL index 7;
function htonl;                    external    WinSockDLL index 8;
function htons;                    external    WinSockDLL index 9;
function inet_addr;                external    WinSockDLL index 10;
function inet_ntoa;                external    WinSockDLL index 11;
function ioctlsocket;              external    WinSockDLL index 12;
function listen;                   external    WinSockDLL index 13;
function ntohl;                    external    WinSockDLL index 14;
function ntohs;                    external    WinSockDLL index 15;
function recv;                     external    WinSockDLL index 16;
function recvfrom;                 external    WinSockDLL index 17;
function select;                   external    WinSockDLL index 18;
function send;                     external    WinSockDLL index 19;
function sendto;                   external    WinSockDLL index 20;
function setsockopt;               external    WinSockDLL index 21;
function shutdown;                 external    WinSockDLL index 22;
function socket;                   external    WinSockDLL index 23;

function gethostbyaddr;            external    WinSockDLL index 51;
function gethostbyname;            external    WinSockDLL index 52;
function getprotobyname;           external    WinSockDLL index 53;
function getprotobynumber;         external    WinSockDLL index 54;
function getservbyname;            external    WinSockDLL index 55;
function getservbyport;            external    WinSockDLL index 56;
function gethostname;              external    WinSockDLL index 57;

function WSAAsyncSelect;           external    WinSockDLL index 101;
function WSAAsyncGetHostByAddr;    external    WinSockDLL index 102;
function WSAAsyncGetHostByName;    external    WinSockDLL index 103;
function WSAAsyncGetProtoByNumber; external    WinSockDLL index 104;
function WSAAsyncGetprotoByName;   external    WinSockDLL index 105;
function WSAAsyncGetServByPort;    external    WinSockDLL index 106;
function WSAAsyncGetServByName;    external    WinSockDLL index 107;
function WSACancelAsyncRequest;    external    WinSockDLL index 108;
function WSASetBlockingHook;       external    WinSockDLL index 109;
function WSAUnhookBlockingHook;    external    WinSockDLL index 110;
function WSAGetLastError;          external    WinSockDLL index 111;
procedure WSASetLastError;         external    WinSockDLL index 112;
function WSACancelBlockingCall;    external    WinSockDLL index 113;
function WSAIsBlocking;            external    WinSockDLL index 114;
function WSAStartup;               external    WinSockDLL index 115;
function WSACleanup;               external    WinSockDLL index 116;

end.

