unit dwsError;

interface
{$R dwsError.RES}

const

  WSABASEERR         =  10000;

  WSAEINTR           =  (WSABASEERR + 4);
  WSAEBADF           =  (WSABASEERR + 9);
  WSAEACCES          =  (WSABASEERR + 13);
  WSAEFAULT          =  (WSABASEERR + 14);
  WSAEINVAL          =  (WSABASEERR + 22);
  WSAEMFILE          =  (WSABASEERR + 24);

  WSAEWOULDBLOCK     =  (WSABASEERR + 35);
  WSAEINPROGRESS     =  (WSABASEERR + 36);
  WSAEALREADY        =  (WSABASEERR + 37);
  WSAENOTSOCK        =  (WSABASEERR + 38);
  WSAEDESTADDRREQ    =  (WSABASEERR + 39);
  WSAEMSGSIZE        =  (WSABASEERR + 40);
  WSAEPROTOTYPE      =  (WSABASEERR + 41);
  WSAENOPROTOOPT     =  (WSABASEERR + 42);
  WSAEPROTONOSUPPORT =  (WSABASEERR + 43);
  WSAESOCKTNOSUPPORT =  (WSABASEERR + 44);
  WSAEOPNOTSUPP      =  (WSABASEERR + 45);
  WSAEPFNOSUPPORT    =  (WSABASEERR + 46);
  WSAEAFNOSUPPORT    =  (WSABASEERR + 47);
  WSAEADDRINUSE      =  (WSABASEERR + 48);
  WSAEADDRNOTAVAIL   =  (WSABASEERR + 49);
  WSAENETDOWN        =  (WSABASEERR + 50);
  WSAENETUNREACH     =  (WSABASEERR + 51);
  WSAENETRESET       =  (WSABASEERR + 52);
  WSAECONNABORTED    =  (WSABASEERR + 53);
  WSAECONNRESET      =  (WSABASEERR + 54);
  WSAENOBUFS         =  (WSABASEERR + 55);
  WSAEISCONN         =  (WSABASEERR + 56);
  WSAENOTCONN        =  (WSABASEERR + 57);
  WSAESHUTDOWN       =  (WSABASEERR + 58);
  WSAETOOMANYREFS    =  (WSABASEERR + 59);
  WSAETIMEDOUT       =  (WSABASEERR + 60);
  WSAECONNREFUSED    =  (WSABASEERR + 61);
  WSAELOOP           =  (WSABASEERR + 62);
  WSAENAMETOOLONG    =  (WSABASEERR + 63);
  WSAEHOSTDOWN       =  (WSABASEERR + 64);
  WSAEHOSTUNREACH    =  (WSABASEERR + 65);
  WSAENOTEMPTY       =  (WSABASEERR + 66);
  WSAEPROCLIM        =  (WSABASEERR + 67);
  WSAEUSERS          =  (WSABASEERR + 68);
  WSAEDQUOT          =  (WSABASEERR + 69);
  WSAESTALE          =  (WSABASEERR + 70);
  WSAEREMOTE         =  (WSABASEERR + 71);

  WSASYSNOTREADY     =  (WSABASEERR + 91);
  WSAVERNOTSUPPORTED =  (WSABASEERR + 92);
  WSANOTINITIALISED  =  (WSABASEERR + 93);

  WSAHOST_NOT_FOUND  =  (WSABASEERR + 1001);
  WSATRY_AGAIN       =  (WSABASEERR + 1002);
  WSANO_RECOVERY     =  (WSABASEERR + 1003);
  WSANO_DATA         =  (WSABASEERR + 1004);

  HOST_NOT_FOUND     =  WSAHOST_NOT_FOUND;
  TRY_AGAIN          =  WSATRY_AGAIN;
  NO_RECOVERY        =  WSANO_RECOVERY;
  NO_DATA            =  WSANO_DATA;

  WSANO_ADDRESS      =  WSANO_DATA;
  NO_ADDRESS         =  WSANO_ADDRESS;

  EWOULDBLOCK        =  WSAEWOULDBLOCK;
  EINPROGRESS        =  WSAEINPROGRESS;
  EALREADY           =  WSAEALREADY;
  ENOTSOCK           =  WSAENOTSOCK;
  EDESTADDRREQ       =  WSAEDESTADDRREQ;
  EMSGSIZE           =  WSAEMSGSIZE;
  EPROTOTYPE         =  WSAEPROTOTYPE;
  ENOPROTOOPT        =  WSAENOPROTOOPT;
  EPROTONOSUPPORT    =  WSAEPROTONOSUPPORT;
  ESOCKTNOSUPPORT    =  WSAESOCKTNOSUPPORT;
  EOPNOTSUPP         =  WSAEOPNOTSUPP;
  EPFNOSUPPORT       =  WSAEPFNOSUPPORT;
  EAFNOSUPPORT       =  WSAEAFNOSUPPORT;
  EADDRINUSE         =  WSAEADDRINUSE;
  EADDRNOTAVAIL      =  WSAEADDRNOTAVAIL;
  ENETDOWN           =  WSAENETDOWN;
  ENETUNREACH        =  WSAENETUNREACH;
  ENETRESET          =  WSAENETRESET;
  ECONNABORTED       =  WSAECONNABORTED;
  ECONNRESET         =  WSAECONNRESET;
  ENOBUFS            =  WSAENOBUFS;
  EISCONN            =  WSAEISCONN;
  ENOTCONN           =  WSAENOTCONN;
  ESHUTDOWN          =  WSAESHUTDOWN;
  ETOOMANYREFS       =  WSAETOOMANYREFS;
  ETIMEDOUT          =  WSAETIMEDOUT;
  ECONNREFUSED       =  WSAECONNREFUSED;
  ELOOP              =  WSAELOOP;
  ENAMETOOLONG       =  WSAENAMETOOLONG;
  EHOSTDOWN          =  WSAEHOSTDOWN;
  EHOSTUNREACH       =  WSAEHOSTUNREACH;
  ENOTEMPTY          =  WSAENOTEMPTY;
  EPROCLIM           =  WSAEPROCLIM;
  EUSERS             =  WSAEUSERS;
  EDQUOT             =  WSAEDQUOT;
  ESTALE             =  WSAESTALE;
  EREMOTE            =  WSAEREMOTE;

{ dWinSock error values -- Used to lookup Strings in dwsError.Res }
  DWSBaseErr               =  20000;
  DWSErrAsyncAddrToHost    = DWSBaseErr +  1;
  DWSErrAsyncGetHostByAddr = DWSBaseErr +  2;
  DWSErrAsyncGetHostByName = DWSBaseErr +  3;
  DWSErrAsyncGetServByName = DWSBaseErr +  4;
  DWSErrAsyncGetServByPort = DWSBaseErr +  5;
  DWSErrAsyncHostToAddr    = DWSBaseErr +  6;
  DWSErrBind               = DWSBaseErr +  7;
  DWSErrConnect            = DWSBaseErr +  8;
  DWSErrCreate             = DWSBaseErr +  9;
  DWSErrGetPeerName        = DWSBaseErr + 10;
  DWSErrGetSockName        = DWSBaseErr + 11;
  DWSErrInCount            = DWSBaseErr + 12;
  DWSErrListen             = DWSBaseErr + 13;
  DWSErrRecv               = DWSBaseErr + 14;
  DWSErrSend               = DWSBaseErr + 15;
  DWSErrStart              = DWSBaseErr + 16;
  DWSErrNoAddress          = DWSBaseErr + 17;
  DWSErrSockNotOpen        = DWSBaseErr + 18;
  DWSErrBasAddress         = DWSBaseErr + 19;
  DWSErrSockAlreadyOpen    = DWSBaseErr + 20;
implementation

end.
