{-------------------------------------------------------------------------------
  A unit that calculates the week number from a given date.

  written by:
  address: Hans G. Jorgensen, Herregaardsveien, 3745 Ulefoss, Norway.
  e-mail:  hans.g.jorgensen@hit.no or hans.g.jorgensen@tdh.no
  irc: Franze. See u at #Delphi :)

Readme:
  According to reliable sources this unit is supposed to be correct,
  but use it on your own risk.
  I DO NOT guarranty that it calculates the correct week number.

  This unit may be used in commercial programs.
  U can freely copy this unit as long as u don't charge any money and keep
  this heading.

  If u improve any part of the code, I would be glad for a copy.
  I also love postcards (hint). My address is above.

  This is not a VCL so don't install it. Just put the unit in your path (C:\DELPHI\LIB
  is a good place) or the directory of your project and add it to your project
  (use project manager).

  I didn't feel it was neccessary to make this as a VCL, since there would be
  only one property (date) and one method (function Date2WeekNumber(sDate: String): Integer;)
  and no event's (maybe BeforeCalculate, AfterCalculate and OnError).

  If u want this unit as a VCL, mail me and I'll convert it.

  version 1.0: Initial release.

-------------------------------------------------------------------------------}

unit Dte2wkno;

interface

uses SysUtils;

function Date2WeekNumber(sDate: String): Integer;

implementation

{I chose to send the date as a string, since I was working with a stringgrid.
U change change this to TDateTime if that suits your needs better.
Then u wont need the conversation in decodeDate}
function Date2WeekNumber(sDate: String): Integer;
var
  Year, Month, Day: Word;
  I, iNoOfDays, FirstDayOfYear: Integer;
  JanuaryFirst: TDateTime;
begin
  try
    decodeDate(StrToDate(sDate), year, Month, Day);
  except
{   Since I want my messages in norwegian I create my own exceptions}
{   raise EConvertError.create('Datoen er ikke gyldig.');}
    raise;
    exit;
  end;
  JanuaryFirst := encodeDate(year, 01, 01);
  FirstDayOfYear := DayOfWeek(JanuaryFirst);
  iNoOfDays := Integer(round(StrToDate(sDate)-JanuaryFirst));

  {This part is inspired by UDow1.pas which I got from Kurt Anneborg.}
  iNoOfDays := iNoOfDays+7-DayOfWeek(StrToDate(sDate)-1);
  if FirstDayOfYear in [2..5] then inc(iNoOfDays, 7);
  {- end -}

  result := (iNoOfDays div 7);

  case result of
  0: if (DayOfWeek(encodeDate(year-1, 01, 01)) > 5) or (DayOfWeek(encodeDate(year-1, 12, 31)) < 5) then begin
       {if there are no reason for 53 weeks}
       result := 52;
     end {if (DayOfWeek(encodeDate(year-1,  }
     else begin
       {otherwise}
       result := 53;
     end; {else (DayOfWeek(encodeDate(year-1, }
  53: if (FirstDayOfYear > 5) or (DayOfWeek(encodeDate(year, 12, 31)) < 5) then begin
        result := 1;
      end; {if (FirstDayOfYear > 5) or (}
  end; {case result of}
end; {function TFBooking.cfUkenummer(}

end.
