{=====================================================|
| DR Gauge - (c) 1996 by Alvaro L. S. Almeida         |
|-----------------------------------------------------|
| Gauge Component with progressive fill of the blocks |
| (the blocks are going appearing progressively).     |
| For Delphi 1, 2 e 3 (16 and 32 bits)                |
|                                                     |
| See other components in our home-page.              |
|-----------------------------------------------------|
| DROID Informatica ltda - Rio de Janeiro - Brazil    |
|                                                     |
| Home Page: http://www.di.com.br                     |
| E-Mail:    comp@di.com.br                           |
| Fax:       055 021 224-0331                         |
|=====================================================}

unit DRGauge;

interface

uses
  WinTypes, Classes, Graphics, Controls;

type
  TDRBorderStyle = (bsLowered, bsRaised, bsNone);
  TDRGap         = (gThin, gLarge);
  TDRBorderWidth = (bwThin, bwLarge);

  TDRGauge = class(TGraphicControl)
  private
    OldFillSize : LongInt;

    FLineWidth  : byte;
    FBlockWidth : byte;
    FMinValue   : Longint;
    FMaxValue   : Longint;
    FCurValue   : Longint;
    FGap        : TDRGap;
    FBorder     : byte;
    FBorderStyle: TDRBorderStyle;
    FBorderWidth: TDRBorderWidth;
    FForeColor  : TColor;
    FBackColor  : TColor;

    procedure SetGap(Value: TDRGap);
    procedure SetForeColor(Value: TColor);
    procedure SetBackColor(Value: TColor);
    procedure SetMinValue(Value: Longint);
    procedure SetMaxValue(Value: Longint);
    procedure SetBlockWidth(Value: byte);
    procedure SetProgress(Value: Longint);
    procedure SetBorderStyle(Value: TDRBorderStyle);
    procedure SetBorderWidth(Value: TDRBorderWidth);
    function  SolveForX(Z,y: Longint): Integer;
    function  GetPercentDone: Longint;

  protected
    procedure Paint; override;
    procedure Solve;

  public
    constructor Create(AOwner: TComponent); override;
    procedure AddProgress(Value: Longint);
    property PercentDone: Longint read GetPercentDone;

  published
    property Align;
    property Gap: TDRGap read FGap write SetGap default gThin;
    property ForeColor: TColor read FForeColor write SetForeColor default clNavy;
    property BackColor: TColor read FBackColor write SetBackColor default clSilver;
    property MinValue: Longint read FMinValue write SetMinValue default 0;
    property MaxValue: Longint read FMaxValue write SetMaxValue default 100;
    property BlockWidth: byte read FBlockWidth write SetBlockWidth default 15;
    property ParentColor;
    property ParentShowHint;
    property Progress: Longint read FCurValue write SetProgress;
    property BorderStyle: TDRBorderStyle read FBorderStyle write SetBorderStyle;
    property BorderWidth: TDRBorderWidth read FBorderWidth write SetBorderWidth;
    property ShowHint;
    property Visible;
  end;

  procedure Register;

implementation

uses
  ExtCtrls;

function TDRGauge.SolveForX(Z,y: Longint): Integer;
begin
  {SolveForX := Trunc( Z * (Y * 0.01) ); O pulo do bloco  maior assim }
  if (y = 0)
    then SolveForX := 0
    else SolveForX := Trunc((FCurValue-FMinValue) * z / y);
end;

constructor TDRGauge.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csFramed, csOpaque];

  canvas.Brush.Style := bsSolid;

  FMinValue    := 0;
  FMaxValue    := 100;
  FCurValue    := 0;
  FForeColor   := clNavy;
  FBackColor   := clBtnFace;
  FBlockWidth  := 15;
  FGap         := gThin;
  FBorderWidth := bwLarge;
  FBorderStyle := bsLowered;
  FBorder      := 2;
  FLineWidth   := 4;
  OldFillSize  := 4;

  Width        := 100;
  Height       := 18;
end;

function SolveForY(X, Z: Longint): Integer;
begin
  if Z = 0
    then SolveForY := 0
    else SolveForY := Trunc( (X * 100) / Z );
end;

function TDRGauge.GetPercentDone: Longint;
begin
  GetPercentDone := SolveForY(FCurValue - FMinValue, FMaxValue - FMinValue);
end;

procedure TDRGauge.Paint;
var
  frame : TRect;
begin
  canvas.brush.color := FBackColor;
  frame := Rect(0,0,width,height);
  canvas.FillRect(frame);

  if (FBorderStyle <> bsNone) then begin
    if (FBorderStyle = bsRaised)
      then Frame3D(canvas, frame, clWhite, clGray,  FBorder)
      else Frame3D(canvas, frame, clGray,  clWhite, FBorder)
  end;

  OldFillSize := FLineWidth;
  Solve;
end;

procedure TDRGauge.Solve;
var
  FillSize : Longint;
  W,H,I    : Integer;
begin
  with Canvas do begin
    pen.Color   := FForeColor;
    Brush.Color := FForeColor;

    h := height - FLineWidth;
    w := width  - FLineWidth-1;

    FillSize := SolveForX(w, FMaxValue - FMinValue);
    FillSize := FillSize + FLineWidth;
    if (FillSize > W) then FillSize := W;

    pen.width := 2;

    if (FillSize > 0) then begin
      if (FillSize < OldFillSize) then begin
        OldFillSize := FillSize-(OldFillSize-FillSize);
        if (OldFillSize < FLineWidth) then OldFillSize := FLineWidth;

        Brush.Color := FBackColor;
        pen.Color   := FBackColor;
        Polygon([Point(FillSize, FLineWidth),
                 Point(W, FLineWidth),
                 Point(W, H),
                 Point(FillSize, H)]);
      end;

      if (FillSize <> OldFillSize) then begin
        pen.Color   := FForeColor;
        Brush.Color := FForeColor;
        Polygon([Point(OldFillSize, FLineWidth),
                 Point(FillSize, FLineWidth),
                 Point(FillSize, H),
                 Point(OldFillSize, H)]);

        if (FGap = gLarge)
          then pen.width := 3;

        for i := OldFillSize-1 to FillSize do
          if ((i mod FBlockWidth) = 2) then begin
            pen.Color := FBackColor;
            MoveTo(i, FLineWidth);
            LineTo(i, H);
            pen.Color := FForeColor;
          end;
      end;

      OldFillSize := FillSize;
    end
    else begin
      OldFillSize := FLineWidth;
      canvas.brush.color := FBackColor;
      canvas.FillRect(Rect(FBorder,FBorder,width-FBorder,height-FBorder));
    end;
  end;
end;

procedure TDRGauge.SetBlockWidth(Value: byte);
begin
  if (Value <> FBlockWidth) and (value in [5..50]) then begin
    FBlockWidth := Value;
    Refresh;
  end;
end;

procedure TDRGauge.SetGap(Value: TDRGap);
begin
  if Value <> FGap then begin
    FGap := Value;
    Refresh;
  end;
end;

procedure TDRGauge.SetForeColor(Value: TColor);
begin
  if Value <> FForeColor then begin
    FForeColor := Value;
    Refresh;
  end;
end;

procedure TDRGauge.SetBackColor(Value: TColor);
begin
  if Value <> FBackColor then begin
    FBackColor := Value;
    Refresh;
  end;
end;

procedure TDRGauge.SetMinValue(Value: Longint);
begin
  if Value <> FMinValue then begin
    FMinValue := Value;
    Refresh;
  end;
end;

procedure TDRGauge.SetMaxValue(Value: Longint);
begin
  if Value <> FMaxValue then begin
    FMaxValue := Value;
    Refresh;
  end;
end;

procedure TDRGauge.SetProgress(Value: Longint);
begin
  if (FCurValue <> Value) and (Value >= FMinValue) and (Value <= FMaxValue) then begin
    FCurValue := Value;
    Solve;
  end;
end;

procedure TDRGauge.SetBorderStyle(Value: TDRBorderStyle);
begin
  if (FBorderStyle <> Value) then begin
    FBorderStyle := Value;

    if (FBorderStyle = bsNone) then
      FLineWidth := 2
    else begin
      if (FBorderWidth = bwThin)
        then FLineWidth := 3
        else FLineWidth := 4;
    end;

    FBorder := FLineWidth - 2;
    Refresh;
  end;
end;

procedure TDRGauge.SetBorderWidth(Value: TDRBorderWidth);
begin
  if (FBorderWidth <> Value) then begin
    FBorderWidth := Value;

    if (FBorderWidth = bwThin)
      then FLineWidth := 3
      else FLineWidth := 4;

    FBorder := FLineWidth - 2;
    Refresh;
  end;
end;

procedure TDRGauge.AddProgress(Value: Longint);
begin
  Progress := FCurValue + Value;
end;

procedure Register;
begin
  RegisterComponents('DROID', [TDRGauge]);
end;

end.

